#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `vehicle_id` int(11) DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  `charge_category_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` int(11) DEFAULT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `discount` float(10,2) DEFAULT 0.00,
  `tax_percentage` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `net_amount` float(10,2) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `vehicle_id` (`vehicle_id`),
  KEY `generated_by` (`generated_by`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `charge_id` (`charge_id`),
  KEY `idx_contact_no` (`contact_no`),
  KEY `idx_vehicle_model` (`vehicle_model`),
  KEY `idx_driver` (`driver`),
  KEY `index_date` (`date`),
  KEY `index_call_from` (`call_from`),
  KEY `index_call_to` (`call_to`),
  KEY `index_charge_category_id` (`charge_category_id`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_discount` (`discount`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_amount` (`amount`),
  KEY `index_net_amount` (`net_amount`),
  CONSTRAINT `ambulance_call_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_2` FOREIGN KEY (`vehicle_id`) REFERENCES `vehicles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_4` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_5` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ambulance_call_ibfk_6` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: annual_calendar
#

DROP TABLE IF EXISTS `annual_calendar`;

CREATE TABLE `annual_calendar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `holiday_type` int(11) NOT NULL COMMENT '1 for holiday , 2 for activity , 3 for vacation',
  `from_date` datetime DEFAULT NULL,
  `to_date` datetime DEFAULT NULL,
  `description` text NOT NULL COMMENT 'Holiday Description',
  `is_active` int(11) NOT NULL DEFAULT 1 COMMENT '1 for active 0 for inactive',
  `holiday_color` varchar(200) NOT NULL,
  `front_site` int(11) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_holiday_type` (`holiday_type`),
  KEY `idx_created_by` (`created_by`),
  KEY `index_from_date` (`from_date`) USING BTREE,
  KEY `index_to_date` (`to_date`) USING BTREE,
  CONSTRAINT `annual_calendar_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: antenatal_examine
#

DROP TABLE IF EXISTS `antenatal_examine`;

CREATE TABLE `antenatal_examine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `primary_examine_id` int(11) NOT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `ipdid` int(11) DEFAULT NULL,
  `uter_size` varchar(250) DEFAULT NULL,
  `uterus_size` varchar(250) DEFAULT NULL,
  `presentation_position` varchar(250) DEFAULT NULL,
  `brim_presentation` varchar(250) DEFAULT NULL,
  `foeta_heart` varchar(250) DEFAULT NULL,
  `blood_pressure` varchar(250) DEFAULT NULL,
  `antenatal_oedema` varchar(250) DEFAULT NULL,
  `antenatal_weight` varchar(250) DEFAULT NULL,
  `urine_sugar` varchar(250) DEFAULT NULL,
  `urine` varchar(250) DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `next_visit` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipdid` (`ipdid`),
  KEY `index_uter_size` (`uter_size`),
  KEY `index_uterus_size` (`uterus_size`),
  KEY `index_presentation_position` (`presentation_position`),
  KEY `index_brim_presentation` (`brim_presentation`),
  KEY `index_foeta_heart` (`foeta_heart`),
  KEY `index_blood_pressure` (`blood_pressure`),
  KEY `index_antenatal_oedema` (`antenatal_oedema`),
  KEY `index_antenatal_weight` (`antenatal_weight`),
  KEY `index_urine_sugar` (`urine_sugar`),
  KEY `index_urine` (`urine`),
  KEY `primary_examine_id` (`primary_examine_id`),
  CONSTRAINT `antenatal_examine_ibfk_1` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `antenatal_examine_ibfk_2` FOREIGN KEY (`ipdid`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `antenatal_examine_ibfk_3` FOREIGN KEY (`primary_examine_id`) REFERENCES `primary_examine` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_appoint_priority` (`appoint_priority`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (1, 'Normal', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (2, 'Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (3, 'Very Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (5, 'Low', '2021-09-24 15:28:40');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` int(11) DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` text DEFAULT NULL,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `is_opd` varchar(10) NOT NULL,
  `is_ipd` varchar(10) NOT NULL,
  `doctor_shift_time_id` int(11) DEFAULT NULL,
  `doctor_global_shift_id` int(11) DEFAULT NULL,
  `is_queue` int(11) DEFAULT NULL,
  `created_time` datetime DEFAULT NULL,
  `rejected_time` datetime DEFAULT NULL,
  `live_consult` varchar(50) DEFAULT NULL,
  `live_consult_link` int(11) NOT NULL DEFAULT 1 COMMENT '1 (link created) 0 (not created)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor` (`doctor`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `doctor_shift_time_id` (`doctor_shift_time_id`),
  CONSTRAINT `appointment_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_2` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_4` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_5` FOREIGN KEY (`doctor_shift_time_id`) REFERENCES `doctor_shift_time` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (2, 1, 5, 5, '2025-06-25 12:43:00', '1', '1', 3, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:17:11');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (3, 1, NULL, NULL, '2025-06-26 12:51:00', '1', '1', 3, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:20:32');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (4, 1, NULL, NULL, '2025-06-26 12:51:00', '1', '1', 3, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:20:55');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (5, 1, 6, 6, '2025-06-26 12:52:00', '1', '1', 3, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:22:13');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (6, 1, NULL, NULL, '2025-06-26 12:55:00', '1', '1', 3, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:24:32');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (7, 1, NULL, NULL, '2025-06-25 10:24:00', '1', '1', 2, '', '', 'approved', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:24:33');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (8, 1, NULL, NULL, '2025-06-25 10:24:00', '1', '1', 2, '', '', 'approved', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:24:40');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (9, 1, 7, 7, '2025-06-26 12:55:00', '1', '1', 3, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:24:43');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (10, 2, NULL, NULL, '2025-06-25 10:26:00', '2', '1', 2, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:25:59');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (11, 2, NULL, NULL, '2025-06-25 10:26:00', '2', '1', 2, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:26:04');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (12, 2, NULL, NULL, '2025-06-25 10:26:00', '2', '1', 2, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:26:12');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (13, 1, 8, 8, '2025-06-26 13:00:00', '1', '1', 3, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:30:21');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (15, 1, NULL, NULL, '2025-06-26 13:03:00', '1', '1', 3, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:33:20');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (16, 1, 10, 10, '2025-06-26 13:03:00', '1', '1', 3, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:33:42');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (17, 2, NULL, NULL, '2025-06-26 13:05:00', '1', '1', 3, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:34:51');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (18, 2, NULL, NULL, '2025-06-26 13:05:00', '1', '1', 3, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-06-25 09:35:15');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (19, 3, NULL, NULL, '2025-06-27 10:38:00', '1', '1', 3, '', '', 'approved', 'Offline', '', '', NULL, 3, 0, NULL, NULL, 'no', 1, '2025-06-25 09:38:29');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (21, 2, NULL, NULL, '2025-06-30 10:41:00', '1', '1', 3, '', '', 'approved', 'Offline', '', '', NULL, 3, 0, NULL, NULL, 'no', 1, '2025-06-25 09:40:57');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (25, 130, 136, 136, '2025-07-24 15:41:00', '1', '1', 3, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-07-17 14:41:41');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (27, 131, 139, 139, '2025-07-31 15:50:00', '1', '1', 2, '', '', 'pending', 'Offline', '', '', NULL, 0, 0, NULL, NULL, 'no', 1, '2025-07-17 14:50:10');


#
# TABLE STRUCTURE FOR: appointment_payment
#

DROP TABLE IF EXISTS `appointment_payment`;

CREATE TABLE `appointment_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_amount` float(10,2) NOT NULL DEFAULT 0.00,
  `tax` float(10,2) NOT NULL DEFAULT 0.00,
  `discount_percentage` float(10,2) NOT NULL DEFAULT 0.00,
  `paid_amount` float(10,2) NOT NULL,
  `payment_mode` varchar(50) DEFAULT NULL,
  `payment_type` varchar(100) NOT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `note` varchar(100) DEFAULT NULL,
  `date` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_id` (`charge_id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `index_standard_amount` (`standard_amount`),
  KEY `index_tax` (`tax`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_paid_amount` (`paid_amount`),
  KEY `index_payment_mode` (`payment_mode`),
  KEY `index_payment_type` (`payment_type`),
  CONSTRAINT `appointment_payment_ibfk_2` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_payment_ibfk_3` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `standard_amount`, `tax`, `discount_percentage`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`, `created_at`) VALUES (12, 25, 24, '0.00', '0.00', '0.00', '0.00', NULL, 'Offline', NULL, NULL, '2025-07-17 15:41:41', '2025-07-17 14:41:41');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `standard_amount`, `tax`, `discount_percentage`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`, `created_at`) VALUES (14, 27, 24, '0.00', '0.00', '0.00', '0.00', NULL, 'Offline', NULL, NULL, '2025-07-17 15:50:10', '2025-07-17 14:50:10');


#
# TABLE STRUCTURE FOR: appointment_queue
#

DROP TABLE IF EXISTS `appointment_queue`;

CREATE TABLE `appointment_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `date` date NOT NULL DEFAULT '2021-01-11',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `staff_id` (`staff_id`),
  KEY `global_shift_id` (`shift_id`),
  CONSTRAINT `appointment_queue_ibfk_1` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_3` FOREIGN KEY (`shift_id`) REFERENCES `doctor_shift_time` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int(11) DEFAULT NULL,
  `bed_group_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `bed_type_id` (`bed_type_id`),
  KEY `bed_group_id` (`bed_group_id`),
  KEY `index_name` (`name`),
  CONSTRAINT `bed_ibfk_1` FOREIGN KEY (`bed_type_id`) REFERENCES `bed_type` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bed_ibfk_2` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bed_ibfk_3` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `color` varchar(50) NOT NULL DEFAULT '#f4f4f4',
  `description` text NOT NULL,
  `floor` int(11) NOT NULL,
  `is_active` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_color` (`color`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: bill
#

DROP TABLE IF EXISTS `bill`;

CREATE TABLE `bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case_id` int(11) NOT NULL,
  `attachment` mediumtext DEFAULT NULL,
  `attachment_name` mediumtext DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `payment_mode` varchar(100) DEFAULT NULL,
  `cheque_no` varchar(100) DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `note` mediumtext DEFAULT NULL,
  `received_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_id` (`case_id`),
  CONSTRAINT `bill_ibfk_1` FOREIGN KEY (`case_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `child_name` varchar(200) NOT NULL,
  `child_pic` text NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime DEFAULT NULL,
  `weight` varchar(200) NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `contact` varchar(20) NOT NULL,
  `mother_pic` text NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` text NOT NULL,
  `birth_report` mediumtext DEFAULT NULL,
  `document` text NOT NULL,
  `address` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  KEY `index_child_name` (`child_name`),
  KEY `index_gender` (`gender`),
  KEY `index_weight` (`weight`),
  KEY `index_contact` (`contact`),
  CONSTRAINT `birth_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `birth_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: blood_bank_products
#

DROP TABLE IF EXISTS `blood_bank_products`;

CREATE TABLE `blood_bank_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `is_blood_group` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `index_donor_name` (`donor_name`),
  KEY `index_gender` (`gender`),
  KEY `index_father_name` (`father_name`),
  KEY `index_contact_no` (`contact_no`),
  CONSTRAINT `blood_donor_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_donor_cycle_id` int(11) NOT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `blood_donor_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `donate_date` date DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) DEFAULT NULL,
  `apply_charge` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `institution` text DEFAULT NULL,
  `note` text DEFAULT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `tax_percentage` float(10,2) DEFAULT 0.00,
  `volume` varchar(100) DEFAULT NULL,
  `unit` int(11) DEFAULT NULL,
  `available` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `blood_donor_id` (`blood_donor_id`),
  KEY `charge_id` (`charge_id`),
  KEY `index_bag_no` (`bag_no`),
  KEY `index_lot` (`lot`),
  KEY `index_amount` (`amount`),
  KEY `index_unit` (`unit`),
  KEY `index_volume` (`volume`),
  KEY `index_quantity` (`quantity`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_apply_charge` (`apply_charge`),
  CONSTRAINT `blood_donor_cycle_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_2` FOREIGN KEY (`blood_donor_id`) REFERENCES `blood_donor` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_3` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `blood_donor_cycle_id` int(11) DEFAULT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `hospital_doctor` int(11) DEFAULT NULL,
  `reference` text DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` int(11) NOT NULL,
  `tax_percentage` float(10,2) NOT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `amount` float(10,2) DEFAULT NULL,
  `net_amount` float(10,2) NOT NULL,
  `institution` text DEFAULT NULL,
  `technician` text DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `blood_donor_cycle_id` (`blood_donor_cycle_id`),
  KEY `patient_id` (`patient_id`),
  KEY `charge_id` (`charge_id`),
  KEY `generated_by` (`generated_by`),
  KEY `organisation_id` (`organisation_id`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_amount` (`amount`),
  KEY `index_net_amount` (`net_amount`),
  KEY `hospital_doctor` (`hospital_doctor`),
  CONSTRAINT `blood_issue_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_2` FOREIGN KEY (`blood_donor_cycle_id`) REFERENCES `blood_donor_cycle` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_4` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_5` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_6` FOREIGN KEY (`organisation_id`) REFERENCES `organisation` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_7` FOREIGN KEY (`hospital_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (1, 'userlogin', 0, '2021-10-22 07:21:32');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (2, 'login', 0, '2021-10-22 07:21:38');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (3, 'appointment', 0, '2021-10-22 07:21:40');


#
# TABLE STRUCTURE FOR: case_references
#

DROP TABLE IF EXISTS `case_references`;

CREATE TABLE `case_references` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_id` int(11) DEFAULT NULL,
  `discount_percentage` float(10,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_references_ibfk_1` (`bill_id`),
  CONSTRAINT `case_references_ibfk_1` FOREIGN KEY (`bill_id`) REFERENCES `bill` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=140 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (1, NULL, '0.00', '2025-06-24 13:55:38');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (2, NULL, '0.00', '2025-06-24 18:38:32');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (3, NULL, '0.00', '2025-06-24 18:42:46');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (4, NULL, '0.00', '2025-06-25 08:10:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (5, NULL, '0.00', '2025-06-25 09:17:11');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (6, NULL, '0.00', '2025-06-25 09:22:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (7, NULL, '0.00', '2025-06-25 09:24:43');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (8, NULL, '0.00', '2025-06-25 09:30:21');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (9, NULL, '0.00', '2025-06-25 09:30:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (10, NULL, '0.00', '2025-06-25 09:33:42');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (11, NULL, '0.00', '2025-06-25 09:38:40');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (12, NULL, '0.00', '2025-06-25 09:45:27');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (13, NULL, '0.00', '2025-06-25 09:45:43');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (14, NULL, '0.00', '2025-06-25 11:45:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (15, NULL, '0.00', '2025-06-25 11:56:18');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (16, NULL, '0.00', '2025-06-25 11:56:22');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (17, NULL, '0.00', '2025-06-25 12:01:56');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (18, NULL, '0.00', '2025-06-25 12:01:59');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (19, NULL, '0.00', '2025-07-01 15:42:31');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (20, NULL, '0.00', '2025-07-01 15:52:15');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (21, NULL, '0.00', '2025-07-01 15:55:06');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (22, NULL, '0.00', '2025-07-01 15:58:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (23, NULL, '0.00', '2025-07-01 16:05:15');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (24, NULL, '0.00', '2025-07-01 16:07:21');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (25, NULL, '0.00', '2025-07-01 16:09:11');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (26, NULL, '0.00', '2025-07-01 16:33:32');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (27, NULL, '0.00', '2025-07-02 10:46:29');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (28, NULL, '0.00', '2025-07-02 12:43:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (29, NULL, '0.00', '2025-07-02 12:50:24');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (30, NULL, '0.00', '2025-07-02 15:26:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (31, NULL, '0.00', '2025-07-02 18:14:38');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (32, NULL, '0.00', '2025-07-02 18:20:09');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (33, NULL, '0.00', '2025-07-03 13:12:22');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (34, NULL, '0.00', '2025-07-03 13:21:39');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (35, NULL, '0.00', '2025-07-03 13:34:47');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (36, NULL, '0.00', '2025-07-03 13:39:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (37, NULL, '0.00', '2025-07-03 13:41:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (38, NULL, '0.00', '2025-07-03 15:43:36');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (39, NULL, '0.00', '2025-07-03 15:48:32');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (40, NULL, '0.00', '2025-07-03 17:51:34');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (41, NULL, '0.00', '2025-07-03 17:55:04');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (42, NULL, '0.00', '2025-07-03 18:21:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (43, NULL, '0.00', '2025-07-04 11:19:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (44, NULL, '0.00', '2025-07-04 13:25:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (45, NULL, '0.00', '2025-07-04 13:28:44');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (46, NULL, '0.00', '2025-07-04 13:30:24');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (47, NULL, '0.00', '2025-07-04 13:31:51');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (48, NULL, '0.00', '2025-07-04 17:55:56');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (49, NULL, '0.00', '2025-07-04 17:57:26');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (50, NULL, '0.00', '2025-07-04 18:00:41');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (51, NULL, '0.00', '2025-07-05 17:32:59');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (52, NULL, '0.00', '2025-07-05 17:34:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (53, NULL, '0.00', '2025-07-05 17:42:23');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (54, NULL, '0.00', '2025-07-05 17:43:57');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (55, NULL, '0.00', '2025-07-05 17:45:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (56, NULL, '0.00', '2025-07-05 17:46:53');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (57, NULL, '0.00', '2025-07-05 17:48:20');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (58, NULL, '0.00', '2025-07-05 17:49:31');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (59, NULL, '0.00', '2025-07-05 17:51:10');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (60, NULL, '0.00', '2025-07-05 17:53:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (61, NULL, '0.00', '2025-07-05 17:54:52');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (62, NULL, '0.00', '2025-07-06 16:51:31');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (63, NULL, '0.00', '2025-07-06 16:53:10');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (64, NULL, '0.00', '2025-07-06 16:55:27');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (65, NULL, '0.00', '2025-07-06 16:56:43');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (66, NULL, '0.00', '2025-07-06 16:58:11');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (67, NULL, '0.00', '2025-07-06 16:59:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (68, NULL, '0.00', '2025-07-06 17:01:08');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (69, NULL, '0.00', '2025-07-06 17:02:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (70, NULL, '0.00', '2025-07-07 17:41:55');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (71, NULL, '0.00', '2025-07-07 17:43:25');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (72, NULL, '0.00', '2025-07-07 17:44:39');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (73, NULL, '0.00', '2025-07-07 17:45:37');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (74, NULL, '0.00', '2025-07-07 17:47:33');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (75, NULL, '0.00', '2025-07-07 17:49:26');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (76, NULL, '0.00', '2025-07-07 17:50:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (77, NULL, '0.00', '2025-07-07 17:52:33');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (78, NULL, '0.00', '2025-07-07 17:53:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (79, NULL, '0.00', '2025-07-07 17:55:27');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (80, NULL, '0.00', '2025-07-07 17:56:18');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (81, NULL, '0.00', '2025-07-08 18:14:39');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (82, NULL, '0.00', '2025-07-08 18:15:42');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (83, NULL, '0.00', '2025-07-08 18:20:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (84, NULL, '0.00', '2025-07-08 18:22:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (85, NULL, '0.00', '2025-07-09 16:55:41');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (86, NULL, '0.00', '2025-07-09 16:56:57');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (87, NULL, '0.00', '2025-07-09 16:58:33');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (88, NULL, '0.00', '2025-07-09 17:00:28');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (89, NULL, '0.00', '2025-07-09 17:03:11');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (90, NULL, '0.00', '2025-07-09 17:07:51');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (91, NULL, '0.00', '2025-07-09 17:12:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (92, NULL, '0.00', '2025-07-09 17:14:36');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (93, NULL, '0.00', '2025-07-09 17:22:21');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (94, NULL, '0.00', '2025-07-09 19:27:44');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (95, NULL, '0.00', '2025-07-10 19:44:19');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (96, NULL, '0.00', '2025-07-10 19:46:22');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (97, NULL, '0.00', '2025-07-10 21:00:46');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (98, NULL, '0.00', '2025-07-10 21:02:21');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (99, NULL, '0.00', '2025-07-12 08:28:24');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (100, NULL, '0.00', '2025-07-12 08:32:06');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (101, NULL, '0.00', '2025-07-12 08:36:52');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (102, NULL, '0.00', '2025-07-12 08:38:34');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (103, NULL, '0.00', '2025-07-12 17:48:39');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (104, NULL, '0.00', '2025-07-12 17:50:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (105, NULL, '0.00', '2025-07-12 17:51:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (106, NULL, '0.00', '2025-07-12 17:53:01');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (107, NULL, '0.00', '2025-07-12 17:55:39');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (108, NULL, '0.00', '2025-07-13 17:02:42');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (109, NULL, '0.00', '2025-07-13 17:09:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (110, NULL, '0.00', '2025-07-13 17:13:59');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (111, NULL, '0.00', '2025-07-13 17:15:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (112, NULL, '0.00', '2025-07-13 17:17:16');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (113, NULL, '0.00', '2025-07-14 17:56:54');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (114, NULL, '0.00', '2025-07-14 17:58:57');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (115, NULL, '0.00', '2025-07-14 18:01:03');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (116, NULL, '0.00', '2025-07-14 18:03:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (117, NULL, '0.00', '2025-07-14 18:04:35');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (118, NULL, '0.00', '2025-07-14 18:05:51');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (119, NULL, '0.00', '2025-07-14 18:07:03');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (120, NULL, '0.00', '2025-07-14 18:08:26');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (121, NULL, '0.00', '2025-07-16 18:13:15');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (122, NULL, '0.00', '2025-07-16 18:15:24');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (123, NULL, '0.00', '2025-07-16 18:31:11');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (124, NULL, '0.00', '2025-07-16 18:32:53');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (125, NULL, '0.00', '2025-07-16 18:34:11');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (126, NULL, '0.00', '2025-07-16 18:35:26');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (127, NULL, '0.00', '2025-07-16 18:37:32');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (128, NULL, '0.00', '2025-07-16 18:39:07');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (129, NULL, '0.00', '2025-07-16 18:40:15');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (130, NULL, '0.00', '2025-07-16 18:41:34');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (131, NULL, '0.00', '2025-07-16 18:43:02');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (132, NULL, '0.00', '2025-07-16 18:45:06');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (133, NULL, '0.00', '2025-07-16 18:47:28');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (134, NULL, '0.00', '2025-07-16 18:49:31');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (135, NULL, '0.00', '2025-07-17 14:40:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (136, NULL, '0.00', '2025-07-17 14:41:41');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (137, NULL, '0.00', '2025-07-17 14:46:36');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (138, NULL, '0.00', '2025-07-17 14:49:01');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (139, NULL, '0.00', '2025-07-17 14:50:10');


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text DEFAULT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` text NOT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = patients',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_patient_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  `updated_at` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (12, 'Sample Patient File Cover', '<table class=\"table table-bordered\" width=\"100%\">\r\n <tr>\r\n  <td width=\"50%\">Patient Name  </td>\r\n  <td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', 'certificate.jpg', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2021-10-29 00:58:45');


#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_id` int(11) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `short_code` varchar(30) DEFAULT NULL,
  `is_default` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_type_id` (`charge_type_id`),
  KEY `index_name` (`name`),
  CONSTRAINT `charge_categories_ibfk_1` FOREIGN KEY (`charge_type_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (1, 2, 'Dental Procedures(Adult)', 'Procedures', NULL, '', '2025-06-24 13:51:00');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (2, 2, 'Tooth Replacement', 'Replacement', NULL, '', '2025-06-24 13:50:51');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (3, 2, 'FILLING', 'FILLING', NULL, '', '2025-06-24 13:50:44');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (4, 2, 'MASKING', 'MASKING', NULL, '', '2025-06-24 13:50:36');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (5, 2, 'ROOT CANAL TREATMENT', 'ROOT CANAL TREATMENT', NULL, '', '2025-06-24 13:50:28');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (6, 2, 'DENTURE REPAIRS', 'DENTURE REPAIRS', NULL, '', '2025-06-24 13:50:19');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (7, 2, 'SILVER CROWNS', 'SILVER CROWNS', NULL, '', '2025-06-24 13:50:11');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (8, 2, 'DENTAL XRAY', 'DENTAL XRAY', NULL, '', '2025-06-24 13:50:02');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (9, 2, 'RETAINERS', 'RETAINERS', NULL, '', '2025-06-24 13:49:43');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (10, 2, 'DRUGS FLOXAPEN', 'DRUGS', NULL, '', '2025-06-24 13:49:34');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (11, 2, 'MOUTH WASH 1', 'MOUTH WASH 1', NULL, '', '2025-06-24 13:49:25');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (12, 2, 'MOUTH WASH 2', 'MOUTH WASH 2', NULL, '', '2025-06-24 13:49:14');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (13, 2, 'BRACES ADJUSTMENT', 'BRACES ADJUSTMENT', NULL, '', '2025-06-24 13:48:37');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (14, 2, 'TOOTH EXTRACTION CHILDREN', 'TOOTH EXTRACTION CHILDREN', NULL, '', '2025-06-24 13:48:28');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (16, 1, 'Appointment', 'Appointment', NULL, '', NULL);


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `is_default` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_charge_type` (`charge_type`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (1, 'Appointment', 'yes', 'yes', '2021-09-24 16:10:32');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (2, 'OPD', 'yes', 'yes', '2021-09-24 16:10:02');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (3, 'IPD', 'yes', 'yes', '2021-09-24 16:10:47');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (4, 'Pathology', 'yes', 'yes', '2021-10-22 23:40:03');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (5, 'Radiology', 'yes', 'yes', '2021-10-23 00:10:21');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (6, 'Blood Bank', 'yes', 'yes', '2021-10-23 00:10:33');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (7, 'Ambulance', 'yes', 'yes', '2021-10-23 00:10:44');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (8, 'Procedures', 'yes', 'yes', '2018-08-17 15:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (9, 'Investigations', 'yes', 'yes', '2018-08-17 15:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (10, 'Supplier', 'yes', 'yes', '2018-08-17 15:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (11, 'Operations', 'yes', 'yes', '2018-08-17 15:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (12, 'Others', 'yes', 'yes', '2018-08-17 15:40:07');


#
# TABLE STRUCTURE FOR: charge_type_module
#

DROP TABLE IF EXISTS `charge_type_module`;

CREATE TABLE `charge_type_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_master_id` int(11) DEFAULT NULL,
  `module_shortcode` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_type_master_id` (`charge_type_master_id`),
  CONSTRAINT `charge_type_module_ibfk_1` FOREIGN KEY (`charge_type_master_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (2, 1, 'appointment', '2021-10-23 05:52:42');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (4, 2, 'opd', '2021-10-23 05:52:45');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (10, 8, 'opd', '2021-10-23 05:53:03');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (15, 10, 'opd', '2021-10-23 05:53:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (17, 11, 'opd', '2021-10-23 05:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (19, 12, 'appointment', '2021-10-23 05:53:20');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (20, 12, 'opd', '2021-10-23 05:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (28, 2, 'appointment', '2025-06-23 11:03:04');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (29, 8, 'appointment', '2025-06-23 11:03:07');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (30, 9, 'appointment', '2025-06-23 11:03:11');


#
# TABLE STRUCTURE FOR: charge_units
#

DROP TABLE IF EXISTS `charge_units`;

CREATE TABLE `charge_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit` varchar(50) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_unit` (`unit`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (1, 'PROCEDURE', 0, '2025-06-23 11:25:35');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_category_id` int(11) DEFAULT NULL,
  `tax_category_id` int(11) DEFAULT NULL,
  `charge_unit_id` int(11) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `standard_charge` float(10,2) DEFAULT 0.00,
  `date` date DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_category_id` (`charge_category_id`),
  KEY `tax_category_id` (`tax_category_id`),
  KEY `charge_unit_id` (`charge_unit_id`),
  KEY `index_name` (`name`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_date` (`date`),
  CONSTRAINT `charges_ibfk_1` FOREIGN KEY (`charge_category_id`) REFERENCES `charge_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_2` FOREIGN KEY (`tax_category_id`) REFERENCES `tax_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_3` FOREIGN KEY (`charge_unit_id`) REFERENCES `charge_units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (1, 1, 1, 1, 'TOOTH EXTRACTION', '700.00', NULL, '', '', '2025-06-23 11:31:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (2, 1, 1, 1, 'SCALING & POLISHING', '2000.00', NULL, '', '', '2025-06-23 11:31:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (3, 1, 1, 1, 'BRACES', '15000.00', NULL, 'PER JAW', '', '2025-06-23 11:35:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (4, 1, 1, 1, 'WHITENING', '5000.00', NULL, '', '', '2025-06-23 11:36:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (5, 2, 1, 1, 'DENTURER', '1000.00', NULL, 'PER TEETH', '', '2025-06-23 11:37:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (6, 2, 1, 1, 'ACRYLIC CROWNS', '2500.00', NULL, 'PER UNIT', '', '2025-06-23 11:39:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (7, 2, 1, 1, 'PFM CROWNS', '7000.00', NULL, 'PER UNIT', '', '2025-06-23 11:42:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (8, 3, 1, 1, 'FILLING', '2000.00', NULL, '', '', '2025-06-23 12:50:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (9, 4, 1, 1, 'MASKING', '1000.00', NULL, 'PER TOOTH', '', '2025-06-23 12:51:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (10, 5, 1, 1, 'ROOT CANAL TREATMENT 1ST SESSION', '2000.00', NULL, '1ST SESSION', '', '2025-06-23 12:52:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (11, 5, 1, 1, 'ROOT CANAL TREATMENT 2ND SESSION', '1500.00', NULL, '2ND SESSION', '', '2025-06-23 12:54:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (12, 5, 1, 1, 'ROOT CANAL TREATMENT 3RD SESSION', '1000.00', NULL, '3RD SESSION', '', '2025-06-23 12:54:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (13, 6, 1, 1, 'DENTURE REPAIRS', '1000.00', NULL, '', '', '2025-06-23 12:56:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (14, 7, 1, 1, 'SILVER CROWNS', '1500.00', NULL, '', '', '2025-06-23 12:57:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (15, 8, 1, 1, 'DENTAL XRAY', '1000.00', NULL, '', '', '2025-06-23 12:58:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (16, 9, 1, 1, 'RETAINERS FIXED', '2500.00', NULL, '', '', '2025-06-23 12:59:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (17, 9, 1, 1, 'RETAINERS REMOVABLE', '3000.00', NULL, '', '', '2025-06-23 13:00:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (18, 10, 1, 1, 'DRUGS FLOXAPEN', '300.00', NULL, '', '', '2025-06-23 13:02:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (19, 11, 1, 1, 'MOUTH WASH 1', '500.00', NULL, '', '', '2025-06-23 13:03:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (20, 12, 1, 1, 'MOUTH WASH 2', '300.00', NULL, '', '', '2025-06-23 13:03:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (21, 13, 1, 1, 'BRACE ADJUSTMENT', '500.00', NULL, '', '', '2025-06-23 13:04:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (22, 14, 1, 1, 'TOOTH EXTRACTION CHILDREN', '500.00', NULL, '', '', '2025-06-23 13:04:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (24, 16, 1, 1, 'Appointment', '0.00', NULL, '', '', '2025-06-24 14:34:35');


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_user_one` int(11) NOT NULL,
  `chat_user_two` int(11) NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`),
  CONSTRAINT `chat_connections_ibfk_1` FOREIGN KEY (`chat_user_one`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_connections_ibfk_2` FOREIGN KEY (`chat_user_two`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `chat_user_id` int(11) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int(11) NOT NULL,
  `is_first` int(11) DEFAULT 0,
  `is_read` int(11) NOT NULL DEFAULT 0,
  `chat_connection_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`chat_user_id`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`chat_connection_id`) REFERENCES `chat_connections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_patient_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_patient_id` (`create_patient_id`),
  CONSTRAINT `chat_users_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_3` FOREIGN KEY (`create_staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_4` FOREIGN KEY (`create_patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type_id` int(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text DEFAULT NULL,
  `image` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `complaint_type_id` (`complaint_type_id`),
  CONSTRAINT `complaint_ibfk_1` FOREIGN KEY (`complaint_type_id`) REFERENCES `complaint_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_complaint_type` (`complaint_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `conference_staff_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conference_staff_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `created_id` int(11) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `date` datetime NOT NULL,
  `duration` int(11) NOT NULL,
  `password` varchar(100) NOT NULL,
  `host_video` int(11) NOT NULL,
  `client_video` int(11) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `timezone` text DEFAULT NULL,
  `return_response` text DEFAULT NULL,
  `api_type` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `live_consult_link` int(11) NOT NULL DEFAULT 1 COMMENT 'appointment zoom link for front user status',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `created_id` (`created_id`),
  CONSTRAINT `conferences_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_3` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_4` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_5` FOREIGN KEY (`created_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `total_hit` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `conferences_history_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `doctor` (`doctor`),
  CONSTRAINT `consult_charges_ibfk_1` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `ins_date` date DEFAULT NULL,
  `instruction` text DEFAULT NULL,
  `cons_doctor` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `cons_doctor` (`cons_doctor`),
  CONSTRAINT `consultant_register_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `consultant_register_ibfk_2` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: content_types
#

DROP TABLE IF EXISTS `content_types`;

CREATE TABLE `content_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `file` text DEFAULT NULL,
  `note` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(500) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  KEY `index_field_value` (`field_value`),
  KEY `index_belong_table_id` (`belong_table_id`),
  KEY `index_custom_field_id` (`custom_field_id`),
  CONSTRAINT `custom_field_values_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(11) DEFAULT NULL,
  `validation` int(11) DEFAULT 0,
  `field_values` mediumtext DEFAULT NULL,
  `visible_on_print` int(11) DEFAULT NULL,
  `visible_on_report` int(11) DEFAULT NULL,
  `visible_on_table` int(11) DEFAULT NULL,
  `visible_on_patient_panel` int(11) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_belong_to` (`belong_to`),
  KEY `index_type` (`type`),
  KEY `index_visible_on_table` (`visible_on_table`),
  KEY `index_visible_on_print` (`visible_on_print`),
  KEY `index_visible_on_report` (`visible_on_report`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: death_report
#

DROP TABLE IF EXISTS `death_report`;

CREATE TABLE `death_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `attachment` text NOT NULL,
  `attachment_name` text DEFAULT NULL,
  `death_date` datetime NOT NULL,
  `guardian_name` varchar(200) NOT NULL,
  `death_report` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `death_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `death_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_department_name` (`department_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (1, 'DENTISTRY', 'yes', '2025-06-23 13:07:20');


#
# TABLE STRUCTURE FOR: discharge_card
#

DROP TABLE IF EXISTS `discharge_card`;

CREATE TABLE `discharge_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case_reference_id` int(11) DEFAULT NULL,
  `opd_details_id` int(11) DEFAULT NULL,
  `ipd_details_id` int(11) DEFAULT NULL,
  `discharge_by` int(11) DEFAULT NULL,
  `discharge_date` datetime DEFAULT NULL,
  `discharge_status` int(11) NOT NULL,
  `death_date` datetime DEFAULT NULL,
  `refer_date` datetime DEFAULT NULL,
  `refer_to_hospital` varchar(255) DEFAULT NULL,
  `reason_for_referral` varchar(255) DEFAULT NULL,
  `operation` varchar(225) NOT NULL,
  `diagnosis` varchar(255) NOT NULL,
  `investigations` text DEFAULT NULL,
  `treatment_home` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `opd_details_id` (`opd_details_id`),
  KEY `ipd_details_id` (`ipd_details_id`),
  KEY `discharge_by` (`discharge_by`),
  CONSTRAINT `discharge_card_ibfk_1` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_2` FOREIGN KEY (`discharge_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_4` FOREIGN KEY (`opd_details_id`) REFERENCES `opd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_5` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_6` FOREIGN KEY (`discharge_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` text DEFAULT NULL,
  `note` text DEFAULT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `image` varchar(100) NOT NULL,
  `type` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_reference_no` (`reference_no`),
  KEY `index_to_title` (`to_title`),
  KEY `index_from_title` (`from_title`),
  KEY `index_date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: doctor_absent
#

DROP TABLE IF EXISTS `doctor_absent`;

CREATE TABLE `doctor_absent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `index_date` (`date`),
  CONSTRAINT `doctor_absent_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: doctor_global_shift
#

DROP TABLE IF EXISTS `doctor_global_shift`;

CREATE TABLE `doctor_global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `global_shift_id` (`global_shift_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_global_shift_ibfk_1` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_global_shift_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (1, 2, 1, '2025-06-24 15:00:46');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (2, 2, 3, '2025-06-24 15:00:48');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (3, 3, 1, '2025-06-25 09:31:33');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (4, 3, 3, '2025-06-25 09:31:34');


#
# TABLE STRUCTURE FOR: doctor_shift_time
#

DROP TABLE IF EXISTS `doctor_shift_time`;

CREATE TABLE `doctor_shift_time` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `doctor_global_shift_id` int(11) DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `doctor_global_shift_id` (`doctor_global_shift_id`),
  KEY `index_day` (`day`),
  CONSTRAINT `doctor_shift_time_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_shift_time_ibfk_3` FOREIGN KEY (`doctor_global_shift_id`) REFERENCES `doctor_global_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (1, 'Monday', 2, 1, '08:00:00', '12:00:00', '2025-06-24 18:33:41');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (2, 'Tuesday', 2, 1, '08:00:00', '12:00:00', '2025-06-24 18:34:48');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (3, 'Wednesday', 2, 1, '08:00:00', '12:00:00', '2025-06-24 18:35:10');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (4, 'Thursday', 2, 1, '08:00:00', '12:00:00', '2025-06-24 18:35:26');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (5, 'Friday', 2, 1, '08:00:00', '12:00:00', '2025-06-24 18:35:50');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (6, 'Saturday', 2, 1, '08:00:00', '12:00:00', '2025-06-24 18:36:03');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (7, 'Sunday', 2, 1, '08:00:00', '12:00:00', '2025-06-24 18:36:15');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (8, 'Monday', 3, 3, '08:00:00', '12:00:00', '2025-06-25 09:35:31');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (9, 'Tuesday', 3, 3, '08:00:00', '12:00:00', '2025-06-25 09:35:48');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (10, 'Wednesday', 3, 3, '08:00:00', '12:00:00', '2025-06-25 09:36:08');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (11, 'Thursday', 3, 3, '08:00:00', '12:00:00', '2025-06-25 09:36:24');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (12, 'Friday', 3, 3, '08:00:00', '12:00:00', '2025-06-25 09:36:56');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (13, 'Saturday', 3, 3, '08:00:00', '12:00:00', '2025-06-25 09:37:11');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (14, 'Sunday', 3, 3, '08:00:00', '12:00:00', '2025-06-25 09:37:37');


#
# TABLE STRUCTURE FOR: dose_duration
#

DROP TABLE IF EXISTS `dose_duration`;

CREATE TABLE `dose_duration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: dose_interval
#

DROP TABLE IF EXISTS `dose_interval`;

CREATE TABLE `dose_interval` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: duty_roster_assign
#

DROP TABLE IF EXISTS `duty_roster_assign`;

CREATE TABLE `duty_roster_assign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` int(11) NOT NULL,
  `roster_duty_date` date DEFAULT NULL,
  `floor_id` int(11) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `staff_id` int(11) NOT NULL,
  `duty_roster_list_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `duty_roster_list_id` (`duty_roster_list_id`),
  KEY `department_id` (`department_id`),
  KEY `staff_id` (`staff_id`),
  KEY `floor_id` (`floor_id`),
  KEY `index_roster_duty_date` (`roster_duty_date`),
  CONSTRAINT `duty_roster_assign_ibfk_1` FOREIGN KEY (`duty_roster_list_id`) REFERENCES `duty_roster_list` (`id`) ON DELETE CASCADE,
  CONSTRAINT `duty_roster_assign_ibfk_2` FOREIGN KEY (`department_id`) REFERENCES `department` (`id`) ON DELETE CASCADE,
  CONSTRAINT `duty_roster_assign_ibfk_3` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `duty_roster_assign_ibfk_4` FOREIGN KEY (`floor_id`) REFERENCES `floor` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: duty_roster_list
#

DROP TABLE IF EXISTS `duty_roster_list`;

CREATE TABLE `duty_roster_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `duty_roster_shift_id` int(11) NOT NULL,
  `duty_roster_start_date` date NOT NULL,
  `duty_roster_end_date` date NOT NULL,
  `duty_roster_total_day` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `duty_roster_shift_id` (`duty_roster_shift_id`),
  KEY `index_duty_roster_start_date` (`duty_roster_start_date`),
  KEY `index_duty_roster_end_date` (`duty_roster_end_date`),
  CONSTRAINT `duty_roster_list_ibfk_1` FOREIGN KEY (`duty_roster_shift_id`) REFERENCES `duty_roster_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: duty_roster_shift
#

DROP TABLE IF EXISTS `duty_roster_shift`;

CREATE TABLE `duty_roster_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shift_name` varchar(255) NOT NULL,
  `shift_start` time NOT NULL,
  `shift_end` time NOT NULL,
  `shift_hour` time NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_shift_name` (`shift_name`),
  KEY `index_shift_start` (`shift_start`),
  KEY `index_shift_end` (`shift_end`),
  KEY `index_shift_hour` (`shift_hour`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (1, 'DAY SHIFT', '08:00:00', '08:00:00', '00:00:00', 1, '2025-06-24 15:07:31');


#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `is_active`, `created_at`) VALUES (1, 'smtp', 'mail.omirieriadvocates.com', '587', 'clinic@omirieriadvocates.com', 'Clinic2022&&', 'tls', 'true', 'yes', '2025-06-24 08:20:56');


#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` text DEFAULT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `start_date` (`start_date`),
  KEY `index_end_date` (`end_date`),
  KEY `index_event_type` (`event_type`) USING BTREE,
  KEY `index_event_color` (`event_color`) USING BTREE,
  KEY `index_event_title` (`event_title`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `events_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (1, 'call Buke Hassan for RCT 3', '', '2025-07-09 00:00:00', '2025-07-09 00:00:00', 'task', '#000', '1', 7, 'no', '2025-07-02 13:24:00');


#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_exp_category` (`exp_category`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'EXPENSE', '', 'yes', 'no', '2025-06-25 12:23:15');


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `documents` text DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exp_head_id` (`exp_head_id`),
  KEY `generated_by` (`generated_by`),
  KEY `index_invoice_no` (`invoice_no`),
  KEY `index_name` (`name`),
  KEY `index_date` (`date`) USING BTREE,
  KEY `index_amount` (`amount`) USING BTREE,
  CONSTRAINT `expenses_ibfk_1` FOREIGN KEY (`exp_head_id`) REFERENCES `expense_head` (`id`) ON DELETE CASCADE,
  CONSTRAINT `expenses_ibfk_2` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (1, 1, 'water', 'cash', '2025-07-01', '790.00', NULL, 'Main water 2 tanks from Robert', 'yes', 'no', 1, '2025-07-01 15:50:51');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (2, 1, 'wifi', 'cash', '2025-07-01', '1000.00', NULL, 'wifi wire', 'yes', 'no', 1, '2025-07-01 16:42:50');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (3, 1, 'Dinner', 'cash', '2025-07-06', '800.00', NULL, 'Dinner', 'yes', 'no', 1, '2025-07-06 17:05:20');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (4, 1, 'Gas', 'Cash', '2025-07-08', '1200.00', NULL, 'Refilling gas', 'yes', 'no', 1, '2025-07-08 18:26:38');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (5, 1, 'FUEL', 'CASH', '2025-07-09', '3000.00', NULL, 'GENERATOR', 'yes', 'no', 1, '2025-07-09 17:41:38');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (6, 1, 'SERVETTE', 'CASH', '2025-07-09', '1500.00', NULL, 'SERVETTE', 'yes', 'no', 1, '2025-07-09 19:29:03');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (7, 1, 'SANITIZER', 'CASH', '2025-07-09', '1050.00', NULL, 'SANITIZERS', 'yes', 'no', 1, '2025-07-09 19:29:34');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (8, 1, 'EMMANUEL KIPTUM', 'MPESA', '2025-07-09', '3050.00', NULL, 'EVANS KIPTUM', 'yes', 'no', 1, '2025-07-09 19:30:30');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (9, 1, 'Drugs', 'Mpesa', '2025-07-10', '10950.00', NULL, 'floxapen and drugs.', 'yes', 'no', 1, '2025-07-10 21:04:45');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (10, 1, 'Consumables', 'P051611187E', '2025-07-13', '1215.00', NULL, 'SM', 'yes', 'no', 1, '2025-07-13 17:21:35');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (11, 1, 'jik', 'TGE9YRRO4X', '2025-07-14', '2100.00', NULL, 'JIK', 'yes', 'no', 1, '2025-07-14 18:11:38');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (12, 1, 'WATER', 'Mpesa', '2025-07-16', '450.00', NULL, 'Distilled water', 'yes', 'no', 1, '2025-07-16 18:56:58');


#
# TABLE STRUCTURE FOR: filetypes
#

DROP TABLE IF EXISTS `filetypes`;

CREATE TABLE `filetypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_extension` text DEFAULT NULL,
  `file_mime` text DEFAULT NULL,
  `file_size` int(11) NOT NULL,
  `image_extension` text DEFAULT NULL,
  `image_mime` text DEFAULT NULL,
  `image_size` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: finding
#

DROP TABLE IF EXISTS `finding`;

CREATE TABLE `finding` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `finding_category_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `finding_category_id` (`finding_category_id`),
  KEY `index_name` (`name`),
  CONSTRAINT `finding_ibfk_1` FOREIGN KEY (`finding_category_id`) REFERENCES `finding_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: finding_category
#

DROP TABLE IF EXISTS `finding_category`;

CREATE TABLE `finding_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: floor
#

DROP TABLE IF EXISTS `floor`;

CREATE TABLE `floor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext DEFAULT NULL,
  `vid_title` varchar(250) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) DEFAULT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` mediumtext DEFAULT NULL,
  `open_new_tab` int(11) DEFAULT 0,
  `ext_url_link` mediumtext DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (1, 2, 'Home', 1, 0, NULL, NULL, NULL, 'home-1', NULL, 0, NULL, 'no', '2018-07-14 05:14:12');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (2, 1, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment', 2, 0, NULL, 'no', '2021-09-27 14:04:57');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (3, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', NULL, 0, NULL, 'no', '2019-01-24 05:18:17');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (4, 2, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment-1', NULL, 0, NULL, 'no', '2019-11-02 12:54:41');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `open_new_tab` int(11) NOT NULL DEFAULT 0,
  `ext_url` mediumtext DEFAULT NULL,
  `ext_url_link` mediumtext DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 05:54:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 05:54:55');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(11) DEFAULT 0,
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` int(11) DEFAULT 0,
  `sidebar` int(11) DEFAULT 0,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home page first new', 'page/home-page-first-new', 'page', 'home-page-first-new', '', '', '', '', '<p>Home page first</p>', '0000-00-00', 1, 1, 'no', '2021-09-28 17:49:10');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<div class=\"col-md-12 col-sm-12\">\r\n<h2 class=\"text-center\">&nbsp;</h2>\r\n\r\n<p class=\"text-center\">[form-builder:complain]</p>\r\n</div>', '0000-00-00', 1, 1, 'no', '2019-01-24 05:00:12');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (3, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<title></title>\r\n<p>404 page found</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 13:35:15');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (4, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<p>[form-builder:contact_us]</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 08:27:54');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (5, 'manual', 0, 'our-appointment', 'page/our-appointment', 'page', 'our-appointment', '', '', '', '', '<form action=\"welcome/appointment\" method=\"get\">First name: <input name=\"fname\" type=\"text\" /><br />\r\nLast name: <input name=\"lname\" type=\"text\" /><br />\r\n<input type=\"submit\" value=\"Submit\" />&nbsp;</form>', '0000-00-00', 0, 1, 'no', '2021-09-24 13:35:25');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` text DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` varchar(10) NOT NULL DEFAULT '0',
  `sidebar` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(11) DEFAULT 0,
  `is_active_front_cms` int(11) DEFAULT 0,
  `is_active_online_appointment` int(11) DEFAULT NULL,
  `is_active_sidebar` int(11) DEFAULT 0,
  `logo` text DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext DEFAULT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext DEFAULT NULL,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_online_appointment`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `fav_icon`, `created_at`) VALUES (1, 'turquoise_blue', NULL, 1, 1, 1, '', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', '', '', '2025-06-24 15:35:25');


#
# TABLE STRUCTURE FOR: gateway_ins
#

DROP TABLE IF EXISTS `gateway_ins`;

CREATE TABLE `gateway_ins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `online_appointment_id` int(11) DEFAULT NULL,
  `type` varchar(30) NOT NULL COMMENT 'patient_bill,appointment	',
  `gateway_name` varchar(50) NOT NULL,
  `module_type` varchar(255) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `parameter_details` mediumtext NOT NULL,
  `payment_status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_type` (`type`),
  KEY `index_gateway_name` (`gateway_name`),
  KEY `index_module_type` (`module_type`),
  KEY `index_unique_id` (`unique_id`),
  KEY `online_appointment_id` (`online_appointment_id`),
  CONSTRAINT `gateway_ins_ibfk_1` FOREIGN KEY (`online_appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: gateway_ins_response
#

DROP TABLE IF EXISTS `gateway_ins_response`;

CREATE TABLE `gateway_ins_response` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gateway_ins_id` int(11) DEFAULT NULL,
  `posted_data` text DEFAULT NULL,
  `response` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `gateway_ins_id` (`gateway_ins_id`),
  CONSTRAINT `gateway_ins_response_ibfk_1` FOREIGN KEY (`gateway_ins_id`) REFERENCES `gateway_ins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` text DEFAULT NULL,
  `follow_up_date` date DEFAULT NULL,
  `call_duration` varchar(50) NOT NULL,
  `note` mediumtext DEFAULT NULL,
  `call_type` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_contact` (`contact`),
  KEY `index_date` (`date`),
  KEY `index_call_duration` (`call_duration`),
  KEY `index_follow_up_date` (`follow_up_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: global_shift
#

DROP TABLE IF EXISTS `global_shift`;

CREATE TABLE `global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_start_time` (`start_time`),
  KEY `index_end_time` (`end_time`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (1, 'MORNING SHIFT', '08:00:00', '12:00:00', '2025-06-24 14:58:06');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (3, 'AFTERNOON SHIFT', '07:00:00', '12:00:00', '2025-06-24 15:00:01');


#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inc_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `is_deleted` varchar(10) DEFAULT 'no',
  `documents` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `inc_head_id` (`inc_head_id`),
  KEY `generated_by` (`generated_by`),
  KEY `index_name` (`name`),
  KEY `index_invoice_no` (`invoice_no`),
  KEY `index_date` (`date`),
  KEY `index_amount` (`amount`),
  CONSTRAINT `income_ibfk_1` FOREIGN KEY (`inc_head_id`) REFERENCES `income_head` (`id`) ON DELETE CASCADE,
  CONSTRAINT `income_ibfk_2` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_income_category` (`income_category`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'INCOME', '', 'yes', 'no', '2025-06-25 12:23:05');


#
# TABLE STRUCTURE FOR: ipd_details
#

DROP TABLE IF EXISTS `ipd_details`;

CREATE TABLE `ipd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `height` varchar(5) DEFAULT NULL,
  `weight` varchar(5) DEFAULT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `bp` varchar(20) DEFAULT NULL,
  `bed` int(11) DEFAULT NULL,
  `bed_group_id` int(11) DEFAULT NULL,
  `case_type` varchar(100) NOT NULL,
  `casualty` varchar(100) NOT NULL,
  `symptoms` longtext NOT NULL,
  `known_allergies` varchar(200) DEFAULT NULL,
  `patient_old` varchar(50) NOT NULL,
  `note` text DEFAULT NULL,
  `refference` varchar(200) NOT NULL,
  `cons_doctor` int(11) DEFAULT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `credit_limit` varchar(100) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `discharged` varchar(200) NOT NULL,
  `live_consult` varchar(50) DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `is_antenatal` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `cons_doctor` (`cons_doctor`),
  KEY `bed_group_id` (`bed_group_id`),
  KEY `bed` (`bed`),
  CONSTRAINT `ipd_details_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_2` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_4` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_5` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_6` FOREIGN KEY (`bed`) REFERENCES `bed` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: ipd_doctors
#

DROP TABLE IF EXISTS `ipd_doctors`;

CREATE TABLE `ipd_doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) NOT NULL,
  `consult_doctor` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `consult_doctor` (`consult_doctor`),
  CONSTRAINT `ipd_doctors_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_doctors_ibfk_2` FOREIGN KEY (`consult_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: ipd_prescription_basic
#

DROP TABLE IF EXISTS `ipd_prescription_basic`;

CREATE TABLE `ipd_prescription_basic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `attachment` text NOT NULL,
  `attachment_name` text NOT NULL,
  `header_note` text DEFAULT NULL,
  `footer_note` text DEFAULT NULL,
  `finding_description` text DEFAULT NULL,
  `is_finding_print` varchar(100) DEFAULT NULL,
  `date` date NOT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `prescribe_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `generated_by` (`generated_by`),
  KEY `index_date` (`date`),
  KEY `prescribe_by` (`prescribe_by`),
  CONSTRAINT `ipd_prescription_basic_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_basic_ibfk_2` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_basic_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_basic_ibfk_4` FOREIGN KEY (`prescribe_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: ipd_prescription_details
#

DROP TABLE IF EXISTS `ipd_prescription_details`;

CREATE TABLE `ipd_prescription_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `basic_id` int(11) DEFAULT NULL,
  `pharmacy_id` int(11) DEFAULT NULL,
  `dosage` int(11) DEFAULT NULL,
  `dose_interval_id` int(11) DEFAULT NULL,
  `dose_duration_id` int(11) DEFAULT NULL,
  `instruction` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `basic_id` (`basic_id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  KEY `index_dosage` (`dosage`),
  KEY `index_dose_interval_id` (`dose_interval_id`),
  KEY `index_dose_duration_id` (`dose_duration_id`),
  CONSTRAINT `ipd_prescription_details_ibfk_1` FOREIGN KEY (`basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_details_ibfk_2` FOREIGN KEY (`pharmacy_id`) REFERENCES `pharmacy` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_details_ibfk_3` FOREIGN KEY (`dose_interval_id`) REFERENCES `dose_interval` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_details_ibfk_4` FOREIGN KEY (`dose_duration_id`) REFERENCES `dose_interval` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: ipd_prescription_test
#

DROP TABLE IF EXISTS `ipd_prescription_test`;

CREATE TABLE `ipd_prescription_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_prescription_basic_id` int(11) DEFAULT NULL,
  `pathology_id` int(11) DEFAULT NULL,
  `radiology_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `pathology_id` (`pathology_id`),
  KEY `radiology_id` (`radiology_id`),
  CONSTRAINT `ipd_prescription_test_ibfk_1` FOREIGN KEY (`ipd_prescription_basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_test_ibfk_2` FOREIGN KEY (`pathology_id`) REFERENCES `pathology` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_test_ibfk_3` FOREIGN KEY (`radiology_id`) REFERENCES `radio` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(200) NOT NULL,
  `item_photo` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `index_name` (`name`),
  KEY `index_unit` (`unit`),
  KEY `index_quantity` (`quantity`),
  KEY `index_date` (`date`),
  CONSTRAINT `item_ibfk_1` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_item_category` (`item_category`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (1, 'DRUGS', 'yes', '', '2025-06-25 12:23:36');


#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_type` int(11) DEFAULT NULL,
  `issue_to` int(11) DEFAULT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `is_returned` int(11) NOT NULL DEFAULT 1,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `issue_to` (`issue_to`),
  KEY `index_issue_date` (`issue_date`),
  KEY `index_return_date` (`return_date`),
  KEY `index_quantity` (`quantity`),
  KEY `index_is_returned` (`is_returned`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_3` FOREIGN KEY (`issue_to`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `purchase_price` float(10,2) DEFAULT 0.00,
  `date` date DEFAULT NULL,
  `attachment` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  KEY `index_quantity` (`quantity`),
  KEY `index_purchase_price` (`purchase_price`),
  KEY `index_date` (`date`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_item_store` (`item_store`),
  KEY `index_code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_item_supplier` (`item_supplier`),
  KEY `index_phone` (`phone`),
  KEY `index_email` (`email`),
  KEY `index_address` (`address`),
  KEY `index_contact_person_name` (`contact_person_name`),
  KEY `index_contact_person_phone` (`contact_person_phone`),
  KEY `index_contact_person_email` (`contact_person_email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: lab
#

DROP TABLE IF EXISTS `lab`;

CREATE TABLE `lab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lab_name` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_rtl` varchar(10) NOT NULL DEFAULT 'no',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_language` (`language`),
  KEY `index_short_code` (`short_code`),
  KEY `index_country_code` (`country_code`),
  KEY `index_is_deleted` (`is_deleted`),
  KEY `index_is_rtl` (`is_rtl`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 'no', 'no', 'no', '2021-09-28 11:51:22', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 'no', 'no', 'no', '2021-09-28 12:08:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 'no', 'no', 'no', '2021-09-28 11:50:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 'no', 'no', 'no', '2021-09-16 07:20:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 'no', 'no', 'no', '2021-09-28 11:50:48', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Afrikaans', 'af', 'af', 'no', 'no', 'no', '2021-09-28 12:51:19', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Basque', 'eu', 'es', 'no', 'no', 'no', '2021-09-24 08:58:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Bengali', 'bn', 'in', 'no', 'no', 'no', '2021-09-24 08:58:25', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'Bosnian', 'bs', 'bs', 'no', 'no', 'no', '2021-09-24 08:58:28', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'Welsh', 'cy', 'cy', 'no', 'no', 'no', '2021-09-24 08:58:31', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Hungarian', 'hu', 'hu', 'no', 'no', 'no', '2021-09-24 08:58:35', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'Vietnamese', 'vi', 'vi', 'no', 'no', 'no', '2021-09-24 08:58:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Haitian', 'ht', 'ht', 'no', 'no', 'no', '2021-09-24 08:58:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Galician', 'gl', 'gl', 'no', 'no', 'no', '2021-09-24 08:58:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Dutch', 'nl', 'nl', 'no', 'no', 'no', '2021-09-24 08:58:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Greek', 'el', 'gr', 'no', 'no', 'no', '2021-09-24 08:58:53', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Georgian', 'ka', 'ge', 'no', 'no', 'no', '2021-09-24 08:58:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Gujarati', 'gu', 'in', 'no', 'no', 'no', '2021-09-24 08:58:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Danish', 'da', 'dk', 'no', 'no', 'no', '2021-09-24 08:59:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'Hebrew', 'he', 'il', 'no', 'no', 'no', '2021-09-24 08:59:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Yiddish', 'yi', 'il', 'no', 'no', 'no', '2021-09-24 08:59:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Indonesian', 'id', 'id', 'no', 'no', 'no', '2021-09-24 08:59:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Irish', 'ga', 'ga', 'no', 'no', 'no', '2021-09-24 08:59:14', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Italian', 'it', 'it', 'no', 'no', 'no', '2021-09-24 08:59:17', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Icelandic', 'is', 'is', 'no', 'no', 'no', '2021-09-24 08:59:20', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Spanish', 'es', 'es', 'no', 'no', 'no', '2021-09-24 08:59:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Kannada', 'kn', 'kn', 'no', 'no', 'no', '2021-09-24 08:59:32', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Catalan', 'ca', 'ca', 'no', 'no', 'no', '2021-09-24 08:59:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Chinese', 'zh', 'cn', 'no', 'no', 'no', '2021-09-24 08:59:36', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Korean', 'ko', 'kr', 'no', 'no', 'no', '2021-09-24 08:59:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Xhosa', 'xh', 'ls', 'no', 'no', 'no', '2021-09-24 08:59:42', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'Latin', 'la', 'la', 'no', 'no', 'no', '2021-09-24 08:59:45', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Latvian', 'lv', 'lv', 'no', 'no', 'no', '2021-09-24 08:59:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Lithuanian', 'lt', 'lt', 'no', 'no', 'no', '2021-09-24 08:59:50', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'Malagasy', 'mg', 'mg', 'no', 'no', 'no', '2021-09-24 08:59:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Malay', 'ms', 'ms', 'no', 'no', 'no', '2021-09-24 09:00:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Malayalam', 'ml', 'ml', 'no', 'no', 'no', '2021-09-24 09:00:05', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Maltese', 'mt', 'mt', 'no', 'no', 'no', '2021-09-24 09:00:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Macedonian', 'mk', 'mk', 'no', 'no', 'no', '2021-09-24 09:00:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Maori', 'mi', 'nz', 'no', 'no', 'no', '2021-09-24 09:00:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Marathi', 'mr', 'in', 'no', 'no', 'no', '2021-09-24 09:00:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'Mongolian', 'mn', 'mn', 'no', 'no', 'no', '2021-09-24 09:01:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'German', 'de', 'de', 'no', 'no', 'no', '2021-09-24 09:01:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Nepali', 'ne', 'ne', 'no', 'no', 'no', '2021-09-24 09:01:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Norwegian', 'no', 'no', 'no', 'no', 'no', '2021-09-24 09:01:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Punjabi', 'pa', 'in', 'no', 'no', 'no', '2021-09-24 09:01:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Persian', 'fa', 'ir', 'no', 'no', 'no', '2021-09-24 09:01:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Portuguese', 'pt', 'pt', 'no', 'no', 'no', '2021-09-24 09:01:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Romanian', 'ro', 'ro', 'no', 'no', 'no', '2021-09-24 09:01:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'Russian', 'ru', 'ru', 'no', 'no', 'no', '2021-09-24 09:01:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Cebuano', 'ceb', 'ph', 'no', 'no', 'no', '2021-09-24 09:02:02', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'Sinhala', 'si', 'si', 'no', 'no', 'no', '2021-09-24 09:02:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Slovakian', 'sk', 'sk', 'no', 'no', 'no', '2021-09-24 09:02:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Slovenian', 'sl', 'sl', 'no', 'no', 'no', '2021-09-24 09:02:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Swahili', 'sw', 'ke', 'no', 'no', 'no', '2021-09-24 09:02:12', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'Sundanese', 'su', 'sd', 'no', 'no', 'no', '2021-09-24 09:02:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Thai', 'th', 'th', 'no', 'no', 'no', '2021-09-24 09:02:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'Tagalog', 'tl', 'tl', 'no', 'no', 'no', '2021-09-24 09:02:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Tamil', 'ta', 'in', 'no', 'no', 'no', '2021-09-24 09:02:23', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Telugu', 'te', 'in', 'no', 'no', 'no', '2021-09-24 09:02:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Turkish', 'tr', 'tr', 'no', 'no', 'no', '2021-09-24 09:02:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Uzbek', 'uz', 'uz', 'no', 'no', 'no', '2021-09-24 09:02:31', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'Urdu', 'ur', 'pk', 'no', 'no', 'no', '2021-09-24 09:02:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Finnish', 'fi', 'fi', 'no', 'no', 'no', '2021-09-24 09:02:37', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'French', 'fr', 'fr', 'no', 'no', 'no', '2021-09-24 09:02:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Hindi', 'hi', 'in', 'no', 'no', 'no', '2021-09-24 09:02:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Czech', 'cs', 'cz', 'no', 'no', 'no', '2021-09-24 09:02:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Swedish', 'sv', 'sv', 'no', 'no', 'no', '2021-09-24 09:02:46', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'Scottish', 'gd', 'gd', 'no', 'no', 'no', '2021-09-24 09:02:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Estonian', 'et', 'et', 'no', 'no', 'no', '2021-09-24 09:02:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Esperanto', 'eo', 'br', 'no', 'no', 'no', '2021-09-24 09:02:55', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Javanese', 'jv', 'id', 'no', 'no', 'no', '2021-09-24 09:02:58', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'Japanese', 'ja', 'jp', 'no', 'no', 'no', '2021-09-24 09:03:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Polish', 'pl', 'pl', 'no', 'no', 'no', '2021-09-28 08:39:06', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Croatia', 'hr', 'hr', 'no', 'no', 'no', '2021-10-25 09:56:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'Kurdish', 'ku', 'iq', 'no', 'no', 'no', '2021-10-25 09:56:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Lao', 'lo', 'la', 'no', 'no', 'no', '2021-10-25 09:56:47', NULL);


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (1, 'SICK LEAVE', 'yes', '2025-06-24 14:38:54');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (2, 'QUARTELY LEAVE', 'yes', '2025-06-24 14:39:09');


#
# TABLE STRUCTURE FOR: logs
#

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `record_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(50) NOT NULL,
  `ip_address` varchar(50) NOT NULL,
  `platform` varchar(50) NOT NULL,
  `agent` varchar(50) NOT NULL,
  `time` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=905 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1, 'Record updated On Settings id 1', 1, 0, 'Update', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 08:39:12', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2, 'Record updated On Settings id 1', 1, 0, 'Update', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 08:39:29', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (3, 'Record updated On Settings id 1', 1, 0, 'Update', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 08:40:10', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (4, 'New Record inserted On Symptoms Classification id 1', 1, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:42:01', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (5, 'New Record inserted On Symptoms id 1', 1, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:42:20', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (6, 'New Record inserted On Symptoms id 2', 2, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:42:35', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (7, 'New Record inserted On Symptoms id 3', 3, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:45:09', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (8, 'New Record inserted On Symptoms id 4', 4, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:45:54', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (9, 'New Record inserted On Symptoms id 5', 5, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:46:12', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (10, 'New Record inserted On Symptoms id 6', 6, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:46:28', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (11, 'New Record inserted On Symptoms id 7', 7, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:46:42', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (12, 'New Record inserted On Symptoms id 8', 8, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:47:05', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (13, 'New Record inserted On Symptoms id 9', 9, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:47:18', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (14, 'New Record inserted On Symptoms id 10', 10, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:47:42', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (15, 'New Record inserted On Symptoms id 11', 11, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:48:30', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (16, 'New Record inserted On Symptoms id 12', 12, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:48:56', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (17, 'New Record inserted On Symptoms id 13', 13, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:49:20', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (18, 'New Record inserted On Symptoms id 14', 14, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:49:32', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (19, 'New Record inserted On Symptoms id 15', 15, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:49:55', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (20, 'New Record inserted On Symptoms id 16', 16, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:50:11', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (21, 'New Record inserted On Symptoms id 17', 17, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:50:22', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (22, 'New Record inserted On Patient id 1', 1, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:51:35', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (23, 'Record updated On Patient id 1', 1, 0, 'Update', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:51:35', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (24, 'Record updated On Settings id 1', 1, 0, 'Update', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 11:58:53', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (25, 'New Record inserted For Organisation id 1', 1, 0, 'Insert', '196.250.215.192', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:01:59', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (26, 'New Record inserted On Charge Categories id 1', 1, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:16:19', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (27, 'New Record inserted On Charge Categories id 2', 2, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:17:11', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (28, 'Record updated On Charge Categories id 2', 2, 0, 'Update', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:17:26', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (29, 'New Record inserted On Tax Category id 1', 1, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:20:38', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (30, 'New Record inserted On Charge Units id 1', 1, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:25:35', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (31, 'Record updated On Charge Categories id 2', 2, 0, 'Update', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:28:11', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (32, 'Record updated On Charge Categories id 2', 2, 0, 'Update', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:29:11', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (33, 'Record updated On Charge Categories id 1', 1, 0, 'Update', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:30:19', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (34, 'New Record inserted On Charge Categories id 3', 3, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:42:48', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (35, 'New Record inserted On Charge Categories id 4', 4, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:43:05', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (36, 'New Record inserted On Charge Categories id 5', 5, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:43:27', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (37, 'New Record inserted On Charge Categories id 6', 6, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:44:21', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (38, 'New Record inserted On Charge Categories id 7', 7, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:44:59', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (39, 'New Record inserted On Charge Categories id 8', 8, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:45:37', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (40, 'New Record inserted On Charge Categories id 9', 9, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:46:44', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (41, 'New Record inserted On Charge Categories id 10', 10, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:47:48', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (42, 'New Record inserted On Charge Categories id 11', 11, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:48:24', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (43, 'New Record inserted On Charge Categories id 12', 12, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:48:43', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (44, 'New Record inserted On Charge Categories id 13', 13, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:49:11', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (45, 'New Record inserted On Charge Categories id 14', 14, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 12:49:54', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (46, 'New Record inserted On Department id 1', 1, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 14:07:20', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (47, 'New Record inserted On Staff Designation id 1', 1, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 14:08:12', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (48, 'New Record inserted On Staff Designation id 2', 2, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 14:08:23', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (49, 'New Record inserted On Specialist id 1', 1, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 14:08:33', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (50, 'New Record inserted On Specialist id 2', 2, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 14:08:40', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (51, 'New Record inserted On Specialist id 3', 3, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 14:08:50', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (52, 'New Record inserted On Patient id 2', 2, 0, 'Insert', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 14:11:37', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (53, 'Record updated On Patient id 2', 2, 0, 'Update', '196.250.215.172', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-23 14:11:37', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (54, 'Record updated On Email Config id 1', 1, 0, 'Update', '196.97.0.97', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 09:20:56', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (55, 'Record updated For Staff id 2', 2, 0, 'Update', '196.97.0.97', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 09:22:36', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (56, 'Record updated Change Password For Staff id 2', 2, 0, 'Update', '196.97.0.97', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 09:39:35', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (57, 'New Record inserted On Charge Categories id 15', 15, 0, 'Insert', '152.59.222.195', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:41:07', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (58, 'Record updated On Charge Categories id 14', 14, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:48:28', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (59, 'Record updated On Charge Categories id 13', 13, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:48:37', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (60, 'Record updated On Charge Categories id 12', 12, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:49:14', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (61, 'Record updated On Charge Categories id 11', 11, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:49:25', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (62, 'Record updated On Charge Categories id 10', 10, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:49:34', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (63, 'Record updated On Charge Categories id 9', 9, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:49:43', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (64, 'Record updated On Charge Categories id 8', 8, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:50:02', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (65, 'Record updated On Charge Categories id 7', 7, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:50:11', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (66, 'Record updated On Charge Categories id 6', 6, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:50:19', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (67, 'Record updated On Charge Categories id 5', 5, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:50:28', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (68, 'Record updated On Charge Categories id 4', 4, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:50:36', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (69, 'Record updated On Charge Categories id 3', 3, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:50:44', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (70, 'Record updated On Charge Categories id 2', 2, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:50:51', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (71, 'Record updated On Charge Categories id 1', 1, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:51:00', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (72, 'Record deleted On Charge Categories id 15', 15, 0, 'Delete', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:51:07', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (73, 'New Record inserted On Patient id 3', 3, 0, 'Insert', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:51:49', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (74, 'Record updated On Patient id 3', 3, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:51:49', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (75, 'Record updated On Patient id 3', 3, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:55:38', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (76, 'New Record inserted On Transactions id 1', 1, 0, 'Insert', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:55:38', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (77, 'New Record inserted On Patient id 4', 4, 0, 'Insert', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:56:35', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (78, 'Record updated On Patient id 4', 4, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 14:56:35', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (79, 'Record updated On Print Setting id 2', 2, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:03:12', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (80, 'Record updated On Print Setting id 2', 2, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:03:12', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (81, 'Record updated On Print Setting id 2', 2, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:03:22', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (82, 'Record updated On Print Setting id 2', 2, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:03:23', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (83, 'Record updated On Print Setting id 2', 2, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:03:38', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (84, 'Record updated On Print Setting id 20', 20, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:05:42', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (85, 'Record updated On Print Setting id 20', 20, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:05:42', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (86, 'Record updated On Print Setting id 20', 20, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:05:50', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (87, 'Record updated On Print Setting id 1', 1, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:06:17', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (88, 'Record updated On Print Setting id 1', 1, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:06:17', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (89, 'Record updated On Print Setting id 1', 1, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:06:32', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (90, 'Record updated On Print Setting id 1', 1, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:06:32', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (91, 'Record updated On Print Setting id 1', 1, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:07:06', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (92, 'Record updated On Print Setting id 1', 1, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:07:06', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (93, 'Record updated On Print Setting id 2', 2, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:08:48', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (94, 'Record updated On Print Setting id 2', 2, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:08:48', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (95, 'New Record inserted On Charge Categories id 16', 16, 0, 'Insert', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:33:38', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (96, 'New Record inserted On Leave Types id 1', 1, 0, 'Insert', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:38:54', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (97, 'New Record inserted On Leave Types id 2', 2, 0, 'Insert', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:39:09', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (98, 'Record updated On Settings id 1', 1, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:52:08', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (99, 'New Record inserted On Global Shift id 1', 1, 0, 'Insert', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:57:54', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (100, 'Record updated On Global Shift id 1', 1, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 15:58:06', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (101, 'New Record inserted On Global Shift id 2', 2, 0, 'Insert', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 16:00:01', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (102, 'New Record inserted On Global Shift id 3', 3, 0, 'Insert', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 16:00:01', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (103, 'Record deleted On Global Shift id 2', 2, 0, 'Delete', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 16:00:09', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (104, 'New Record inserted On Duty Roster Shift id1', 1, 0, 'Insert', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 16:07:31', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (105, 'Record updated On Duty Roster Shift id 1', 1, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 16:07:52', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (106, 'Record updated On Duty Roster Shift id 1', 1, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 16:08:29', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (107, 'Record updated On Settings id 1', 1, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 16:09:22', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (108, 'Record updated On Front Cms Settings id 1', 1, 0, 'Update', '196.250.215.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 16:35:25', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (109, 'New Record inserted On Shift Details id 1', 1, 0, 'Insert', '41.90.216.240', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 19:33:41', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (110, 'Record updated On Shift Details id 2', 2, 0, 'Update', '41.90.216.240', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 19:34:48', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (111, 'Record updated On Shift Details id 2', 2, 0, 'Update', '105.161.133.11', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 19:35:10', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (112, 'Record updated On Shift Details id 2', 2, 0, 'Update', '105.161.133.11', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 19:35:26', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (113, 'Record updated On Shift Details id 2', 2, 0, 'Update', '41.90.216.240', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 19:35:50', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (114, 'Record updated On Shift Details id 2', 2, 0, 'Update', '41.90.216.240', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 19:36:03', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (115, 'Record updated On Shift Details id 2', 2, 0, 'Update', '41.90.216.240', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 19:36:15', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (116, 'New Record inserted On Appointment Created 1', 1, 0, 'Insert', '41.90.216.240', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 19:38:31', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (117, 'New Record inserted On Transactions id 3', 3, 0, 'Insert', '41.90.216.240', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 19:42:46', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (118, 'Record deleted On  OPD  id 3', 3, 0, 'Delete', '41.90.216.240', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 19:43:44', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (119, 'Record deleted On  OPD  id 2', 2, 0, 'Delete', '41.90.216.240', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-24 19:43:52', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (120, 'Record updated On Patient id 3', 3, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 09:10:58', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (121, 'New Record inserted On Transactions id 4', 4, 0, 'Insert', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 09:10:58', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (122, 'Record deleted On  OPD  id 1', 1, 0, 'Delete', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 09:11:25', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (123, 'Record updated For Staff id 3', 3, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 09:14:13', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (124, 'Record updated For Staff id 4', 4, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 09:15:49', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (125, 'Record updated Change Password For Staff id 3', 3, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 09:16:57', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (126, 'Record updated Change Password For Staff id 4', 4, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 09:17:38', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (127, 'Record updated For Staff id 2', 2, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 09:18:33', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (128, 'Record updated For Staff id 2', 2, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 09:18:33', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (129, 'Record updated For Staff id 3', 3, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 09:18:50', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (130, 'Record updated For Staff id 3', 3, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 09:18:50', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (131, 'New Record inserted On Appointment Created 2', 2, 0, 'Insert', '152.59.223.109', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:17:11', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (132, 'Record deleted On Appointment Deleted id 1', 1, 0, 'Delete', '152.59.223.109', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:17:52', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (133, 'New Record inserted On Appointment Created 3', 3, 0, 'Insert', '152.59.223.109', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:20:32', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (134, 'New Record inserted On Appointment Created 4', 4, 0, 'Insert', '152.59.223.109', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:20:55', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (135, 'New Record inserted On Appointment Created 5', 5, 0, 'Insert', '152.59.223.109', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:22:13', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (136, 'New Record inserted On Appointment Created 6', 6, 0, 'Insert', '152.59.223.109', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:24:32', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (137, 'New Record inserted On Appointment Created 7', 7, 0, 'Insert', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:24:33', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (138, 'New Record inserted On Appointment Created 8', 8, 0, 'Insert', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:24:40', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (139, 'New Record inserted On Appointment Created 9', 9, 0, 'Insert', '152.59.223.109', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:24:43', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (140, 'New Record inserted On Appointment Created 10', 10, 0, 'Insert', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:25:59', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (141, 'New Record inserted On Appointment Created 11', 11, 0, 'Insert', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:26:04', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (142, 'New Record inserted On Appointment Created 12', 12, 0, 'Insert', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:26:12', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (143, 'New Record inserted On Appointment Created 13', 13, 0, 'Insert', '117.231.196.191', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:30:21', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (144, 'New Record inserted On Appointment Created 14', 14, 0, 'Insert', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:30:50', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (145, 'New Record inserted On Appointment Created 15', 15, 0, 'Insert', '117.231.196.191', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:33:20', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (146, 'New Record inserted On Appointment Created 16', 16, 0, 'Insert', '117.231.196.191', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:33:42', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (147, 'New Record inserted On Appointment Created 17', 17, 0, 'Insert', '117.231.196.191', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:34:51', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (148, 'New Record inserted On Appointment Created 18', 18, 0, 'Insert', '117.231.196.191', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:35:15', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (149, 'New Record inserted On Shift Details id 2', 2, 0, 'Insert', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:35:31', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (150, 'Record updated On Shift Details id 3', 3, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:35:48', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (151, 'Record updated On Shift Details id 3', 3, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:36:08', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (152, 'Record updated On Shift Details id 3', 3, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:36:24', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (153, 'Record updated On Shift Details id 3', 3, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:36:56', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (154, 'Record updated On Shift Details id 3', 3, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:37:11', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (155, 'Record updated On Shift Details id 3', 3, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:37:37', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (156, 'New Record inserted On Appointment Created 19', 19, 0, 'Insert', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:38:29', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (157, 'New Record inserted On Appointment Created 20', 20, 0, 'Insert', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:38:40', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (158, 'New Record inserted On Appointment Created 21', 21, 0, 'Insert', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:40:57', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (159, 'New Record inserted On Appointment Created 22', 22, 0, 'Insert', '117.231.196.191', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:45:27', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (160, 'New Record inserted On Appointment Created 23', 23, 0, 'Insert', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:45:43', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (161, 'Record updatedOn Appointment Updated 22', 22, 0, 'Update', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:47:31', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (162, 'Record deleted On Appointment Deleted id 14', 14, 0, 'Delete', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:47:45', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (163, 'Record deleted On Appointment Deleted id 20', 20, 0, 'Delete', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:47:51', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (164, 'Record deleted On  OPD  id 13', 13, 0, 'Delete', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:52:32', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (165, 'Record deleted On  OPD  id 12', 12, 0, 'Delete', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:52:45', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (166, 'Record deleted On  OPD  id 10', 10, 0, 'Delete', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:52:56', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (167, 'Record deleted On  OPD  id 8', 8, 0, 'Delete', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:53:10', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (168, 'Record deleted On  OPD  id 7', 7, 0, 'Delete', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:53:22', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (169, 'Record deleted On  OPD  id 6', 6, 0, 'Delete', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:53:30', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (170, 'Record deleted On  OPD  id 5', 5, 0, 'Delete', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:53:45', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (171, 'Record deleted On Appointment Deleted id 23', 23, 0, 'Delete', '196.250.215.224', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 10:54:22', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (172, 'New Record inserted On Appointment Created 24', 24, 0, 'Insert', '196.96.235.12', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 12:45:14', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (173, 'New Record inserted On Patient id 5', 5, 0, 'Insert', '196.96.235.12', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 12:49:44', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (174, 'Record updated On Patient id 5', 5, 0, 'Update', '196.96.235.12', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 12:49:44', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (175, 'New Record inserted On Patient id 6', 6, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 12:50:40', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (176, 'Record updated On Patient id 6', 6, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 12:50:40', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (177, 'Record updated On Patient id 5', 5, 0, 'Update', '196.96.235.12', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 12:56:18', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (178, 'New Record inserted On Transactions id 15', 15, 0, 'Insert', '196.96.235.12', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 12:56:18', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (179, 'Record updated On Patient id 6', 6, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 12:56:22', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (180, 'New Record inserted On Transactions id 16', 16, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 12:56:22', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (181, 'New Record inserted On Transactions id 17', 17, 0, 'Insert', '196.96.235.12', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 13:01:56', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (182, 'New Record inserted On Transactions id 18', 18, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 13:01:59', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (183, 'Record deleted On  OPD  id 4', 4, 0, 'Delete', '196.96.235.12', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 13:02:58', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (184, 'Record deleted On  OPD  id 14', 14, 0, 'Delete', '196.96.235.12', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 13:03:09', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (185, 'Record deleted On  OPD  id 16', 16, 0, 'Delete', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 13:03:59', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (186, 'Record deleted On  OPD  id 18', 18, 0, 'Delete', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 13:04:23', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (187, 'New Record inserted On Income Head id 1', 1, 0, 'Insert', '196.96.235.12', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 13:23:05', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (188, 'New Record inserted On Expense Head id 1', 1, 0, 'Insert', '196.96.235.12', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 13:23:15', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (189, 'New Record inserted On Item Category id 1', 1, 0, 'Insert', '196.96.235.12', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 13:23:36', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (190, 'New Record inserted On Patient id 7', 7, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 16:52:15', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (191, 'Record updated On Patient id 7', 7, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 16:52:15', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (192, 'Record deleted On  OPD  id 17', 17, 0, 'Delete', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:15:45', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (193, 'Record deleted On  OPD  id 15', 15, 0, 'Delete', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:15:52', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (194, 'New Record inserted On Patient id 8', 8, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:37:06', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (195, 'Record updated On Patient id 8', 8, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:37:06', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (196, 'Record updated On Patient id 8', 8, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:42:31', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (197, 'New Record inserted On Transactions id 19', 19, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:42:31', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (198, 'New Record inserted On Expenses id 1', 1, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:44:42', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (199, 'Record deleted On Appointment Deleted id 22', 22, 0, 'Delete', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:45:25', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (200, 'Record deleted On Appointment Deleted id 24', 24, 0, 'Delete', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:45:30', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (201, 'New Record inserted On Patient id 9', 9, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:46:48', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (202, 'Record updated On Patient id 9', 9, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:46:48', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (203, 'New Record inserted On Income id 1', 1, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:50:28', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (204, 'Record updated On Expenses id 1', 1, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:50:51', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (205, 'New Record inserted On Patient id 10', 10, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:51:42', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (206, 'Record updated On Patient id 10', 10, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:51:42', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (207, 'Record updated On Patient id 10', 10, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:52:15', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (208, 'New Record inserted On Transactions id 20', 20, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:52:15', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (209, 'New Record inserted On Patient id 11', 11, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:53:27', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (210, 'Record updated On Patient id 11', 11, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:53:27', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (211, 'Record updated On Patient id 11', 11, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:55:06', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (212, 'New Record inserted On Transactions id 21', 21, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:55:06', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (213, 'New Record inserted On Patient id 12', 12, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:56:34', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (214, 'Record updated On Patient id 12', 12, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:56:34', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (215, 'Record updated On Patient id 12', 12, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:58:50', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (216, 'New Record inserted On Transactions id 22', 22, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 16:58:50', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (217, 'New Record inserted On Read System Notification id 1', 1, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:01:18', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (218, 'New Record inserted On Read System Notification id 2', 2, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:01:19', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (219, 'New Record inserted On Income id 2', 2, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:02:26', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (220, 'New Record inserted On Patient id 13', 13, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:04:09', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (221, 'Record updated On Patient id 13', 13, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:04:09', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (222, 'Record updated On Patient id 13', 13, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:05:15', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (223, 'New Record inserted On Transactions id 23', 23, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:05:15', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (224, 'Record updated On Transactions id 23', 23, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:05:58', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (225, 'Record updated On Visit Details id 23', 23, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:05:58', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (226, 'New Record inserted On Patient id 14', 14, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:06:53', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (227, 'Record updated On Patient id 14', 14, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:06:53', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (228, 'Record updated On Patient id 14', 14, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:07:21', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (229, 'New Record inserted On Transactions id 24', 24, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:07:21', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (230, 'New Record inserted On Patient id 15', 15, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:08:02', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (231, 'Record updated On Patient id 15', 15, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:08:02', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (232, 'Record updated On Patient id 15', 15, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:09:11', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (233, 'New Record inserted On Transactions id 25', 25, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:09:11', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (234, 'Record updated On Transactions id 23', 23, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:11:27', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (235, 'Record updated On Visit Details id 23', 23, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:11:27', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (236, 'Record updated On Transactions id 25', 25, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:12:28', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (237, 'Record updated On Visit Details id 25', 25, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:12:28', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (238, 'New Record inserted On Read System Notification id 3', 3, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:16:05', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (239, 'New Record inserted On Patient id 16', 16, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:32:40', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (240, 'Record updated On Patient id 16', 16, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:32:40', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (241, 'Record updated On Patient id 16', 16, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:33:32', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (242, 'New Record inserted On Transactions id 26', 26, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:33:32', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (243, 'New Record inserted On Expenses id 2', 2, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:41:46', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (244, 'Record updated On Expenses id 2', 2, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 17:42:50', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (245, 'Record updated On Transactions id 24', 24, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 18:04:27', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (246, 'Record updated On Visit Details id 24', 24, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-01 18:04:27', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (247, 'New Record inserted On Staff Attendance id 1', 1, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:01:35', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (248, 'New Record inserted On Staff Attendance id 2', 2, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:01:35', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (249, 'New Record inserted On Staff Attendance id 3', 3, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:01:35', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (250, 'Record updated For Staff id 5', 5, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:05:18', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (251, 'Record updated For Staff id 2', 2, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:05:51', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (252, 'Record updated For Staff id 2', 2, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:05:51', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (253, 'Record updated For Staff id 3', 3, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:06:04', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (254, 'Record updated For Staff id 3', 3, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:06:04', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (255, 'Record updated For Staff id 3', 3, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:06:16', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (256, 'Record updated For Staff id 3', 3, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:06:16', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (257, 'Record updated For Staff id 4', 4, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:06:34', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (258, 'Record updated For Staff id 4', 4, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:06:34', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (259, 'Record updated For Staff id 5', 5, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:06:45', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (260, 'Record updated For Staff id 5', 5, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:06:45', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (261, 'Record updated For Staff id 2', 2, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:08:24', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (262, 'Record updated For Staff id 2', 2, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:08:24', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (263, 'Record updated For Staff id 3', 3, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:09:39', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (264, 'Record updated For Staff id 3', 3, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 08:09:39', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (265, 'New Record inserted On Patient id 17', 17, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 11:43:18', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (266, 'Record updated On Patient id 17', 17, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 11:43:18', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (267, 'Record updated On Patient id 17', 17, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 11:46:29', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (268, 'New Record inserted On Transactions id 27', 27, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 11:46:29', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (269, 'New Record inserted On Income id 3', 3, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 11:49:38', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (270, 'New Record inserted On Patient id 18', 18, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 13:42:43', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (271, 'Record updated On Patient id 18', 18, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 13:42:43', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (272, 'Record updated On Patient id 18', 18, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 13:43:58', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (273, 'New Record inserted On Transactions id 28', 28, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 13:43:58', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (274, 'New Record inserted On Patient id 19', 19, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 13:44:55', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (275, 'Record updated On Patient id 19', 19, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 13:44:55', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (276, 'Record updated On Patient id 19', 19, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 13:50:24', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (277, 'New Record inserted On Transactions id 29', 29, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 13:50:24', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (278, 'Record updated On Transactions id 29', 29, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 13:50:58', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (279, 'Record updated On Visit Details id 29', 29, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 13:50:58', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (280, 'New Record inserted On Income id 4', 4, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 14:03:34', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (281, 'New Record inserted On Messages Send SMS id 1', 1, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 14:14:03', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (282, 'New Record inserted On Patient id 20', 20, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 16:24:53', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (283, 'Record updated On Patient id 20', 20, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 16:24:53', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (284, 'Record updated On Patient id 20', 20, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 16:26:48', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (285, 'New Record inserted On Transactions id 30', 30, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 104.0.0.0', '2025-07-02 16:26:48', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (286, 'New Record inserted On Patient id 21', 21, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:12:38', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (287, 'Record updated On Patient id 21', 21, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:12:38', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (288, 'Record updated On Patient id 21', 21, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:14:38', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (289, 'New Record inserted On Transactions id 31', 31, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:14:38', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (290, 'Record updated On Transactions id 31', 31, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:15:16', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (291, 'Record updated On Visit Details id 31', 31, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:15:16', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (292, 'New Record inserted On Patient id 22', 22, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:19:37', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (293, 'Record updated On Patient id 22', 22, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:19:37', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (294, 'Record updated On Patient id 22', 22, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:20:09', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (295, 'New Record inserted On Transactions id 32', 32, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:20:09', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (296, 'Record updated On Transactions id 32', 32, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:21:12', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (297, 'Record updated On Visit Details id 32', 32, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:21:12', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (298, 'Record updated On Transactions id 32', 32, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:23:58', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (299, 'Record updated On Visit Details id 32', 32, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:23:58', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (300, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '196.250.215.140', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-02 19:48:00', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (301, 'Record updated For Staff id 1', 1, 0, 'Update', '154.155.173.133', 'Android', 'Chrome 137.0.0.0', '2025-07-02 20:14:00', '2025-07-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (302, 'Record updated For Staff id 4', 4, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:05:38', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (303, 'New Record inserted On Patient id 23', 23, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:10:48', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (304, 'Record updated On Patient id 23', 23, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:10:48', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (305, 'Record updated On Patient id 23', 23, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:12:22', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (306, 'New Record inserted On Transactions id 33', 33, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:12:22', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (307, 'Record updated On Transactions id 33', 33, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:15:57', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (308, 'Record updated On Visit Details id 33', 33, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:15:57', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (309, 'Record updated On Transactions id 33', 33, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:18:34', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (310, 'Record updated On Visit Details id 33', 33, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:18:34', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (311, 'Record deleted On  OPD  id 33', 33, 0, 'Delete', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:20:02', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (312, 'New Record inserted On Patient id 24', 24, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:20:57', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (313, 'Record updated On Patient id 24', 24, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:20:57', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (314, 'Record updated On Patient id 24', 24, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:21:39', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (315, 'New Record inserted On Transactions id 34', 34, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:21:39', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (316, 'Record updated On Transactions id 34', 34, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:23:10', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (317, 'Record updated On Visit Details id 34', 34, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:23:10', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (318, 'Record deleted On  OPD  id 34', 34, 0, 'Delete', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:26:21', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (319, 'Record updated For Staff id 2', 2, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 11:32:08', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (320, 'New Record inserted On Patient id 25', 25, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:34:06', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (321, 'Record updated On Patient id 25', 25, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:34:06', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (322, 'Record updated On Patient id 25', 25, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:34:47', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (323, 'New Record inserted On Transactions id 35', 35, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:34:47', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (324, 'Record updated On Transactions id 35', 35, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:35:32', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (325, 'Record updated On Visit Details id 35', 35, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:35:32', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (326, 'New Record inserted On Patient id 26', 26, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:39:13', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (327, 'Record updated On Patient id 26', 26, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:39:13', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (328, 'Record updated On Patient id 26', 26, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:39:58', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (329, 'New Record inserted On Transactions id 36', 36, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:39:58', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (330, 'New Record inserted On Patient id 27', 27, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:41:05', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (331, 'Record updated On Patient id 27', 27, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:41:05', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (332, 'Record updated On Patient id 27', 27, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:41:48', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (333, 'New Record inserted On Transactions id 37', 37, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:41:48', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (334, 'Record updated On Transactions id 37', 37, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:42:17', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (335, 'Record updated On Visit Details id 37', 37, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 14:42:17', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (336, 'Record updated For Staff id 2', 2, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 11:45:17', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (337, 'New Record inserted On Patient id 28', 28, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 16:40:49', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (338, 'Record updated On Patient id 28', 28, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 16:40:49', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (339, 'Record updated On Patient id 28', 28, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 16:43:36', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (340, 'New Record inserted On Transactions id 38', 38, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 16:43:36', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (341, 'New Record inserted On Patient id 29', 29, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 16:46:05', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (342, 'Record updated On Patient id 29', 29, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 16:46:05', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (343, 'Record updated On Patient id 29', 29, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 16:48:32', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (344, 'New Record inserted On Transactions id 39', 39, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 16:48:32', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (345, 'New Record inserted On Patient id 30', 30, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 18:50:21', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (346, 'Record updated On Patient id 30', 30, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 18:50:21', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (347, 'Record updated On Patient id 30', 30, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 18:51:34', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (348, 'New Record inserted On Transactions id 40', 40, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 18:51:34', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (349, 'Record updated On Transactions id 40', 40, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 18:52:51', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (350, 'Record updated On Visit Details id 40', 40, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 18:52:51', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (351, 'New Record inserted On Patient id 31', 31, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 18:54:04', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (352, 'Record updated On Patient id 31', 31, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 18:54:04', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (353, 'Record updated On Patient id 31', 31, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 18:55:04', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (354, 'New Record inserted On Transactions id 41', 41, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 18:55:04', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (355, 'Record updated On Transactions id 41', 41, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 18:55:31', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (356, 'Record updated On Visit Details id 41', 41, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 18:55:31', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (357, 'Record updated On Transactions id 19', 19, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:00:40', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (358, 'Record updated On Visit Details id 19', 19, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:00:40', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (359, 'Record updated On Transactions id 22', 22, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:01:51', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (360, 'Record updated On Visit Details id 22', 22, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:01:51', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (361, 'Record updated On Transactions id 27', 27, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:02:41', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (362, 'Record updated On Visit Details id 27', 27, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:02:41', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (363, 'Record updated On Transactions id 29', 29, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:03:16', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (364, 'Record updated On Visit Details id 29', 29, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:03:16', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (365, 'Record deleted Where Income  id 2', 2, 0, 'Delete', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:03:28', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (366, 'Record deleted Where Income  id 4', 4, 0, 'Delete', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:03:31', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (367, 'Record deleted Where Income  id 3', 3, 0, 'Delete', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:03:33', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (368, 'Record deleted Where Income  id 1', 1, 0, 'Delete', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:03:35', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (369, 'Record updated On Transactions id 41', 41, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:07:36', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (370, 'Record updated On Visit Details id 41', 41, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:07:36', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (371, 'Record updated On Transactions id 24', 24, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:18:18', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (372, 'Record updated On Visit Details id 24', 24, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:18:18', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (373, 'New Record inserted On Patient id 32', 32, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:21:17', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (374, 'Record updated On Patient id 32', 32, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:21:17', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (375, 'Record updated On Patient id 32', 32, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:21:48', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (376, 'New Record inserted On Transactions id 42', 42, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:21:48', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (377, 'Record updated On Transactions id 42', 42, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:22:01', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (378, 'Record updated On Visit Details id 42', 42, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 19:22:01', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (379, 'New Record inserted On Patient id 33', 33, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 10:52:19', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (380, 'Record updated On Patient id 33', 33, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 10:52:19', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (381, 'Record updated On Patient id 33', 33, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 12:19:50', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (382, 'New Record inserted On Transactions id 43', 43, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 12:19:50', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (383, 'New Record inserted On Patient id 34', 34, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:24:41', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (384, 'Record updated On Patient id 34', 34, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:24:41', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (385, 'Record updated On Patient id 34', 34, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:25:14', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (386, 'New Record inserted On Transactions id 44', 44, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:25:14', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (387, 'Record updated On Transactions id 44', 44, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:25:27', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (388, 'Record updated On Visit Details id 44', 44, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:25:27', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (389, 'New Record inserted On Patient id 35', 35, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:28:04', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (390, 'Record updated On Patient id 35', 35, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:28:04', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (391, 'Record updated On Patient id 35', 35, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:28:44', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (392, 'New Record inserted On Transactions id 45', 45, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:28:44', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (393, 'Record updated On Transactions id 45', 45, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:28:58', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (394, 'Record updated On Visit Details id 45', 45, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:28:58', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (395, 'New Record inserted On Patient id 36', 36, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:29:55', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (396, 'Record updated On Patient id 36', 36, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:29:55', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (397, 'Record updated On Patient id 36', 36, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:30:24', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (398, 'New Record inserted On Transactions id 46', 46, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:30:24', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (399, 'Record updated On Transactions id 46', 46, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:30:38', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (400, 'Record updated On Visit Details id 46', 46, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:30:38', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (401, 'New Record inserted On Patient id 37', 37, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:31:21', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (402, 'Record updated On Patient id 37', 37, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:31:21', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (403, 'Record updated On Patient id 37', 37, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:31:51', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (404, 'New Record inserted On Transactions id 47', 47, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:31:51', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (405, 'Record updated On Transactions id 47', 47, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:32:02', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (406, 'Record updated On Visit Details id 47', 47, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 14:32:02', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (407, 'New Record inserted On Patient id 38', 38, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 18:55:19', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (408, 'Record updated On Patient id 38', 38, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 18:55:19', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (409, 'Record updated On Patient id 38', 38, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 18:55:56', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (410, 'New Record inserted On Transactions id 48', 48, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 18:55:56', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (411, 'New Record inserted On Patient id 39', 39, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 18:57:06', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (412, 'Record updated On Patient id 39', 39, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 18:57:06', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (413, 'Record updated On Patient id 39', 39, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 18:57:26', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (414, 'New Record inserted On Transactions id 49', 49, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 18:57:26', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (415, 'Record updated On Transactions id 49', 49, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 18:57:45', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (416, 'Record updated On Visit Details id 49', 49, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 18:57:45', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (417, 'New Record inserted On Patient id 40', 40, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 19:00:15', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (418, 'Record updated On Patient id 40', 40, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 19:00:15', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (419, 'Record updated On Patient id 40', 40, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 19:00:41', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (420, 'New Record inserted On Transactions id 50', 50, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-04 19:00:41', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (421, 'New Record inserted On Patient id 41', 41, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:32:30', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (422, 'Record updated On Patient id 41', 41, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:32:30', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (423, 'Record updated On Patient id 41', 41, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:32:59', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (424, 'New Record inserted On Transactions id 51', 51, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:32:59', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (425, 'Record updated On Transactions id 51', 51, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:33:25', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (426, 'Record updated On Visit Details id 51', 51, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:33:25', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (427, 'New Record inserted On Patient id 42', 42, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:34:26', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (428, 'Record updated On Patient id 42', 42, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:34:26', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (429, 'Record updated On Patient id 42', 42, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:34:48', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (430, 'New Record inserted On Transactions id 52', 52, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:34:48', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (431, 'Record updated On Transactions id 52', 52, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:35:11', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (432, 'Record updated On Visit Details id 52', 52, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:35:11', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (433, 'New Record inserted On Patient id 43', 43, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:39:24', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (434, 'Record updated On Patient id 43', 43, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:39:24', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (435, 'New Record inserted On Patient id 44', 44, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:41:08', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (436, 'Record updated On Patient id 44', 44, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:41:08', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (437, 'Record updated On Patient id 44', 44, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:42:23', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (438, 'New Record inserted On Transactions id 53', 53, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:42:23', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (439, 'New Record inserted On Patient id 45', 45, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:43:35', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (440, 'Record updated On Patient id 45', 45, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:43:35', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (441, 'Record updated On Patient id 45', 45, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:43:57', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (442, 'New Record inserted On Transactions id 54', 54, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:43:57', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (443, 'Record updated On Transactions id 54', 54, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:44:09', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (444, 'Record updated On Visit Details id 54', 54, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:44:09', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (445, 'New Record inserted On Patient id 46', 46, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:45:09', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (446, 'Record updated On Patient id 46', 46, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:45:09', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (447, 'Record updated On Patient id 46', 46, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:45:30', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (448, 'New Record inserted On Transactions id 55', 55, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:45:30', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (449, 'New Record inserted On Patient id 47', 47, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:46:29', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (450, 'Record updated On Patient id 47', 47, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:46:29', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (451, 'Record updated On Patient id 47', 47, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:46:53', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (452, 'New Record inserted On Transactions id 56', 56, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:46:53', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (453, 'Record updated On Transactions id 56', 56, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:47:03', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (454, 'Record updated On Visit Details id 56', 56, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:47:03', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (455, 'New Record inserted On Patient id 48', 48, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:47:53', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (456, 'Record updated On Patient id 48', 48, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:47:53', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (457, 'Record updated On Patient id 48', 48, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:48:20', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (458, 'New Record inserted On Transactions id 57', 57, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:48:20', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (459, 'New Record inserted On Patient id 49', 49, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:49:08', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (460, 'Record updated On Patient id 49', 49, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:49:08', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (461, 'Record updated On Patient id 49', 49, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:49:31', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (462, 'New Record inserted On Transactions id 58', 58, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:49:31', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (463, 'Record updated On Transactions id 58', 58, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:49:42', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (464, 'Record updated On Visit Details id 58', 58, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:49:42', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (465, 'New Record inserted On Patient id 50', 50, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:50:41', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (466, 'Record updated On Patient id 50', 50, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:50:41', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (467, 'Record updated On Patient id 50', 50, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:51:10', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (468, 'New Record inserted On Transactions id 59', 59, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:51:10', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (469, 'Record updated On Transactions id 59', 59, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:51:23', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (470, 'Record updated On Visit Details id 59', 59, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:51:23', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (471, 'New Record inserted On Patient id 51', 51, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:52:16', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (472, 'Record updated On Patient id 51', 51, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:52:16', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (473, 'Record updated On Patient id 51', 51, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:53:14', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (474, 'New Record inserted On Transactions id 60', 60, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:53:14', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (475, 'Record updated On Transactions id 60', 60, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:53:24', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (476, 'Record updated On Visit Details id 60', 60, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:53:24', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (477, 'New Record inserted On Patient id 52', 52, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:54:29', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (478, 'Record updated On Patient id 52', 52, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:54:29', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (479, 'Record updated On Patient id 52', 52, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:54:52', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (480, 'New Record inserted On Transactions id 61', 61, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:54:52', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (481, 'Record updated On Transactions id 61', 61, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:55:03', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (482, 'Record updated On Visit Details id 61', 61, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-05 18:55:03', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (483, 'New Record inserted On Patient id 53', 53, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:51:04', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (484, 'Record updated On Patient id 53', 53, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:51:04', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (485, 'Record updated On Patient id 53', 53, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:51:31', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (486, 'New Record inserted On Transactions id 62', 62, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:51:31', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (487, 'Record updated On Transactions id 62', 62, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:51:45', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (488, 'Record updated On Visit Details id 62', 62, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:51:45', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (489, 'New Record inserted On Patient id 54', 54, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:52:38', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (490, 'Record updated On Patient id 54', 54, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:52:38', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (491, 'Record updated On Patient id 54', 54, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:53:10', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (492, 'New Record inserted On Transactions id 63', 63, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:53:10', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (493, 'New Record inserted On Patient id 55', 55, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:55:06', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (494, 'Record updated On Patient id 55', 55, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:55:06', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (495, 'Record updated On Patient id 55', 55, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:55:27', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (496, 'New Record inserted On Transactions id 64', 64, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:55:27', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (497, 'Record updated On Transactions id 64', 64, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:55:42', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (498, 'Record updated On Visit Details id 64', 64, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:55:42', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (499, 'New Record inserted On Patient id 56', 56, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:56:21', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (500, 'Record updated On Patient id 56', 56, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:56:21', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (501, 'Record updated On Patient id 56', 56, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:56:43', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (502, 'New Record inserted On Transactions id 65', 65, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:56:43', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (503, 'Record updated On Transactions id 65', 65, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:56:56', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (504, 'Record updated On Visit Details id 65', 65, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:56:56', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (505, 'New Record inserted On Patient id 57', 57, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:57:52', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (506, 'Record updated On Patient id 57', 57, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:57:52', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (507, 'Record updated On Patient id 57', 57, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:58:11', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (508, 'New Record inserted On Transactions id 66', 66, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:58:11', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (509, 'New Record inserted On Patient id 58', 58, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:59:12', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (510, 'Record updated On Patient id 58', 58, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:59:12', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (511, 'Record updated On Patient id 58', 58, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:59:48', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (512, 'New Record inserted On Transactions id 67', 67, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:59:48', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (513, 'Record updated On Transactions id 67', 67, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:59:59', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (514, 'Record updated On Visit Details id 67', 67, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 17:59:59', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (515, 'New Record inserted On Patient id 59', 59, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:00:46', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (516, 'Record updated On Patient id 59', 59, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:00:46', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (517, 'Record updated On Patient id 59', 59, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:01:08', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (518, 'New Record inserted On Transactions id 68', 68, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:01:08', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (519, 'Record updated On Transactions id 68', 68, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:01:18', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (520, 'Record updated On Visit Details id 68', 68, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:01:18', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (521, 'New Record inserted On Patient id 60', 60, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:02:05', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (522, 'Record updated On Patient id 60', 60, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:02:05', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (523, 'Record updated On Patient id 60', 60, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:02:30', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (524, 'New Record inserted On Transactions id 69', 69, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:02:30', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (525, 'Record updated On Transactions id 69', 69, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:02:41', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (526, 'Record updated On Visit Details id 69', 69, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:02:41', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (527, 'New Record inserted On Expenses id 3', 3, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:05:20', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (528, 'Record updated On Expenses id 3', 3, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-06 18:05:26', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (529, 'New Record inserted On Patient id 61', 61, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:41:32', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (530, 'Record updated On Patient id 61', 61, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:41:32', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (531, 'Record updated On Patient id 61', 61, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:41:55', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (532, 'New Record inserted On Transactions id 70', 70, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:41:55', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (533, 'New Record inserted On Patient id 62', 62, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:42:59', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (534, 'Record updated On Patient id 62', 62, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:42:59', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (535, 'Record updated On Patient id 62', 62, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:43:25', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (536, 'New Record inserted On Transactions id 71', 71, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:43:26', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (537, 'New Record inserted On Patient id 63', 63, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:44:11', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (538, 'Record updated On Patient id 63', 63, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:44:11', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (539, 'Record updated On Patient id 63', 63, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:44:39', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (540, 'New Record inserted On Transactions id 72', 72, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:44:39', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (541, 'New Record inserted On Patient id 64', 64, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:45:15', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (542, 'Record updated On Patient id 64', 64, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:45:15', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (543, 'Record updated On Patient id 64', 64, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:45:37', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (544, 'New Record inserted On Transactions id 73', 73, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:45:37', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (545, 'New Record inserted On Patient id 65', 65, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:46:23', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (546, 'Record updated On Patient id 65', 65, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:46:23', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (547, 'Record updated On Patient id 65', 65, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:47:33', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (548, 'New Record inserted On Transactions id 74', 74, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:47:33', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (549, 'Record updated On Transactions id 74', 74, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:47:53', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (550, 'Record updated On Visit Details id 74', 74, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:47:53', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (551, 'New Record inserted On Patient id 66', 66, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:48:28', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (552, 'Record updated On Patient id 66', 66, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:48:28', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (553, 'Record updated On Patient id 66', 66, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:49:26', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (554, 'New Record inserted On Transactions id 75', 75, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:49:26', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (555, 'New Record inserted On Patient id 67', 67, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:50:33', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (556, 'Record updated On Patient id 67', 67, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:50:33', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (557, 'Record updated On Patient id 67', 67, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:50:58', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (558, 'New Record inserted On Transactions id 76', 76, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:50:58', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (559, 'Record updated On Transactions id 76', 76, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:51:23', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (560, 'Record updated On Visit Details id 76', 76, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:51:23', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (561, 'New Record inserted On Patient id 68', 68, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:52:16', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (562, 'Record updated On Patient id 68', 68, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:52:16', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (563, 'Record updated On Patient id 68', 68, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:52:33', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (564, 'New Record inserted On Transactions id 77', 77, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:52:33', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (565, 'New Record inserted On Patient id 69', 69, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:53:24', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (566, 'Record updated On Patient id 69', 69, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:53:24', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (567, 'Record updated On Patient id 69', 69, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:53:48', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (568, 'New Record inserted On Transactions id 78', 78, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:53:48', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (569, 'Record updated On Transactions id 78', 78, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:53:59', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (570, 'Record updated On Visit Details id 78', 78, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:53:59', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (571, 'New Record inserted On Patient id 70', 70, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:54:57', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (572, 'Record updated On Patient id 70', 70, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:54:57', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (573, 'Record updated On Patient id 70', 70, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:55:27', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (574, 'New Record inserted On Transactions id 79', 79, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:55:27', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (575, 'New Record inserted On Patient id 71', 71, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:56:00', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (576, 'Record updated On Patient id 71', 71, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:56:00', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (577, 'Record updated On Patient id 71', 71, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:56:18', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (578, 'New Record inserted On Transactions id 80', 80, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:56:18', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (579, 'Record updated On Transactions id 71', 71, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:59:13', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (580, 'Record updated On Visit Details id 71', 71, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:59:13', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (581, 'Record updated On Transactions id 72', 72, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:59:27', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (582, 'Record updated On Visit Details id 72', 72, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-07 18:59:27', '2025-07-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (583, 'New Record inserted On Patient id 72', 72, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:14:22', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (584, 'Record updated On Patient id 72', 72, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:14:22', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (585, 'Record updated On Patient id 72', 72, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:14:39', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (586, 'New Record inserted On Transactions id 81', 81, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:14:39', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (587, 'New Record inserted On Patient id 73', 73, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:15:26', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (588, 'Record updated On Patient id 73', 73, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:15:26', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (589, 'Record updated On Patient id 73', 73, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:15:42', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (590, 'New Record inserted On Transactions id 82', 82, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:15:42', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (591, 'New Record inserted On Patient id 74', 74, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:19:32', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (592, 'Record updated On Patient id 74', 74, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:19:32', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (593, 'Record updated On Patient id 74', 74, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:20:17', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (594, 'New Record inserted On Transactions id 83', 83, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:20:17', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (595, 'Record updated On Transactions id 83', 83, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:20:29', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (596, 'Record updated On Visit Details id 83', 83, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:20:29', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (597, 'New Record inserted On Patient id 75', 75, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:20:56', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (598, 'Record updated On Patient id 75', 75, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:20:56', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (599, 'Record updated On Patient id 75', 75, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:22:58', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (600, 'New Record inserted On Transactions id 84', 84, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:22:58', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (601, 'Record updated On Transactions id 84', 84, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:23:32', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (602, 'Record updated On Visit Details id 84', 84, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:23:32', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (603, 'New Record inserted On Expenses id 4', 4, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-08 19:26:38', '2025-07-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (604, 'New Record inserted On Patient id 76', 76, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:55:12', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (605, 'Record updated On Patient id 76', 76, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:55:12', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (606, 'Record updated On Patient id 76', 76, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:55:41', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (607, 'New Record inserted On Transactions id 85', 85, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:55:41', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (608, 'Record updated On Transactions id 85', 85, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:55:52', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (609, 'Record updated On Visit Details id 85', 85, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:55:52', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (610, 'New Record inserted On Patient id 77', 77, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:56:34', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (611, 'Record updated On Patient id 77', 77, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:56:34', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (612, 'Record updated On Patient id 77', 77, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:56:57', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (613, 'New Record inserted On Transactions id 86', 86, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:56:57', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (614, 'Record updated On Transactions id 86', 86, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:57:13', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (615, 'Record updated On Visit Details id 86', 86, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:57:13', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (616, 'New Record inserted On Patient id 78', 78, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:58:16', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (617, 'Record updated On Patient id 78', 78, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:58:16', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (618, 'Record updated On Patient id 78', 78, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:58:33', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (619, 'New Record inserted On Transactions id 87', 87, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:58:33', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (620, 'Record updated On Transactions id 87', 87, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:58:44', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (621, 'Record updated On Visit Details id 87', 87, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:58:44', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (622, 'New Record inserted On Patient id 79', 79, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:59:55', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (623, 'Record updated On Patient id 79', 79, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 17:59:55', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (624, 'Record updated On Patient id 79', 79, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:00:28', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (625, 'New Record inserted On Transactions id 88', 88, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:00:28', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (626, 'Record updated On Transactions id 88', 88, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:00:55', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (627, 'Record updated On Visit Details id 88', 88, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:00:55', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (628, 'New Record inserted On Patient id 80', 80, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:02:11', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (629, 'Record updated On Patient id 80', 80, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:02:11', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (630, 'Record updated On Patient id 80', 80, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:03:11', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (631, 'New Record inserted On Transactions id 89', 89, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:03:11', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (632, 'New Record inserted On Patient id 81', 81, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:06:19', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (633, 'Record updated On Patient id 81', 81, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:06:19', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (634, 'Record updated On Patient id 81', 81, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:07:51', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (635, 'New Record inserted On Transactions id 90', 90, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:07:51', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (636, 'New Record inserted On Patient id 82', 82, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:09:46', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (637, 'Record updated On Patient id 82', 82, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:09:46', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (638, 'Record updated On Patient id 82', 82, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:12:13', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (639, 'New Record inserted On Transactions id 91', 91, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:12:13', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (640, 'New Record inserted On Patient id 83', 83, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:13:51', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (641, 'Record updated On Patient id 83', 83, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:13:51', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (642, 'Record updated On Patient id 83', 83, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:14:36', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (643, 'New Record inserted On Transactions id 92', 92, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:14:36', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (644, 'Record updated On Transactions id 92', 92, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:15:22', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (645, 'Record updated On Visit Details id 92', 92, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:15:22', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (646, 'New Record inserted On Patient id 84', 84, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:21:46', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (647, 'Record updated On Patient id 84', 84, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:21:46', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (648, 'Record updated On Patient id 84', 84, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:22:21', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (649, 'New Record inserted On Transactions id 93', 93, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:22:21', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (650, 'Record updated On Transactions id 93', 93, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:22:34', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (651, 'Record updated On Visit Details id 93', 93, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:22:34', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (652, 'New Record inserted On Expenses id 5', 5, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 18:41:38', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (653, 'New Record inserted On Patient id 85', 85, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 20:27:20', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (654, 'Record updated On Patient id 85', 85, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 20:27:20', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (655, 'Record updated On Patient id 85', 85, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 20:27:44', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (656, 'New Record inserted On Transactions id 94', 94, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 20:27:44', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (657, 'Record updated On Transactions id 94', 94, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 20:27:57', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (658, 'Record updated On Visit Details id 94', 94, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 20:27:57', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (659, 'New Record inserted On Expenses id 6', 6, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 20:29:03', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (660, 'New Record inserted On Expenses id 7', 7, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 20:29:34', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (661, 'New Record inserted On Expenses id 8', 8, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-09 20:30:30', '2025-07-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (662, 'New Record inserted On Patient id 86', 86, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 20:38:57', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (663, 'Record updated On Patient id 86', 86, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 20:38:57', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (664, 'Record updated On Patient id 86', 86, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 20:44:19', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (665, 'New Record inserted On Transactions id 95', 95, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 20:44:19', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (666, 'Record updated On Transactions id 95', 95, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 20:44:30', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (667, 'Record updated On Visit Details id 95', 95, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 20:44:30', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (668, 'New Record inserted On Patient id 87', 87, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 20:45:57', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (669, 'Record updated On Patient id 87', 87, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 20:45:57', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (670, 'Record updated On Patient id 87', 87, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 20:46:22', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (671, 'New Record inserted On Transactions id 96', 96, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 20:46:22', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (672, 'Record updated On Transactions id 96', 96, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 20:46:33', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (673, 'Record updated On Visit Details id 96', 96, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 20:46:33', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (674, 'New Record inserted On Patient id 88', 88, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 22:00:24', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (675, 'Record updated On Patient id 88', 88, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 22:00:24', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (676, 'Record updated On Patient id 88', 88, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 22:00:46', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (677, 'New Record inserted On Transactions id 97', 97, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 22:00:46', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (678, 'New Record inserted On Patient id 89', 89, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 22:01:47', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (679, 'Record updated On Patient id 89', 89, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 22:01:47', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (680, 'Record updated On Patient id 89', 89, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 22:02:21', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (681, 'New Record inserted On Transactions id 98', 98, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 22:02:21', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (682, 'Record updated On Transactions id 98', 98, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 22:02:32', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (683, 'Record updated On Visit Details id 98', 98, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 22:02:32', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (684, 'New Record inserted On Expenses id 9', 9, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-10 22:04:45', '2025-07-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (685, 'New Record inserted On Patient id 90', 90, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:19:04', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (686, 'Record updated On Patient id 90', 90, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:19:04', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (687, 'Record updated On Patient id 90', 90, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:21:51', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (688, 'New Record inserted On Patient id 91', 91, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:28:03', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (689, 'Record updated On Patient id 91', 91, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:28:03', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (690, 'Record updated On Patient id 91', 91, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:28:24', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (691, 'New Record inserted On Transactions id 99', 99, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:28:24', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (692, 'Record updated On Transactions id 99', 99, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:28:37', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (693, 'Record updated On Visit Details id 99', 99, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:28:37', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (694, 'New Record inserted On Patient id 92', 92, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:31:35', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (695, 'Record updated On Patient id 92', 92, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:31:35', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (696, 'Record updated On Patient id 92', 92, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:32:06', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (697, 'New Record inserted On Transactions id 100', 100, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:32:06', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (698, 'Record updated On Transactions id 100', 100, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:32:25', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (699, 'Record updated On Visit Details id 100', 100, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:32:25', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (700, 'New Record inserted On Patient id 93', 93, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:36:34', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (701, 'Record updated On Patient id 93', 93, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:36:34', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (702, 'Record updated On Patient id 93', 93, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:36:52', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (703, 'New Record inserted On Transactions id 101', 101, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:36:52', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (704, 'New Record inserted On Patient id 94', 94, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:37:48', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (705, 'Record updated On Patient id 94', 94, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:37:48', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (706, 'Record updated On Patient id 94', 94, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:38:34', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (707, 'New Record inserted On Transactions id 102', 102, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 09:38:34', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (708, 'New Record inserted On Patient id 95', 95, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:48:18', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (709, 'Record updated On Patient id 95', 95, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:48:18', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (710, 'Record updated On Patient id 95', 95, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:48:39', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (711, 'New Record inserted On Transactions id 103', 103, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:48:39', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (712, 'Record updated On Transactions id 103', 103, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:49:29', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (713, 'Record updated On Visit Details id 103', 103, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:49:29', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (714, 'New Record inserted On Patient id 96', 96, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:49:58', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (715, 'Record updated On Patient id 96', 96, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:49:58', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (716, 'Record updated On Patient id 96', 96, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:50:17', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (717, 'New Record inserted On Transactions id 104', 104, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:50:17', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (718, 'Record updated On Transactions id 104', 104, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:50:27', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (719, 'Record updated On Visit Details id 104', 104, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:50:27', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (720, 'New Record inserted On Patient id 97', 97, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:51:04', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (721, 'Record updated On Patient id 97', 97, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:51:04', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (722, 'Record updated On Patient id 97', 97, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:51:17', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (723, 'New Record inserted On Transactions id 105', 105, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:51:17', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (724, 'Record updated On Transactions id 105', 105, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:51:26', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (725, 'Record updated On Visit Details id 105', 105, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:51:27', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (726, 'New Record inserted On Patient id 98', 98, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:52:29', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (727, 'Record updated On Patient id 98', 98, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:52:29', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (728, 'Record updated On Patient id 98', 98, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:53:01', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (729, 'New Record inserted On Transactions id 106', 106, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:53:01', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (730, 'Record updated On Transactions id 106', 106, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:53:45', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (731, 'Record updated On Visit Details id 106', 106, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:53:45', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (732, 'New Record inserted On Patient id 99', 99, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:54:49', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (733, 'Record updated On Patient id 99', 99, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:54:49', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (734, 'New Record inserted On Patient id 100', 100, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:55:25', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (735, 'Record updated On Patient id 100', 100, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:55:25', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (736, 'Record updated On Patient id 100', 100, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:55:39', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (737, 'New Record inserted On Transactions id 107', 107, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-12 18:55:39', '2025-07-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (738, 'Record updated For Staff id 1', 1, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:01:11', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (739, 'New Record inserted On Patient id 101', 101, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:02:06', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (740, 'Record updated On Patient id 101', 101, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:02:06', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (741, 'Record updated On Patient id 101', 101, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:02:42', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (742, 'New Record inserted On Transactions id 108', 108, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:02:42', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (743, 'Record updated On Transactions id 108', 108, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:03:23', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (744, 'Record updated On Visit Details id 108', 108, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:03:23', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (745, 'New Record inserted On Patient id 102', 102, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:06:56', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (746, 'Record updated On Patient id 102', 102, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:06:56', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (747, 'New Record inserted On Patient id 103', 103, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:08:37', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (748, 'Record updated On Patient id 103', 103, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:08:37', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (749, 'Record updated On Patient id 103', 103, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:09:17', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (750, 'New Record inserted On Transactions id 109', 109, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:09:17', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (751, 'Record updated On Transactions id 109', 109, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:09:36', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (752, 'Record updated On Visit Details id 109', 109, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:09:36', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (753, 'New Record inserted On Patient id 104', 104, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:12:02', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (754, 'Record updated On Patient id 104', 104, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:12:02', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (755, 'New Record inserted On Patient id 105', 105, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:13:36', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (756, 'Record updated On Patient id 105', 105, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:13:36', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (757, 'Record updated On Patient id 105', 105, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:13:59', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (758, 'New Record inserted On Transactions id 110', 110, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:13:59', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (759, 'Record updated On Transactions id 110', 110, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:14:14', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (760, 'Record updated On Visit Details id 110', 110, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:14:14', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (761, 'New Record inserted On Patient id 106', 106, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:14:51', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (762, 'Record updated On Patient id 106', 106, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:14:51', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (763, 'Record updated On Patient id 106', 106, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:15:17', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (764, 'New Record inserted On Transactions id 111', 111, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:15:17', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (765, 'Record updated On Transactions id 111', 111, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:15:28', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (766, 'Record updated On Visit Details id 111', 111, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:15:28', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (767, 'New Record inserted On Patient id 107', 107, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:16:08', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (768, 'Record updated On Patient id 107', 107, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:16:08', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (769, 'Record updated On Patient id 107', 107, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:17:16', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (770, 'New Record inserted On Transactions id 112', 112, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:17:16', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (771, 'New Record inserted On Expenses id 10', 10, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-13 18:21:35', '2025-07-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (772, 'New Record inserted On Patient id 108', 108, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 18:55:13', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (773, 'Record updated On Patient id 108', 108, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 18:55:13', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (774, 'Record updated On Patient id 108', 108, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 18:56:54', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (775, 'New Record inserted On Transactions id 113', 113, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 18:56:54', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (776, 'Record updated On Transactions id 113', 113, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 18:57:36', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (777, 'Record updated On Visit Details id 113', 113, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 18:57:36', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (778, 'New Record inserted On Patient id 109', 109, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 18:58:34', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (779, 'Record updated On Patient id 109', 109, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 18:58:34', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (780, 'Record updated On Patient id 109', 109, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 18:58:57', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (781, 'New Record inserted On Transactions id 114', 114, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 18:58:57', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (782, 'Record updated On Transactions id 114', 114, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 18:59:09', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (783, 'Record updated On Visit Details id 114', 114, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 18:59:09', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (784, 'New Record inserted On Patient id 110', 110, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:00:24', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (785, 'Record updated On Patient id 110', 110, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:00:24', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (786, 'Record updated On Patient id 110', 110, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:01:03', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (787, 'New Record inserted On Transactions id 115', 115, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:01:03', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (788, 'Record updated On Transactions id 115', 115, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:01:21', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (789, 'Record updated On Visit Details id 115', 115, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:01:21', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (790, 'New Record inserted On Patient id 111', 111, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:02:35', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (791, 'Record updated On Patient id 111', 111, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:02:35', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (792, 'Record updated On Patient id 111', 111, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:03:13', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (793, 'New Record inserted On Transactions id 116', 116, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:03:13', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (794, 'Record updated On Transactions id 116', 116, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:03:24', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (795, 'Record updated On Visit Details id 116', 116, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:03:24', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (796, 'New Record inserted On Patient id 112', 112, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:04:11', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (797, 'Record updated On Patient id 112', 112, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:04:11', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (798, 'Record updated On Patient id 112', 112, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:04:35', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (799, 'New Record inserted On Transactions id 117', 117, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:04:35', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (800, 'Record updated On Transactions id 117', 117, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:04:44', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (801, 'Record updated On Visit Details id 117', 117, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:04:44', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (802, 'New Record inserted On Patient id 113', 113, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:05:19', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (803, 'Record updated On Patient id 113', 113, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:05:19', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (804, 'Record updated On Patient id 113', 113, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:05:51', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (805, 'New Record inserted On Transactions id 118', 118, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:05:51', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (806, 'Record updated On Transactions id 118', 118, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:06:03', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (807, 'Record updated On Visit Details id 118', 118, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:06:03', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (808, 'New Record inserted On Patient id 114', 114, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:06:41', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (809, 'Record updated On Patient id 114', 114, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:06:41', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (810, 'Record updated On Patient id 114', 114, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:07:03', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (811, 'New Record inserted On Transactions id 119', 119, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:07:03', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (812, 'New Record inserted On Patient id 115', 115, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:07:53', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (813, 'Record updated On Patient id 115', 115, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:07:53', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (814, 'Record updated On Patient id 115', 115, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:08:26', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (815, 'New Record inserted On Transactions id 120', 120, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:08:26', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (816, 'New Record inserted On Expenses id 11', 11, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-14 19:11:38', '2025-07-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (817, 'New Record inserted On Patient id 116', 116, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:12:48', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (818, 'Record updated On Patient id 116', 116, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:12:48', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (819, 'Record updated On Patient id 116', 116, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:13:15', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (820, 'New Record inserted On Transactions id 121', 121, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:13:15', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (821, 'Record updated On Transactions id 121', 121, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:13:25', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (822, 'Record updated On Visit Details id 121', 121, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:13:25', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (823, 'New Record inserted On Patient id 117', 117, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:14:41', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (824, 'Record updated On Patient id 117', 117, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:14:41', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (825, 'Record updated On Patient id 117', 117, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:15:24', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (826, 'New Record inserted On Transactions id 122', 122, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:15:24', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (827, 'New Record inserted On Patient id 118', 118, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:30:47', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (828, 'Record updated On Patient id 118', 118, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:30:47', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (829, 'Record updated On Patient id 118', 118, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:31:11', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (830, 'New Record inserted On Transactions id 123', 123, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:31:11', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (831, 'Record updated On Transactions id 123', 123, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:31:26', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (832, 'Record updated On Visit Details id 123', 123, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:31:26', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (833, 'New Record inserted On Patient id 119', 119, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:32:29', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (834, 'Record updated On Patient id 119', 119, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:32:29', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (835, 'Record updated On Patient id 119', 119, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:32:53', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (836, 'New Record inserted On Transactions id 124', 124, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:32:53', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (837, 'Record updated On Transactions id 124', 124, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:33:04', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (838, 'Record updated On Visit Details id 124', 124, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:33:04', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (839, 'New Record inserted On Patient id 120', 120, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:33:55', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (840, 'Record updated On Patient id 120', 120, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:33:55', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (841, 'Record updated On Patient id 120', 120, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:34:11', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (842, 'New Record inserted On Transactions id 125', 125, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:34:11', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (843, 'Record updated On Transactions id 125', 125, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:34:22', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (844, 'Record updated On Visit Details id 125', 125, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:34:22', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (845, 'New Record inserted On Patient id 121', 121, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:35:09', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (846, 'Record updated On Patient id 121', 121, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:35:09', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (847, 'Record updated On Patient id 121', 121, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:35:26', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (848, 'New Record inserted On Transactions id 126', 126, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:35:26', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (849, 'Record updated On Transactions id 126', 126, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:35:44', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (850, 'Record updated On Visit Details id 126', 126, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:35:44', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (851, 'New Record inserted On Patient id 122', 122, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:36:58', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (852, 'Record updated On Patient id 122', 122, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:36:58', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (853, 'Record updated On Patient id 122', 122, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:37:32', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (854, 'New Record inserted On Transactions id 127', 127, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:37:32', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (855, 'Record updated On Transactions id 127', 127, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:37:41', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (856, 'Record updated On Visit Details id 127', 127, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:37:41', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (857, 'New Record inserted On Patient id 123', 123, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:38:48', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (858, 'Record updated On Patient id 123', 123, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:38:48', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (859, 'Record updated On Patient id 123', 123, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:39:07', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (860, 'New Record inserted On Transactions id 128', 128, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:39:07', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (861, 'New Record inserted On Patient id 124', 124, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:39:51', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (862, 'Record updated On Patient id 124', 124, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:39:51', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (863, 'Record updated On Patient id 124', 124, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:40:15', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (864, 'New Record inserted On Transactions id 129', 129, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:40:15', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (865, 'New Record inserted On Patient id 125', 125, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:40:59', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (866, 'Record updated On Patient id 125', 125, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:40:59', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (867, 'Record updated On Patient id 125', 125, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:41:34', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (868, 'New Record inserted On Transactions id 130', 130, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:41:34', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (869, 'New Record inserted On Patient id 126', 126, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:42:44', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (870, 'Record updated On Patient id 126', 126, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:42:44', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (871, 'Record updated On Patient id 126', 126, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:43:02', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (872, 'New Record inserted On Transactions id 131', 131, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:43:02', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (873, 'Record updated On Transactions id 131', 131, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:43:14', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (874, 'Record updated On Visit Details id 131', 131, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:43:14', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (875, 'New Record inserted On Patient id 127', 127, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:44:07', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (876, 'Record updated On Patient id 127', 127, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:44:07', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (877, 'Record updated On Patient id 127', 127, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:45:06', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (878, 'New Record inserted On Transactions id 132', 132, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:45:06', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (879, 'Record updated On Transactions id 132', 132, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:45:18', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (880, 'Record updated On Visit Details id 132', 132, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:45:18', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (881, 'Record updated On Transactions id 132', 132, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:45:55', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (882, 'Record updated On Visit Details id 132', 132, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:45:55', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (883, 'New Record inserted On Patient id 128', 128, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:47:15', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (884, 'Record updated On Patient id 128', 128, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:47:15', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (885, 'Record updated On Patient id 128', 128, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:47:28', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (886, 'New Record inserted On Transactions id 133', 133, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:47:28', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (887, 'New Record inserted On Patient id 129', 129, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:49:07', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (888, 'Record updated On Patient id 129', 129, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:49:07', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (889, 'Record updated On Patient id 129', 129, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:49:31', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (890, 'New Record inserted On Transactions id 134', 134, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:49:31', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (891, 'New Record inserted On Expenses id 12', 12, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-16 19:56:58', '2025-07-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (892, 'Record updated Change Password For Staff id 4', 4, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-17 15:36:01', '2025-07-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (893, 'New Record inserted On Patient id 130', 130, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-17 15:39:00', '2025-07-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (894, 'Record updated On Patient id 130', 130, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-17 15:39:00', '2025-07-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (895, 'Record updated On Patient id 130', 130, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-17 15:40:17', '2025-07-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (896, 'New Record inserted On Transactions id 135', 135, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-17 15:40:17', '2025-07-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (897, 'New Record inserted On Appointment Created 25', 25, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-17 15:41:41', '2025-07-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (898, 'New Record inserted On Patient id 131', 131, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-17 15:46:14', '2025-07-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (899, 'Record updated On Patient id 131', 131, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-17 15:46:14', '2025-07-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (900, 'Record updated On Patient id 131', 131, 0, 'Update', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-17 15:46:36', '2025-07-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (901, 'New Record inserted On Transactions id 137', 137, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-17 15:46:36', '2025-07-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (902, 'New Record inserted On Appointment Created 26', 26, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-17 15:49:01', '2025-07-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (903, 'Record deleted On Appointment Deleted id 26', 26, 0, 'Delete', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-17 15:49:36', '2025-07-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (904, 'New Record inserted On Appointment Created 27', 27, 0, 'Insert', '41.139.171.233', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-17 15:50:10', '2025-07-17');


#
# TABLE STRUCTURE FOR: medication_report
#

DROP TABLE IF EXISTS `medication_report`;

CREATE TABLE `medication_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_dosage_id` int(11) DEFAULT NULL,
  `pharmacy_id` int(11) DEFAULT NULL,
  `opd_details_id` int(11) DEFAULT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `time` time NOT NULL,
  `remark` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `generated_by` (`generated_by`),
  KEY `pharmacy_id` (`pharmacy_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `medicine_dosage_id` (`medicine_dosage_id`),
  KEY `opd_details_id` (`opd_details_id`),
  KEY `index_date` (`date`),
  KEY `index_time` (`time`),
  CONSTRAINT `medication_report_ibfk_1` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medication_report_ibfk_2` FOREIGN KEY (`pharmacy_id`) REFERENCES `pharmacy` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medication_report_ibfk_3` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medication_report_ibfk_4` FOREIGN KEY (`medicine_dosage_id`) REFERENCES `medicine_dosage` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medication_report_ibfk_5` FOREIGN KEY (`opd_details_id`) REFERENCES `opd_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: medicine_bad_stock
#

DROP TABLE IF EXISTS `medicine_bad_stock`;

CREATE TABLE `medicine_bad_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_batch_details_id` int(11) DEFAULT NULL,
  `pharmacy_id` int(11) DEFAULT NULL,
  `outward_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `batch_no` varchar(100) NOT NULL,
  `quantity` varchar(20) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  KEY `medicine_batch_details_id` (`medicine_batch_details_id`),
  KEY `index_outward_date` (`outward_date`),
  KEY `index_expiry_date` (`expiry_date`),
  KEY `index_batch_no` (`batch_no`),
  KEY `index_quantity` (`quantity`),
  CONSTRAINT `medicine_bad_stock_ibfk_1` FOREIGN KEY (`pharmacy_id`) REFERENCES `pharmacy` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medicine_bad_stock_ibfk_2` FOREIGN KEY (`medicine_batch_details_id`) REFERENCES `medicine_batch_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: medicine_batch_details
#

DROP TABLE IF EXISTS `medicine_batch_details`;

CREATE TABLE `medicine_batch_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_bill_basic_id` int(11) DEFAULT NULL,
  `pharmacy_id` int(11) DEFAULT NULL,
  `inward_date` datetime NOT NULL,
  `expiry` date NOT NULL,
  `batch_no` varchar(100) NOT NULL,
  `packing_qty` varchar(100) NOT NULL,
  `purchase_rate_packing` varchar(100) NOT NULL,
  `quantity` varchar(200) NOT NULL,
  `mrp` float(10,2) DEFAULT 0.00,
  `purchase_price` float(10,2) DEFAULT 0.00,
  `tax` float(10,2) DEFAULT 0.00,
  `sale_rate` float(10,2) DEFAULT 0.00,
  `batch_amount` float(10,2) DEFAULT 0.00,
  `amount` float(10,2) DEFAULT 0.00,
  `available_quantity` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `supplier_bill_basic_id` (`supplier_bill_basic_id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  KEY `index_inward_date` (`inward_date`),
  KEY `index_expiry` (`expiry`),
  KEY `index_batch_no` (`batch_no`),
  KEY `index_packing_qty` (`packing_qty`),
  KEY `index_purchase_rate_packing` (`purchase_rate_packing`),
  KEY `index_quantity` (`quantity`),
  KEY `index_mrp` (`mrp`),
  KEY `index_purchase_price` (`purchase_price`),
  KEY `index_tax` (`tax`),
  KEY `index_sale_rate` (`sale_rate`),
  KEY `index_batch_amount` (`batch_amount`),
  KEY `index_amount` (`amount`),
  KEY `index_available_quantity` (`available_quantity`),
  CONSTRAINT `medicine_batch_details_ibfk_1` FOREIGN KEY (`supplier_bill_basic_id`) REFERENCES `supplier_bill_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medicine_batch_details_ibfk_2` FOREIGN KEY (`pharmacy_id`) REFERENCES `pharmacy` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: medicine_category
#

DROP TABLE IF EXISTS `medicine_category`;

CREATE TABLE `medicine_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_category` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_medicine_category` (`medicine_category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: medicine_dosage
#

DROP TABLE IF EXISTS `medicine_dosage`;

CREATE TABLE `medicine_dosage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_category_id` int(11) DEFAULT NULL,
  `dosage` varchar(100) NOT NULL,
  `units_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `medicine_category_id` (`medicine_category_id`),
  KEY `charge_units_id` (`units_id`),
  KEY `index_dosage` (`dosage`),
  CONSTRAINT `medicine_dosage_ibfk_1` FOREIGN KEY (`medicine_category_id`) REFERENCES `medicine_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medicine_dosage_ibfk_2` FOREIGN KEY (`units_id`) REFERENCES `unit` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: medicine_group
#

DROP TABLE IF EXISTS `medicine_group`;

CREATE TABLE `medicine_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_group_name` (`group_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: medicine_supplier
#

DROP TABLE IF EXISTS `medicine_supplier`;

CREATE TABLE `medicine_supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier` varchar(200) NOT NULL,
  `contact` varchar(200) NOT NULL,
  `supplier_person` varchar(200) NOT NULL,
  `supplier_person_contact` varchar(200) NOT NULL,
  `supplier_drug_licence` varchar(200) NOT NULL,
  `address` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_supplier` (`supplier`),
  KEY `index_contact` (`contact`),
  KEY `index_supplier_person` (`supplier_person`),
  KEY `index_supplier_person_contact` (`supplier_person_contact`),
  KEY `index_supplier_drug_licence` (`supplier_drug_licence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: messages
#

DROP TABLE IF EXISTS `messages`;

CREATE TABLE `messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL,
  `template_id` varchar(100) NOT NULL,
  `message` text DEFAULT NULL,
  `send_mail` varchar(10) DEFAULT '0',
  `send_sms` varchar(10) DEFAULT '0',
  `is_group` varchar(10) DEFAULT '0',
  `is_individual` varchar(10) DEFAULT '0',
  `file` varchar(200) NOT NULL,
  `group_list` text DEFAULT NULL,
  `user_list` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_title` (`title`),
  KEY `index_send_mail` (`send_mail`),
  KEY `index_send_sms` (`send_sms`),
  KEY `index_is_group` (`is_group`),
  KEY `index_is_individual` (`is_individual`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `messages` (`id`, `title`, `template_id`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (1, 'Reporting time at 8am', '', 'fgxfggfdgfdffgfgghh', '0', '1', '1', '0', '', '[]', NULL, '2025-07-02 13:14:03');


#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: notification_roles
#

DROP TABLE IF EXISTS `notification_roles`;

CREATE TABLE `notification_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `send_notification_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `send_notification_id` (`send_notification_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `notification_roles_ibfk_1` FOREIGN KEY (`send_notification_id`) REFERENCES `send_notification` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notification_roles_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: notification_setting
#

DROP TABLE IF EXISTS `notification_setting`;

CREATE TABLE `notification_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `is_mail` int(11) DEFAULT 0,
  `is_sms` int(11) DEFAULT 0,
  `is_mobileapp` int(11) NOT NULL,
  `is_notification` int(11) NOT NULL,
  `display_notification` int(11) NOT NULL,
  `display_sms` int(11) NOT NULL,
  `template` longtext DEFAULT NULL,
  `template_id` varchar(100) NOT NULL,
  `subject` text DEFAULT NULL,
  `variables` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_type` (`type`),
  KEY `index_is_mail` (`is_mail`),
  KEY `index_is_sms` (`is_sms`),
  KEY `index_is_mobileapp` (`is_mobileapp`),
  KEY `index_is_notification` (`is_notification`),
  KEY `index_display_notification` (`display_notification`),
  KEY `index_display_sms` (`display_sms`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (1, 'opd_patient_registration', 1, 0, 1, 1, 1, 1, 'Dear {{patient_name}} your OPD Registration at Smart Hospital is successful on date {{appointment_date}} with Patient Id {{patient_id}} and OPD No {{opdno}}', '', 'OPD Patient', '{{patient_name}} {{appointment_date}} {{patient_id}} {{opdno}}', '2021-10-22 07:57:53');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (2, 'ipd_patient_registration', 1, 0, 0, 0, 1, 1, 'Dear {{patient_name}} your IPD Registration at Smart Hospital is successful  with Patient Id {{patient_id}} and IPD No {{ipd_no}}', '', 'IPD Patient Registration', '{{patient_name}} {{patient_id}} {{ipd_no}}', '2021-10-22 07:59:33');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (3, 'ipd_patient_discharged', 1, 0, 0, 0, 1, 1, 'IPD Patient {{patient_name}} is now discharged from Smart Hospital\nTotal bill amount is {{currency_symbol}}{{total_amount}}\nTotal paid amount is {{currency_symbol}}{{paid_amount}}\nTotal balance bill amount is {{currency_symbol}}{{balance_amount}}', '', 'IPD Patient Discharge', '{{patient_name}} {{currency_symbol}} {{total_amount}} {{paid_amount}} {balance_amount}}', '2021-10-25 04:32:35');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (5, 'login_credential', 1, 0, 0, 0, 0, 1, 'Hello {{display_name}} your Smart Hospital login details are Url: {{url}} Username: {{username}} Password: {{password}}', '', 'Smart Hospital Login Credential', '{{display_name}} {{url}} {{username}} {{password}}', '2021-10-22 08:18:21');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (6, 'appointment_approved', 1, 0, 0, 0, 1, 1, 'Dear {{patient_name}} your appointment with {{staff_name}} {{staff_surname}} is confirmed on {{date}} with appointment no: {{appointment_no}}', '', 'Appointment Approved', '{{patient_name}} {{staff_name}}\n{{staff_surname}}  {{date}} {{appointment_no}}', '2021-10-23 01:56:24');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (7, 'live_meeting', 1, 0, 0, 0, 0, 1, 'Dear staff, your live meeting {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute.', '', 'Live Meeting', '{{title}} {{date}} {{duration}}', '2021-10-23 01:54:58');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (8, 'live_consult', 1, 0, 0, 0, 1, 1, 'Dear patient, your live consultation {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute.', '', 'Live Consultation', '{{title}} {{date}} {{duration}}', '2021-10-22 08:28:26');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (9, 'opd_patient_discharged', 1, 0, 0, 0, 1, 1, 'OPD No {{opd_no}}  {{patient_name}} is now discharged from Smart Hospital.\r\n\r\nTotal bill amount was {{currency_symbol}}  {{total_amount}} \r\nTotal paid amount was {{currency_symbol}}{{paid_amount}}  \r\nTotal balance amount is {{currency_symbol}}{{balance_amount}}', '', 'OPD Patient Discharged', '{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}}{{currency_symbol}} {{billing_amount}}', '2021-10-22 08:25:06');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (10, 'forgot_password', 1, 0, 0, 0, 0, 0, 'Dear  {{display_name}}, recently a request was submitted to reset password for your account with email: {{email}}. If you didn\'t make the request, just ignore this email, otherwise you can reset your password using this link <a href=\'{{resetpasslink}}\'>click here to reset your password</a>, if you\'re having trouble clicking the password reset link, copy and paste below URL  into your web browser. {{resetpasslink}} <br> Regards,  <br>\r\nSmart Hospital', '', 'Reset Password Request', '{{display_name}}  {{email}}  {{resetpasslink}', '2021-10-22 08:34:34');


#
# TABLE STRUCTURE FOR: nurse_note
#

DROP TABLE IF EXISTS `nurse_note`;

CREATE TABLE `nurse_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `staff_id` (`staff_id`),
  KEY `index_date` (`date`),
  CONSTRAINT `nurse_note_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `nurse_note_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: nurse_notes_comment
#

DROP TABLE IF EXISTS `nurse_notes_comment`;

CREATE TABLE `nurse_notes_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nurse_note_id` int(11) DEFAULT NULL,
  `comment_staffid` int(11) DEFAULT NULL,
  `comment_staff` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `nurse_note_id` (`nurse_note_id`),
  KEY `comment_staffid` (`comment_staffid`),
  CONSTRAINT `nurse_notes_comment_ibfk_1` FOREIGN KEY (`nurse_note_id`) REFERENCES `nurse_note` (`id`) ON DELETE CASCADE,
  CONSTRAINT `nurse_notes_comment_ibfk_2` FOREIGN KEY (`comment_staffid`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: obstetric_history
#

DROP TABLE IF EXISTS `obstetric_history`;

CREATE TABLE `obstetric_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `place_of_delivery` varchar(250) NOT NULL,
  `pregnancy_duration` varchar(250) NOT NULL,
  `pregnancy_complications` varchar(250) NOT NULL,
  `birth_weight` varchar(250) NOT NULL,
  `gender` varchar(100) NOT NULL,
  `infant_feeding` varchar(250) NOT NULL,
  `alive_dead` varchar(50) NOT NULL,
  `date` date DEFAULT NULL,
  `death_cause` varchar(250) NOT NULL,
  `previous_medical_history` text NOT NULL,
  `special_instruction` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_place_of_delivery` (`place_of_delivery`),
  KEY `index_pregnancy_duration` (`pregnancy_duration`),
  KEY `index_pregnancy_complications` (`pregnancy_complications`),
  KEY `index_birth_weight` (`birth_weight`),
  KEY `index_gender` (`gender`),
  KEY `index_infant_feeding` (`infant_feeding`),
  KEY `index_alive_dead` (`alive_dead`),
  KEY `index_date` (`date`),
  KEY `index_death_cause` (`death_cause`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: opd_details
#

DROP TABLE IF EXISTS `opd_details`;

CREATE TABLE `opd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case_reference_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `is_ipd_moved` int(11) NOT NULL DEFAULT 0,
  `discharged` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `generated_by` (`generated_by`),
  CONSTRAINT `opd_details_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `opd_details_ibfk_2` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `opd_details_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=140 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (19, 19, 8, 1, 0, 'no', '2025-07-01 15:42:31');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (20, 20, 10, 1, 0, 'no', '2025-07-01 15:52:15');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (21, 21, 11, 1, 0, 'no', '2025-07-01 15:55:06');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (22, 22, 12, 1, 0, 'no', '2025-07-01 15:58:50');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (23, 23, 13, 1, 0, 'no', '2025-07-01 16:05:15');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (24, 24, 14, 1, 0, 'no', '2025-07-01 16:07:21');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (25, 25, 15, 1, 0, 'no', '2025-07-01 16:09:11');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (26, 26, 16, 1, 0, 'no', '2025-07-01 16:33:32');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (27, 27, 17, 1, 0, 'no', '2025-07-02 10:46:29');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (28, 28, 18, 1, 0, 'no', '2025-07-02 12:43:58');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (29, 29, 19, 1, 0, 'no', '2025-07-02 12:50:24');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (30, 30, 20, 1, 0, 'no', '2025-07-02 15:26:48');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (31, 31, 21, 1, 0, 'no', '2025-07-02 18:14:38');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (32, 32, 22, 1, 0, 'no', '2025-07-02 18:20:09');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (35, 35, 25, 1, 0, 'no', '2025-07-03 13:34:47');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (36, 36, 26, 1, 0, 'no', '2025-07-03 13:39:58');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (37, 37, 27, 1, 0, 'no', '2025-07-03 13:41:48');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (38, 38, 28, 1, 0, 'no', '2025-07-03 15:43:36');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (39, 39, 29, 1, 0, 'no', '2025-07-03 15:48:32');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (40, 40, 30, 1, 0, 'no', '2025-07-03 17:51:34');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (41, 41, 31, 1, 0, 'no', '2025-07-03 17:55:04');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (42, 42, 32, 1, 0, 'no', '2025-07-03 18:21:48');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (43, 43, 33, 1, 0, 'no', '2025-07-04 11:19:50');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (44, 44, 34, 1, 0, 'no', '2025-07-04 13:25:14');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (45, 45, 35, 1, 0, 'no', '2025-07-04 13:28:44');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (46, 46, 36, 1, 0, 'no', '2025-07-04 13:30:24');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (47, 47, 37, 1, 0, 'no', '2025-07-04 13:31:51');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (48, 48, 38, 1, 0, 'no', '2025-07-04 17:55:56');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (49, 49, 39, 1, 0, 'no', '2025-07-04 17:57:26');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (50, 50, 40, 1, 0, 'no', '2025-07-04 18:00:41');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (51, 51, 41, 1, 0, 'no', '2025-07-05 17:32:59');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (52, 52, 42, 1, 0, 'no', '2025-07-05 17:34:48');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (53, 53, 44, 1, 0, 'no', '2025-07-05 17:42:23');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (54, 54, 45, 1, 0, 'no', '2025-07-05 17:43:57');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (55, 55, 46, 1, 0, 'no', '2025-07-05 17:45:30');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (56, 56, 47, 1, 0, 'no', '2025-07-05 17:46:53');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (57, 57, 48, 1, 0, 'no', '2025-07-05 17:48:20');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (58, 58, 49, 1, 0, 'no', '2025-07-05 17:49:31');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (59, 59, 50, 1, 0, 'no', '2025-07-05 17:51:10');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (60, 60, 51, 1, 0, 'no', '2025-07-05 17:53:14');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (61, 61, 52, 1, 0, 'no', '2025-07-05 17:54:52');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (62, 62, 53, 1, 0, 'no', '2025-07-06 16:51:31');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (63, 63, 54, 1, 0, 'no', '2025-07-06 16:53:10');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (64, 64, 55, 1, 0, 'no', '2025-07-06 16:55:27');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (65, 65, 56, 1, 0, 'no', '2025-07-06 16:56:43');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (66, 66, 57, 1, 0, 'no', '2025-07-06 16:58:11');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (67, 67, 58, 1, 0, 'no', '2025-07-06 16:59:48');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (68, 68, 59, 1, 0, 'no', '2025-07-06 17:01:08');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (69, 69, 60, 1, 0, 'no', '2025-07-06 17:02:30');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (70, 70, 61, 1, 0, 'no', '2025-07-07 17:41:55');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (71, 71, 62, 1, 0, 'no', '2025-07-07 17:43:25');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (72, 72, 63, 1, 0, 'no', '2025-07-07 17:44:39');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (73, 73, 64, 1, 0, 'no', '2025-07-07 17:45:37');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (74, 74, 65, 1, 0, 'no', '2025-07-07 17:47:33');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (75, 75, 66, 1, 0, 'no', '2025-07-07 17:49:26');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (76, 76, 67, 1, 0, 'no', '2025-07-07 17:50:58');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (77, 77, 68, 1, 0, 'no', '2025-07-07 17:52:33');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (78, 78, 69, 1, 0, 'no', '2025-07-07 17:53:48');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (79, 79, 70, 1, 0, 'no', '2025-07-07 17:55:27');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (80, 80, 71, 1, 0, 'no', '2025-07-07 17:56:18');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (81, 81, 72, 1, 0, 'no', '2025-07-08 18:14:39');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (82, 82, 73, 1, 0, 'no', '2025-07-08 18:15:42');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (83, 83, 74, 1, 0, 'no', '2025-07-08 18:20:17');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (84, 84, 75, 1, 0, 'no', '2025-07-08 18:22:58');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (85, 85, 76, 1, 0, 'no', '2025-07-09 16:55:41');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (86, 86, 77, 1, 0, 'no', '2025-07-09 16:56:57');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (87, 87, 78, 1, 0, 'no', '2025-07-09 16:58:33');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (88, 88, 79, 1, 0, 'no', '2025-07-09 17:00:28');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (89, 89, 80, 1, 0, 'no', '2025-07-09 17:03:11');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (90, 90, 81, 1, 0, 'no', '2025-07-09 17:07:51');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (91, 91, 82, 1, 0, 'no', '2025-07-09 17:12:13');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (92, 92, 83, 1, 0, 'no', '2025-07-09 17:14:36');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (93, 93, 84, 1, 0, 'no', '2025-07-09 17:22:21');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (94, 94, 85, 1, 0, 'no', '2025-07-09 19:27:44');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (95, 95, 86, 1, 0, 'no', '2025-07-10 19:44:19');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (96, 96, 87, 1, 0, 'no', '2025-07-10 19:46:22');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (97, 97, 88, 1, 0, 'no', '2025-07-10 21:00:46');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (98, 98, 89, 1, 0, 'no', '2025-07-10 21:02:21');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (99, 99, 91, 1, 0, 'no', '2025-07-12 08:28:24');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (100, 100, 92, 1, 0, 'no', '2025-07-12 08:32:06');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (101, 101, 93, 1, 0, 'no', '2025-07-12 08:36:52');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (102, 102, 94, 1, 0, 'no', '2025-07-12 08:38:34');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (103, 103, 95, 1, 0, 'no', '2025-07-12 17:48:39');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (104, 104, 96, 1, 0, 'no', '2025-07-12 17:50:17');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (105, 105, 97, 1, 0, 'no', '2025-07-12 17:51:17');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (106, 106, 98, 1, 0, 'no', '2025-07-12 17:53:01');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (107, 107, 100, 1, 0, 'no', '2025-07-12 17:55:39');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (108, 108, 101, 1, 0, 'no', '2025-07-13 17:02:42');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (109, 109, 103, 1, 0, 'no', '2025-07-13 17:09:17');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (110, 110, 105, 1, 0, 'no', '2025-07-13 17:13:59');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (111, 111, 106, 1, 0, 'no', '2025-07-13 17:15:17');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (112, 112, 107, 1, 0, 'no', '2025-07-13 17:17:16');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (113, 113, 108, 1, 0, 'no', '2025-07-14 17:56:54');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (114, 114, 109, 1, 0, 'no', '2025-07-14 17:58:57');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (115, 115, 110, 1, 0, 'no', '2025-07-14 18:01:03');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (116, 116, 111, 1, 0, 'no', '2025-07-14 18:03:13');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (117, 117, 112, 1, 0, 'no', '2025-07-14 18:04:35');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (118, 118, 113, 1, 0, 'no', '2025-07-14 18:05:51');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (119, 119, 114, 1, 0, 'no', '2025-07-14 18:07:03');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (120, 120, 115, 1, 0, 'no', '2025-07-14 18:08:26');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (121, 121, 116, 1, 0, 'no', '2025-07-16 18:13:15');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (122, 122, 117, 1, 0, 'no', '2025-07-16 18:15:24');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (123, 123, 118, 1, 0, 'no', '2025-07-16 18:31:11');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (124, 124, 119, 1, 0, 'no', '2025-07-16 18:32:53');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (125, 125, 120, 1, 0, 'no', '2025-07-16 18:34:11');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (126, 126, 121, 1, 0, 'no', '2025-07-16 18:35:26');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (127, 127, 122, 1, 0, 'no', '2025-07-16 18:37:32');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (128, 128, 123, 1, 0, 'no', '2025-07-16 18:39:07');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (129, 129, 124, 1, 0, 'no', '2025-07-16 18:40:15');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (130, 130, 125, 1, 0, 'no', '2025-07-16 18:41:34');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (131, 131, 126, 1, 0, 'no', '2025-07-16 18:43:02');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (132, 132, 127, 1, 0, 'no', '2025-07-16 18:45:06');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (133, 133, 128, 1, 0, 'no', '2025-07-16 18:47:28');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (134, 134, 129, 1, 0, 'no', '2025-07-16 18:49:31');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (135, 135, 130, 1, 0, 'no', '2025-07-17 14:40:17');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (136, 136, 130, 1, 0, 'no', '2025-07-17 14:41:41');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (137, 137, 131, 1, 0, 'no', '2025-07-17 14:46:36');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (139, 139, 131, 1, 0, 'no', '2025-07-17 14:50:10');


#
# TABLE STRUCTURE FOR: operation
#

DROP TABLE IF EXISTS `operation`;

CREATE TABLE `operation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `operation` varchar(250) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `index_operation` (`operation`),
  CONSTRAINT `operation_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `operation_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: operation_category
#

DROP TABLE IF EXISTS `operation_category`;

CREATE TABLE `operation_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(250) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `index_category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: operation_theatre
#

DROP TABLE IF EXISTS `operation_theatre`;

CREATE TABLE `operation_theatre` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `opd_details_id` int(11) DEFAULT NULL,
  `ipd_details_id` int(11) DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `operation_id` int(11) NOT NULL,
  `date` datetime DEFAULT NULL,
  `operation_type` varchar(100) DEFAULT NULL,
  `consultant_doctor` int(11) DEFAULT NULL,
  `ass_consultant_1` varchar(50) DEFAULT NULL,
  `ass_consultant_2` varchar(50) DEFAULT NULL,
  `anesthetist` varchar(50) DEFAULT NULL,
  `anaethesia_type` varchar(50) DEFAULT NULL,
  `ot_technician` varchar(100) DEFAULT NULL,
  `ot_assistant` varchar(100) DEFAULT NULL,
  `result` text DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `opd_details_id` (`opd_details_id`),
  KEY `ipd_details_id` (`ipd_details_id`),
  KEY `consultant_doctor` (`consultant_doctor`),
  KEY `generated_by` (`generated_by`),
  KEY `operation_id` (`operation_id`),
  KEY `index_date` (`date`),
  CONSTRAINT `operation_theatre_ibfk_1` FOREIGN KEY (`opd_details_id`) REFERENCES `opd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `operation_theatre_ibfk_2` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `operation_theatre_ibfk_3` FOREIGN KEY (`consultant_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `operation_theatre_ibfk_4` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `operation_theatre_ibfk_5` FOREIGN KEY (`operation_id`) REFERENCES `operation` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: organisation
#

DROP TABLE IF EXISTS `organisation`;

CREATE TABLE `organisation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `organisation_name` varchar(200) NOT NULL,
  `code` varchar(50) NOT NULL,
  `contact_no` varchar(20) NOT NULL,
  `address` varchar(300) NOT NULL,
  `contact_person_name` varchar(200) NOT NULL,
  `contact_person_phone` varchar(20) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_organisation_name` (`organisation_name`),
  KEY `index_code` (`code`),
  KEY `index_contact_no` (`contact_no`),
  KEY `index_address` (`address`),
  KEY `index_contact_person_name` (`contact_person_name`),
  KEY `index_contact_person_phone` (`contact_person_phone`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`, `created_at`) VALUES (1, 'SHA', '147', '0800720601', 'P.O. Box:30016–00100, Nairobi. Afya House, Cathedral Road', '', '', '2025-06-23 11:01:59');


#
# TABLE STRUCTURE FOR: organisations_charges
#

DROP TABLE IF EXISTS `organisations_charges`;

CREATE TABLE `organisations_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `org_charge` float(10,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`),
  KEY `charge_id` (`charge_id`),
  CONSTRAINT `organisations_charges_ibfk_1` FOREIGN KEY (`org_id`) REFERENCES `organisation` (`id`) ON DELETE CASCADE,
  CONSTRAINT `organisations_charges_ibfk_2` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (1, 1, 1, '0.00', '2025-06-23 11:31:06');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (2, 1, 2, '0.00', '2025-06-23 11:31:55');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (3, 1, 3, '0.00', '2025-06-23 11:35:52');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (4, 1, 4, '0.00', '2025-06-23 11:36:39');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (5, 1, 5, '0.00', '2025-06-23 11:37:23');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (6, 1, 6, '0.00', '2025-06-23 11:39:52');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (7, 1, 7, '0.00', '2025-06-23 11:42:15');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (8, 1, 8, '0.00', '2025-06-23 12:50:16');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (9, 1, 9, '0.00', '2025-06-23 12:51:33');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (10, 1, 10, '0.00', '2025-06-23 12:52:56');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (11, 1, 11, '0.00', '2025-06-23 12:54:11');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (12, 1, 12, '0.00', '2025-06-23 12:54:53');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (13, 1, 13, '0.00', '2025-06-23 12:56:02');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (14, 1, 14, '0.00', '2025-06-23 12:57:26');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (15, 1, 15, '0.00', '2025-06-23 12:58:05');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (16, 1, 16, '0.00', '2025-06-23 12:59:12');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (17, 1, 17, '0.00', '2025-06-23 13:00:10');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (18, 1, 18, '0.00', '2025-06-23 13:02:13');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (19, 1, 19, '0.00', '2025-06-23 13:03:07');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (20, 1, 20, '0.00', '2025-06-23 13:03:28');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (21, 1, 21, '0.00', '2025-06-23 13:04:12');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (22, 1, 22, '0.00', '2025-06-23 13:04:59');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (25, 1, 24, '0.00', '2025-06-24 14:34:35');


#
# TABLE STRUCTURE FOR: pathology
#

DROP TABLE IF EXISTS `pathology`;

CREATE TABLE `pathology` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_name` varchar(100) DEFAULT NULL,
  `short_name` varchar(100) DEFAULT NULL,
  `test_type` varchar(100) DEFAULT NULL,
  `pathology_category_id` int(11) DEFAULT NULL,
  `unit` varchar(50) NOT NULL,
  `sub_category` varchar(50) NOT NULL,
  `report_days` varchar(50) NOT NULL,
  `method` varchar(50) NOT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `pathology_category_id` (`pathology_category_id`),
  KEY `charge_id` (`charge_id`),
  KEY `index_test_name` (`test_name`),
  KEY `index_short_name` (`short_name`),
  KEY `index_test_type` (`test_type`),
  KEY `index_unit` (`unit`),
  KEY `index_sub_category` (`sub_category`),
  KEY `index_report_days` (`report_days`),
  KEY `index_method` (`method`),
  CONSTRAINT `pathology_ibfk_1` FOREIGN KEY (`pathology_category_id`) REFERENCES `pathology_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_ibfk_2` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: pathology_billing
#

DROP TABLE IF EXISTS `pathology_billing`;

CREATE TABLE `pathology_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case_reference_id` int(11) DEFAULT NULL,
  `ipd_prescription_basic_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `doctor_name` varchar(100) NOT NULL,
  `total` float(10,2) DEFAULT 0.00,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `discount` float(10,2) DEFAULT 0.00,
  `tax_percentage` float(10,2) DEFAULT 0.00,
  `tax` float(10,2) DEFAULT 0.00,
  `net_amount` float(10,2) DEFAULT 0.00,
  `transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor_id` (`doctor_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `generated_by` (`generated_by`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `index_date` (`date`),
  KEY `index_doctor_name` (`doctor_name`),
  KEY `index_total` (`total`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_discount` (`discount`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_tax` (`tax`),
  KEY `index_net_amount` (`net_amount`),
  KEY `organisation_id` (`organisation_id`),
  CONSTRAINT `pathology_billing_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_billing_ibfk_2` FOREIGN KEY (`doctor_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_billing_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_billing_ibfk_4` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_billing_ibfk_5` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE SET NULL,
  CONSTRAINT `pathology_billing_ibfk_6` FOREIGN KEY (`ipd_prescription_basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_billing_ibfk_7` FOREIGN KEY (`organisation_id`) REFERENCES `organisation` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: pathology_category
#

DROP TABLE IF EXISTS `pathology_category`;

CREATE TABLE `pathology_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_category_name` (`category_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: pathology_parameter
#

DROP TABLE IF EXISTS `pathology_parameter`;

CREATE TABLE `pathology_parameter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parameter_name` varchar(100) NOT NULL,
  `test_value` varchar(100) NOT NULL,
  `reference_range` varchar(100) NOT NULL,
  `range_from` varchar(500) DEFAULT NULL,
  `range_to` varchar(500) DEFAULT NULL,
  `gender` varchar(100) NOT NULL,
  `unit` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `unit` (`unit`),
  KEY `index_parameter_name` (`parameter_name`),
  KEY `index_test_value` (`test_value`),
  KEY `index_reference_range` (`reference_range`),
  KEY `index_range_from` (`range_from`),
  KEY `index_range_to` (`range_to`),
  KEY `index_gender` (`gender`),
  KEY `index_unit` (`unit`),
  CONSTRAINT `pathology_parameter_ibfk_1` FOREIGN KEY (`unit`) REFERENCES `unit` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: pathology_parameterdetails
#

DROP TABLE IF EXISTS `pathology_parameterdetails`;

CREATE TABLE `pathology_parameterdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pathology_id` int(11) DEFAULT NULL,
  `pathology_parameter_id` int(11) DEFAULT NULL,
  `created_id` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `pathology_id` (`pathology_id`),
  KEY `pathology_parameter_id` (`pathology_parameter_id`),
  CONSTRAINT `pathology_parameterdetails_ibfk_1` FOREIGN KEY (`pathology_id`) REFERENCES `pathology` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_parameterdetails_ibfk_2` FOREIGN KEY (`pathology_parameter_id`) REFERENCES `pathology_parameter` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: pathology_report
#

DROP TABLE IF EXISTS `pathology_report`;

CREATE TABLE `pathology_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pathology_bill_id` int(11) DEFAULT NULL,
  `pathology_id` int(11) DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `reporting_date` date DEFAULT NULL,
  `parameter_update` date DEFAULT NULL,
  `tax_percentage` float(10,2) NOT NULL DEFAULT 0.00,
  `apply_charge` float(10,2) NOT NULL,
  `collection_date` date DEFAULT NULL,
  `collection_specialist` int(11) DEFAULT NULL,
  `pathology_center` varchar(250) DEFAULT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `pathology_report` varchar(255) DEFAULT NULL,
  `report_name` text DEFAULT NULL,
  `pathology_result` text DEFAULT NULL COMMENT 'test result',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `pathology_bill_id` (`pathology_bill_id`),
  KEY `pathology_id` (`pathology_id`),
  KEY `collection_specialist` (`collection_specialist`),
  KEY `approved_by` (`approved_by`),
  KEY `index_reporting_date` (`reporting_date`),
  KEY `index_parameter_update` (`parameter_update`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_apply_charge` (`apply_charge`),
  KEY `index_collection_date` (`collection_date`),
  CONSTRAINT `pathology_report_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_report_ibfk_2` FOREIGN KEY (`pathology_bill_id`) REFERENCES `pathology_billing` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_report_ibfk_3` FOREIGN KEY (`pathology_id`) REFERENCES `pathology` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_report_ibfk_4` FOREIGN KEY (`collection_specialist`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_report_ibfk_5` FOREIGN KEY (`approved_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: pathology_report_parameterdetails
#

DROP TABLE IF EXISTS `pathology_report_parameterdetails`;

CREATE TABLE `pathology_report_parameterdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pathology_report_id` int(11) DEFAULT NULL,
  `pathology_parameterdetail_id` int(11) DEFAULT NULL,
  `pathology_report_value` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `pathology_report_id` (`pathology_report_id`),
  KEY `pathology_parameterdetail_id` (`pathology_parameterdetail_id`),
  CONSTRAINT `pathology_report_parameterdetails_ibfk_1` FOREIGN KEY (`pathology_report_id`) REFERENCES `pathology_report` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_report_parameterdetails_ibfk_2` FOREIGN KEY (`pathology_parameterdetail_id`) REFERENCES `pathology_parameterdetails` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: patient_bed_history
#

DROP TABLE IF EXISTS `patient_bed_history`;

CREATE TABLE `patient_bed_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case_reference_id` int(11) DEFAULT NULL,
  `bed_group_id` int(11) DEFAULT NULL,
  `bed_id` int(11) DEFAULT NULL,
  `revert_reason` text DEFAULT NULL,
  `from_date` datetime DEFAULT NULL,
  `to_date` datetime DEFAULT NULL,
  `is_active` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `bed_group_id` (`bed_group_id`),
  KEY `bed_id` (`bed_id`),
  KEY `index_from_date` (`from_date`),
  KEY `index_to_date` (`to_date`),
  CONSTRAINT `patient_bed_history_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_bed_history_ibfk_2` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_bed_history_ibfk_3` FOREIGN KEY (`bed_id`) REFERENCES `bed` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: patient_charges
#

DROP TABLE IF EXISTS `patient_charges`;

CREATE TABLE `patient_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `opd_id` int(11) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) DEFAULT 0.00,
  `tpa_charge` float(10,2) DEFAULT 0.00,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `tax` float(10,2) DEFAULT 0.00,
  `apply_charge` float(10,2) DEFAULT 0.00,
  `amount` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `opd_id` (`opd_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `charge_id` (`charge_id`),
  KEY `organisation_id` (`organisation_id`),
  KEY `index_qty` (`qty`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_tpa_charge` (`tpa_charge`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_tax` (`tax`),
  KEY `index_apply_charge` (`apply_charge`),
  KEY `index_amount` (`amount`),
  CONSTRAINT `patient_charges_ibfk_1` FOREIGN KEY (`opd_id`) REFERENCES `opd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_charges_ibfk_2` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_charges_ibfk_3` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_charges_ibfk_4` FOREIGN KEY (`organisation_id`) REFERENCES `organisation` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=140 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (19, '2025-07-06 16:39:00', NULL, 19, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-01 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (20, '2025-07-01 16:52:00', NULL, 20, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-01 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (21, '2025-07-01 16:55:00', NULL, 21, 1, 15, '1000.00', '0.00', '0.00', '0.00', '1000.00', '1000.00', '', NULL, NULL, '', '2025-07-01 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (22, '2025-07-01 16:57:00', NULL, 22, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-01 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (23, '2025-07-01 17:05:00', NULL, 23, 1, 3, '15000.00', '0.00', '0.00', '0.00', '8000.00', '15000.00', '', NULL, NULL, '', '2025-07-01 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (24, '2025-07-01 17:07:00', NULL, 24, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-01 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (25, '2025-07-15 17:09:00', NULL, 25, 1, 21, '500.00', '0.00', '0.00', '0.00', '1000.00', '500.00', '', NULL, NULL, '', '2025-07-01 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (26, '2025-07-08 17:33:00', NULL, 26, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-01 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (27, '2025-07-03 11:44:00', NULL, 27, 1, 5, '1000.00', '0.00', '0.00', '0.00', '1000.00', '1000.00', '', NULL, NULL, '', '2025-07-02 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (28, '2025-07-16 13:43:00', NULL, 28, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-02 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (29, '2025-07-02 13:45:00', NULL, 29, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-02 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (30, '2025-07-09 16:26:00', NULL, 30, 1, 11, '1500.00', '0.00', '0.00', '0.00', '1500.00', '1500.00', '', NULL, NULL, '', '2025-07-02 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (31, '2025-07-16 19:13:00', NULL, 31, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-02 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (32, '2025-07-02 19:20:00', NULL, 32, 1, 8, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-02 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (35, '2025-07-08 14:35:00', NULL, 35, 1, 6, '2500.00', '0.00', '0.00', '0.00', '2500.00', '2500.00', '', NULL, NULL, '', '2025-07-03 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (36, '2025-07-17 14:40:00', NULL, 36, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-03 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (37, '2025-07-17 14:42:00', NULL, 37, 1, 3, '15000.00', '0.00', '0.00', '0.00', '15000.00', '15000.00', '', NULL, NULL, '', '2025-07-03 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (38, '2025-07-03 16:42:00', NULL, 38, 1, 4, '5000.00', '0.00', '3.00', '0.00', '4700.00', '5000.00', '', NULL, NULL, '', '2025-07-03 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (39, '2025-07-03 16:49:00', NULL, 39, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-03 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (40, '2025-07-17 18:51:00', NULL, 40, 1, 3, '15000.00', '0.00', '0.00', '0.00', '15000.00', '15000.00', '', NULL, NULL, '', '2025-07-03 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (41, '2025-07-03 18:55:00', NULL, 41, 1, 5, '1000.00', '0.00', '0.00', '0.00', '1000.00', '1000.00', '', NULL, NULL, '', '2025-07-03 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (42, '2025-07-02 19:22:00', NULL, 42, 1, 5, '1000.00', '0.00', '0.00', '0.00', '1000.00', '1000.00', '', NULL, NULL, '', '2025-07-03 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (43, '2025-07-04 12:20:00', NULL, 43, 1, 12, '1000.00', '0.00', '0.00', '0.00', '1000.00', '1000.00', '', NULL, NULL, '', '2025-07-04 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (44, '2025-07-04 14:25:00', NULL, 44, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-04 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (45, '2025-07-04 14:29:00', NULL, 45, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-04 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (46, '2025-07-04 14:31:00', NULL, 46, 1, 8, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-04 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (47, '2025-07-11 14:32:00', NULL, 47, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-04 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (48, '2025-07-25 18:56:00', NULL, 48, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-04 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (49, '2025-07-04 18:58:00', NULL, 49, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-04 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (50, '2025-07-25 19:01:00', NULL, 50, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-04 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (51, '2025-07-05 18:33:00', NULL, 51, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-05 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (52, '2025-07-19 18:35:00', NULL, 52, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-05 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (53, '2025-07-13 18:43:00', NULL, 53, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-05 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (54, '2025-07-06 18:44:00', NULL, 54, 1, 8, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-05 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (55, '2025-07-05 18:46:00', NULL, 55, 1, 22, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-05 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (56, '2025-07-05 18:47:00', NULL, 56, 1, 8, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-05 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (57, '2025-07-12 18:49:00', NULL, 57, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-05 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (58, '2025-07-19 18:50:00', NULL, 58, 1, 3, '15000.00', '0.00', '0.00', '0.00', '15000.00', '15000.00', '', NULL, NULL, '', '2025-07-05 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (59, '2025-07-19 18:51:00', NULL, 59, 1, 3, '15000.00', '0.00', '0.00', '0.00', '15000.00', '15000.00', '', NULL, NULL, '', '2025-07-05 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (60, '2025-07-05 18:53:00', NULL, 60, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-05 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (61, '2025-07-19 18:55:00', NULL, 61, 1, 3, '15000.00', '0.00', '0.00', '0.00', '15000.00', '15000.00', '', NULL, NULL, '', '2025-07-05 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (62, '2025-07-06 17:52:00', NULL, 62, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-06 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (63, '2025-07-27 17:53:00', NULL, 63, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-06 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (64, '2025-07-27 17:56:00', NULL, 64, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-06 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (65, '2025-07-06 17:57:00', NULL, 65, 1, 2, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-06 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (66, '2025-07-20 17:59:00', NULL, 66, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-06 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (67, '2025-07-27 18:00:00', NULL, 67, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-06 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (68, '2025-07-06 18:01:00', NULL, 68, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-06 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (69, '2025-07-06 18:03:00', NULL, 69, 1, 8, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-06 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (70, '2025-07-14 18:42:00', NULL, 70, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-07 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (71, '2025-07-07 18:44:00', NULL, 71, 1, 17, '3000.00', '0.00', '0.00', '0.00', '3000.00', '3000.00', '', NULL, NULL, '', '2025-07-07 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (72, '2025-07-07 18:45:00', NULL, 72, 1, 2, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-07 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (73, '2025-07-07 18:46:00', NULL, 73, 1, 12, '1000.00', '0.00', '0.00', '0.00', '1000.00', '1000.00', '', NULL, NULL, '', '2025-07-07 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (74, '2025-07-13 18:47:00', NULL, 74, 1, 7, '7000.00', '0.00', '0.00', '0.00', '7000.00', '7000.00', '', NULL, NULL, '', '2025-07-07 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (75, '2025-07-21 18:49:00', NULL, 75, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-07 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (76, '2025-07-07 18:51:00', NULL, 76, 1, 9, '1000.00', '0.00', '0.00', '0.00', '1000.00', '1000.00', '', NULL, NULL, '', '2025-07-07 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (77, '2025-07-07 18:53:00', NULL, 77, 1, 12, '1000.00', '0.00', '0.00', '0.00', '1000.00', '1000.00', '', NULL, NULL, '', '2025-07-07 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (78, '2025-07-13 18:54:00', NULL, 78, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-07 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (79, '2025-08-04 18:56:00', NULL, 79, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-07 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (80, '2025-08-04 18:57:00', NULL, 80, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-07 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (81, '2025-07-22 19:15:00', NULL, 81, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-08 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (82, '2025-07-08 19:16:00', NULL, 82, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-08 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (83, '2025-07-12 19:20:00', NULL, 83, 1, 11, '1500.00', '0.00', '0.00', '0.00', '1500.00', '1500.00', '', NULL, NULL, '', '2025-07-08 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (84, '2025-07-22 19:22:00', NULL, 84, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-08 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (85, '2025-07-09 17:56:00', NULL, 85, 1, 8, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-09 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (86, '2025-07-09 17:58:00', NULL, 86, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-09 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (87, '2025-07-09 17:59:00', NULL, 87, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-09 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (88, '2025-07-23 18:01:00', NULL, 88, 1, 3, '15000.00', '0.00', '0.00', '0.00', '15000.00', '15000.00', '', NULL, NULL, '', '2025-07-09 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (89, '2025-07-23 18:03:00', NULL, 89, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-09 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (90, '2025-07-09 18:08:00', NULL, 90, 1, 22, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-09 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (91, '2025-07-14 18:11:00', NULL, 91, 1, 8, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-09 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (92, '2025-07-23 18:15:00', NULL, 92, 1, 3, '15000.00', '0.00', '0.00', '0.00', '15000.00', '15000.00', '', NULL, NULL, '', '2025-07-09 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (93, '2025-07-09 18:23:00', NULL, 93, 1, 6, '2500.00', '0.00', '0.00', '0.00', '2500.00', '2500.00', '', NULL, NULL, '', '2025-07-09 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (94, '2025-07-23 20:28:00', NULL, 94, 1, 3, '15000.00', '0.00', '0.00', '0.00', '15000.00', '15000.00', '', NULL, NULL, '', '2025-07-09 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (95, '2025-07-10 20:43:00', NULL, 95, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-10 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (96, '2025-07-10 20:46:00', NULL, 96, 1, 2, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-10 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (97, '2025-07-24 22:00:00', NULL, 97, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-10 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (98, '2025-07-10 22:01:00', NULL, 98, 1, 5, '1000.00', '0.00', '0.00', '0.00', '1000.00', '1000.00', '', NULL, NULL, '', '2025-07-10 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (99, '2025-07-12 09:28:00', NULL, 99, 1, 12, '1000.00', '0.00', '0.00', '0.00', '1000.00', '1000.00', '', NULL, NULL, '', '2025-07-12 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (100, '2025-07-12 09:31:00', NULL, 100, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-12 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (101, '2025-07-12 09:36:00', NULL, 101, 1, 14, '1500.00', '0.00', '0.00', '0.00', '1500.00', '1500.00', '', NULL, NULL, '', '2025-07-12 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (102, '2025-07-12 09:38:00', NULL, 102, 1, 14, '1500.00', '0.00', '0.00', '0.00', '1500.00', '1500.00', '', NULL, NULL, '', '2025-07-12 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (103, '2025-07-12 18:48:00', NULL, 103, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-12 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (104, '2025-07-12 18:50:00', NULL, 104, 1, 8, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-12 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (105, '2025-07-19 18:51:00', NULL, 105, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-12 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (106, '2025-07-26 18:53:00', NULL, 106, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-12 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (107, '2025-07-19 18:55:00', NULL, 107, 1, 14, '1500.00', '0.00', '0.00', '0.00', '1500.00', '1500.00', '', NULL, NULL, '', '2025-07-12 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (108, '2025-07-13 18:02:00', NULL, 108, 1, 8, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-13 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (109, '2025-07-14 18:08:00', NULL, 109, 1, 6, '2500.00', '0.00', '0.00', '0.00', '2500.00', '2500.00', '', NULL, NULL, '', '2025-07-13 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (110, '2025-07-20 18:13:00', NULL, 110, 1, 7, '7000.00', '0.00', '0.00', '0.00', '7000.00', '7000.00', '', NULL, NULL, '', '2025-07-13 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (111, '2025-07-13 18:15:00', NULL, 111, 1, 17, '3000.00', '0.00', '0.00', '0.00', '3000.00', '3000.00', '', NULL, NULL, '', '2025-07-13 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (112, '2025-07-20 18:16:00', NULL, 112, 1, 12, '1000.00', '0.00', '0.00', '0.00', '1000.00', '1000.00', '', NULL, NULL, '', '2025-07-13 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (113, '2025-07-14 18:55:00', NULL, 113, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-14 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (114, '2025-07-14 18:58:00', NULL, 114, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-14 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (115, '2025-07-14 19:00:00', NULL, 115, 1, 7, '7000.00', '0.00', '0.00', '0.00', '7000.00', '7000.00', '', NULL, NULL, '', '2025-07-14 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (116, '2025-07-14 19:02:00', NULL, 116, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-14 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (117, '2025-07-28 19:04:00', NULL, 117, 1, 3, '15000.00', '0.00', '0.00', '0.00', '15000.00', '15000.00', '', NULL, NULL, '', '2025-07-14 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (118, '2025-08-04 19:05:00', NULL, 118, 1, 3, '15000.00', '0.00', '0.00', '0.00', '15000.00', '15000.00', '', NULL, NULL, '', '2025-07-14 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (119, '2025-07-21 19:06:00', NULL, 119, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-14 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (120, '2025-07-14 19:08:00', NULL, 120, 1, 12, '1000.00', '0.00', '0.00', '0.00', '1000.00', '1000.00', '', NULL, NULL, '', '2025-07-14 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (121, '2025-07-16 19:13:00', NULL, 121, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (122, '2025-07-16 19:15:00', NULL, 122, 1, 9, '1000.00', '0.00', '0.00', '0.00', '1000.00', '1000.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (123, '2025-07-16 19:31:00', NULL, 123, 1, 8, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (124, '2025-07-16 19:32:00', NULL, 124, 1, 2, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (125, '2025-07-16 19:34:00', NULL, 125, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (126, '2025-07-16 19:35:00', NULL, 126, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (127, '2025-07-16 19:37:00', NULL, 127, 1, 14, '1500.00', '0.00', '0.00', '0.00', '1500.00', '1500.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (128, '2025-07-22 19:39:00', NULL, 128, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (129, '2025-07-16 19:40:00', NULL, 129, 1, 1, '700.00', '0.00', '0.00', '0.00', '700.00', '700.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (130, '2025-07-16 19:41:00', NULL, 130, 1, 3, '15000.00', '0.00', '0.00', '0.00', '15000.00', '15000.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (131, '2025-07-30 19:43:00', NULL, 131, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (132, '2025-07-16 19:44:00', NULL, 132, 1, 7, '7000.00', '0.00', '0.00', '0.00', '7000.00', '7000.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (133, '2025-07-16 19:47:00', NULL, 133, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (134, '2025-07-16 19:49:00', NULL, 134, 1, 8, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-16 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (135, '2025-07-17 15:39:00', NULL, 135, 1, 10, '2000.00', '0.00', '0.00', '0.00', '2000.00', '2000.00', '', NULL, NULL, '', '2025-07-17 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (136, '2025-07-17 15:41:41', NULL, 136, 1, 24, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, NULL, NULL, NULL, '2025-07-17 15:41:41');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (137, '2025-07-17 15:46:00', NULL, 137, 1, 21, '500.00', '0.00', '0.00', '0.00', '500.00', '500.00', '', NULL, NULL, '', '2025-07-17 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (139, '2025-07-17 15:50:10', NULL, 139, 1, 24, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, NULL, NULL, NULL, '2025-07-17 15:50:10');


#
# TABLE STRUCTURE FOR: patient_id_card
#

DROP TABLE IF EXISTS `patient_id_card`;

CREATE TABLE `patient_id_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `hospital_name` varchar(100) NOT NULL,
  `hospital_address` varchar(500) NOT NULL,
  `background` text NOT NULL,
  `logo` text NOT NULL,
  `sign_image` text NOT NULL,
  `header_color` varchar(100) NOT NULL,
  `enable_patient_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_guardian_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_patient_unique_id` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_address` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_phone` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_dob` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_blood_group` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `status` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_barcode` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_title` (`title`),
  KEY `index_hospital_name` (`hospital_name`),
  KEY `index_hospital_address` (`hospital_address`),
  KEY `index_header_color` (`header_color`),
  KEY `index_enable_patient_name` (`enable_patient_name`),
  KEY `index_enable_guardian_name` (`enable_guardian_name`),
  KEY `index_enable_patient_unique_id` (`enable_patient_unique_id`),
  KEY `index_enable_address` (`enable_address`),
  KEY `index_enable_phone` (`enable_phone`),
  KEY `index_enable_dob` (`enable_dob`),
  KEY `index_enable_blood_group` (`enable_blood_group`),
  KEY `index_status` (`status`),
  KEY `index_enable_barcode` (`enable_barcode`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `patient_id_card` (`id`, `title`, `hospital_name`, `hospital_address`, `background`, `logo`, `sign_image`, `header_color`, `enable_patient_name`, `enable_guardian_name`, `enable_patient_unique_id`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `status`, `enable_barcode`, `created_at`) VALUES (1, 'Sample Patient Id Card', 'Royal Hospital', 'Nr Loyala Ashram, A 69, Shahpura Rd, Manisha Market, Sector  Bhopal', 'background.jpg', 'logo.jpg', 'signature.png', '#0796f5', 1, 1, 1, 1, 1, 1, 1, 1, 0, '2021-10-19 09:06:02');


#
# TABLE STRUCTURE FOR: patient_timeline
#

DROP TABLE IF EXISTS `patient_timeline`;

CREATE TABLE `patient_timeline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `title` varchar(200) NOT NULL,
  `timeline_date` datetime DEFAULT NULL,
  `description` text DEFAULT NULL,
  `document` varchar(255) NOT NULL,
  `status` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `generated_users_type` varchar(100) NOT NULL,
  `generated_users_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `generated_users_id` (`generated_users_id`),
  KEY `index_title` (`title`),
  KEY `index_date` (`date`),
  KEY `index_timeline_date` (`timeline_date`),
  CONSTRAINT `patient_timeline_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_timeline_ibfk_2` FOREIGN KEY (`generated_users_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: patients
#

DROP TABLE IF EXISTS `patients`;

CREATE TABLE `patients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_id` int(11) DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `age` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `day` int(11) NOT NULL,
  `as_of_date` date DEFAULT NULL,
  `image` text DEFAULT NULL,
  `mobileno` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `gender` varchar(100) DEFAULT NULL,
  `marital_status` varchar(100) NOT NULL,
  `blood_group` varchar(200) NOT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `guardian_name` varchar(100) DEFAULT NULL,
  `patient_type` varchar(200) NOT NULL,
  `identification_number` varchar(60) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `note` varchar(200) NOT NULL,
  `is_ipd` varchar(200) NOT NULL,
  `app_key` varchar(200) NOT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `is_dead` varchar(255) NOT NULL DEFAULT 'no',
  `is_antenatal` int(11) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `disable_at` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `idx_patient_name` (`patient_name`),
  KEY `idx_dob` (`dob`),
  KEY `idx_age` (`age`),
  KEY `idx_month` (`month`),
  KEY `idx_mobileno` (`mobileno`),
  KEY `idx_email` (`email`),
  KEY `idx_gender` (`gender`),
  KEY `idx_marital_status` (`marital_status`),
  KEY `idx_address` (`address`(500)),
  KEY `idx_guardian_name` (`guardian_name`),
  KEY `organisation_id` (`organisation_id`),
  CONSTRAINT `patients_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patients_ibfk_2` FOREIGN KEY (`organisation_id`) REFERENCES `organisation` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (1, NULL, 'CLINTON RATEMO', NULL, 1, 1, 1990, '2025-06-23', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', '', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-06-23 10:51:35');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (2, NULL, 'CLINTON RATEMO', NULL, 1, 1, 1990, '2025-06-23', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', '', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-06-23 13:11:37');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (3, NULL, 'CLINT', NULL, 1, 1, 1900, '2025-06-24', 'uploads/patient_images/no_image.png', '', '', '', '', '', NULL, '', '', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-06-24 13:51:49');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (4, NULL, 'WAFULA', NULL, 1, 1, 2003, '2025-06-24', 'uploads/patient_images/no_image.png', '', '', '', '', '', NULL, '', '', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-06-24 13:56:35');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (5, NULL, 'MOHAMMED', NULL, 1, 1, 1990, '2025-06-25', 'uploads/patient_images/no_image.png', '', '', '', '', '', NULL, '', 'ABDI', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-06-25 11:49:44');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (6, NULL, 'MOHANED', NULL, 1, 12, 1990, '2025-06-25', 'uploads/patient_images/no_image.png', '', '', '', '', '', NULL, '', 'ADAN', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-06-25 11:50:40');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (7, NULL, 'Guyo', NULL, 2005, 1, 1, '2025-06-25', 'uploads/patient_images/no_image.png', '0743871833', '', '', '', '', NULL, '', 'Didhole', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-06-25 15:52:15');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (8, NULL, 'Fatuma', '2025-07-08', 1989, 5, 7, '2025-07-01', 'uploads/patient_images/no_image.png', '', '', 'Female', 'Not Specified', '', NULL, '', 'Ibrahim', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-01 15:37:06');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (9, NULL, 'Issack', NULL, 1990, 12, 12, '2025-07-01', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Iche', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-01 15:46:48');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (10, NULL, 'Isaack', NULL, 1990, 8, 8, '2025-07-01', 'uploads/patient_images/no_image.png', '', '', '', '', '', NULL, '', 'Iche', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-01 15:51:42');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (11, NULL, 'Rahama', NULL, 2021, 4, 4, '2025-07-01', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Ali', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-01 15:53:27');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (12, NULL, 'Buke', NULL, 2018, 7, 7, '2025-07-01', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Hasssan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-01 15:56:34');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (13, NULL, 'Ramlah', NULL, 2000, 7, 7, '2025-07-01', 'uploads/patient_images/no_image.png', '0797194879', '', 'Female', '', '', NULL, '', 'Somo', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-01 16:04:09');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (14, NULL, 'Hale', NULL, 2008, 8, 8, '2025-07-01', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Ibrahim', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-01 16:06:53');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (15, NULL, 'Faizah', NULL, 2005, 5, 5, '2025-07-01', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-01 16:08:02');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (16, NULL, 'Shamsea', '2025-07-01', 1995, 1, 10, '2025-07-01', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Golicha', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-01 16:32:40');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (17, NULL, 'Bangile', NULL, 1990, 3, 3, '2025-07-02', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Warqu', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-02 10:43:18');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (18, NULL, 'Zainab', NULL, 2002, 2, 2, '2025-07-02', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Hussein', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-02 12:42:43');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (19, NULL, 'Omaar', NULL, 1992, 3, 3, '2025-07-02', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Abdi', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-02 12:44:55');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (20, NULL, 'Buke', NULL, 2005, 1, 1, '2025-07-02', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-02 15:24:53');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (21, NULL, 'Boru', NULL, 2004, 2, 2, '2025-07-02', 'uploads/patient_images/no_image.png', '0112325007', '', 'Male', '', '', NULL, '', 'Abdi', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-02 18:12:38');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (22, NULL, 'Yurub', NULL, 1996, 1, 1, '2025-07-02', 'uploads/patient_images/no_image.png', '0726243737', '', 'Female', '', '', NULL, '', 'Ibrahim', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-02 18:19:37');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (23, NULL, 'Daka', NULL, 1992, 3, 3, '2025-07-03', 'uploads/patient_images/no_image.png', '+251960573386', '', 'Female', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-03 13:10:48');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (24, NULL, 'Daka', NULL, 1993, 4, 4, '2025-07-03', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-03 13:20:57');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (25, NULL, 'Daka', NULL, 1993, 2, 2, '2025-07-03', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-03 13:34:06');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (26, NULL, 'Ramlah', NULL, 1999, 9, 9, '2025-07-03', 'uploads/patient_images/no_image.png', '0111543728', '', 'Female', '', '', NULL, '', 'Abdullah', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-03 13:39:13');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (27, NULL, 'Sadam', NULL, 2006, 3, 3, '2025-07-03', 'uploads/patient_images/no_image.png', '0799242936', '', 'Male', '', '', NULL, '', 'Mide', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-03 13:41:05');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (28, NULL, 'Hassan', NULL, 2003, 1, 1, '2025-07-03', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Fayo', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-03 15:40:49');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (29, NULL, 'Rangile', NULL, 1978, 1, 1, '2025-07-03', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Warqu', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-03 15:46:05');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (30, NULL, 'Nasibo', NULL, 2008, 8, 8, '2025-07-03', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Dina', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-03 17:50:21');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (31, NULL, 'Chege', NULL, 1995, 7, 6, '2025-07-03', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Daudi', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-03 17:54:04');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (32, NULL, 'Aminahhhhhhhhhhhhhh', NULL, 2000, 4, 4, '2025-07-03', 'uploads/patient_images/no_image.png', '0755294439', '', 'Female', '', '', NULL, '', 'Dentures', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-03 18:21:17');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (33, NULL, 'Rose', NULL, 1993, 4, 4, '2025-07-04', 'uploads/patient_images/no_image.png', '0729958627', '', 'Female', '', '', NULL, '', 'Dawe', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-04 09:52:19');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (34, NULL, 'Abshiro', NULL, 1999, 7, 7, '2025-07-04', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Eden', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-04 13:24:41');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (35, NULL, 'Hanan', NULL, 2004, 5, 5, '2025-07-04', 'uploads/patient_images/no_image.png', '0718010032', '', 'Female', '', '', NULL, '', 'Abate', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-04 13:28:04');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (36, NULL, 'Halima', NULL, 2000, 8, 8, '2025-07-04', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Hussein', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-04 13:29:55');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (37, NULL, 'Buke', NULL, 1965, 6, 6, '2025-07-04', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Sirah', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-04 13:31:21');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (38, NULL, 'Zarah', NULL, 2005, 5, 5, '2025-07-04', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Eden', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-04 17:55:19');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (39, NULL, 'Bonaya', NULL, 1993, 3, 3, '2025-07-04', 'uploads/patient_images/no_image.png', '0724143502', '', 'Female', '', '', NULL, '', 'Chachole', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-04 17:57:06');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (40, NULL, 'Soores', NULL, 1999, 9, 9, '2025-07-04', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', '', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-04 18:00:15');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (41, NULL, 'Sarah', NULL, 1999, 3, 3, '2025-07-05', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Abdikhadir', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-05 17:32:30');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (42, NULL, 'Abshir', NULL, 2000, 4, 4, '2025-07-05', 'uploads/patient_images/no_image.png', '0795442316', '', 'Male', '', '', NULL, '', 'Ibrahim', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-05 17:34:26');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (43, NULL, 'Balqis', NULL, 2000, 6, 6, '2025-07-05', 'uploads/patient_images/no_image.png', '0729948935', '', 'Male', '', '', NULL, '', 'Ibrahim', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-05 17:39:24');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (44, NULL, 'Balqis', NULL, 2011, 3, 3, '2025-07-05', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Ibrahim', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-05 17:41:08');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (45, NULL, 'Ibrahim', NULL, 1985, 2, 2, '2025-07-05', 'uploads/patient_images/no_image.png', '0721138967', '', 'Male', '', '', NULL, '', 'Jirow', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-05 17:43:35');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (46, NULL, 'Loco', NULL, 2014, 3, 3, '2025-07-05', 'uploads/patient_images/no_image.png', '0727414587', '', '', '', '', NULL, '', 'Nur', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-05 17:45:09');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (47, NULL, 'Rehema', NULL, 2000, 3, 3, '2025-07-05', 'uploads/patient_images/no_image.png', '0745957693', '', 'Female', '', '', NULL, '', 'Adan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-05 17:46:29');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (48, NULL, 'Maimunah', NULL, 1992, 3, 3, '2025-07-05', 'uploads/patient_images/no_image.png', '0729769040', '', 'Female', '', '', NULL, '', 'Adan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-05 17:47:53');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (49, NULL, 'Zarah', NULL, 2005, 3, 3, '2025-07-05', 'uploads/patient_images/no_image.png', '0714421303', '', 'Female', '', '', NULL, '', 'Adan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-05 17:49:08');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (50, NULL, 'Ruffo', NULL, 2005, 3, 3, '2025-07-05', 'uploads/patient_images/no_image.png', '0740075519', '', 'Female', '', '', NULL, '', 'Emmanuel', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-05 17:50:41');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (51, NULL, 'Yedo', NULL, 2002, 2, 2, '2025-07-05', 'uploads/patient_images/no_image.png', '0791356711', '', 'Female', '', '', NULL, '', 'Voyala', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-05 17:52:16');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (52, NULL, 'Scandy', NULL, 2000, 3, 3, '2025-07-05', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Chepngetich', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-05 17:54:29');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (53, NULL, 'Hasil', NULL, 2003, 3, 3, '2025-07-06', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Liban', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-06 16:51:04');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (54, NULL, 'Zaituna', NULL, 2009, 4, 4, '2025-07-06', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Olow', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-06 16:52:38');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (55, NULL, 'Kotha', NULL, 2008, 4, 4, '2025-07-06', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Musa', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-06 16:55:06');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (56, NULL, 'Diramu', NULL, 2000, 3, 3, '2025-07-06', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Mussa', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-06 16:56:21');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (57, NULL, 'Ubah', NULL, 2008, 3, 3, '2025-07-06', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Ali', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-06 16:57:52');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (58, NULL, 'Abdihakim', NULL, 2000, 2, 2, '2025-07-06', 'uploads/patient_images/no_image.png', '0723242563', '', '', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-06 16:59:12');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (59, NULL, 'Emmanuel', NULL, 1994, 3, 2, '2025-07-06', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Kitui', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-06 17:00:46');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (60, NULL, 'Michael', NULL, 1993, 2, 2, '2025-07-06', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Mwendwa', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-06 17:02:05');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (61, NULL, 'Qabale', NULL, 1996, 5, 5, '2025-07-07', 'uploads/patient_images/no_image.png', '0712248507', '', 'Female', '', '', NULL, '', 'Galmah', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-07 17:41:32');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (62, NULL, 'Darim', NULL, 2000, 3, 3, '2025-07-07', 'uploads/patient_images/no_image.png', '0757074563', '', 'Female', '', '', NULL, '', 'Dida', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-07 17:42:59');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (63, NULL, 'Abdi', NULL, 2000, 3, 3, '2025-07-07', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Kanu', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-07 17:44:11');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (64, NULL, 'Roble', NULL, 1994, 3, 3, '2025-07-07', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Adan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-07 17:45:15');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (65, NULL, 'Fatuma', NULL, 1973, 3, 3, '2025-07-07', 'uploads/patient_images/no_image.png', '0715391269', '', '', '', '', NULL, '', 'Sora', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-07 17:46:23');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (66, NULL, 'Sylvia', NULL, 2002, 3, 3, '2025-07-07', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Achieng', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-07 17:48:28');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (67, NULL, 'Roge', NULL, 2000, 3, 3, '2025-07-07', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Bate', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-07 17:50:33');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (68, NULL, 'Mulki', NULL, 2010, 3, 3, '2025-07-07', 'uploads/patient_images/no_image.png', '0720069062', '', 'Female', '', '', NULL, '', 'Adan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-07 17:52:16');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (69, NULL, 'Rahmah', NULL, 2002, 5, 5, '2025-07-07', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Salad', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-07 17:53:24');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (70, NULL, 'Sudus', NULL, 2010, 4, 4, '2025-07-07', 'uploads/patient_images/no_image.png', '0705001517', '', 'Female', '', '', NULL, '', 'Mohammed', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-07 17:54:57');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (71, NULL, 'Sumeiyah', NULL, 2010, 3, 3, '2025-07-07', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Ali', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-07 17:56:00');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (72, NULL, 'Nyiwar', NULL, 2000, 2, 2, '2025-07-08', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Abdi', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-08 18:14:22');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (73, NULL, 'Caroline', NULL, 1998, 3, 4, '2025-07-08', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Kambura', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-08 18:15:26');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (74, NULL, 'Daka', NULL, 1990, 3, 3, '2025-07-08', 'uploads/patient_images/no_image.png', '', '', '', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-08 18:19:32');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (75, NULL, 'Nuria', NULL, 2000, 4, 4, '2025-07-08', 'uploads/patient_images/no_image.png', '', '', '', '', '', NULL, '', 'Abdo', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-08 18:20:56');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (76, NULL, 'Abubak', NULL, 1995, 4, 4, '2025-07-09', 'uploads/patient_images/no_image.png', '0723460642', '', 'Male', '', '', NULL, '', 'Roba', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-09 16:55:12');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (77, NULL, 'Dahabo', NULL, 1999, 3, 3, '2025-07-09', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Dida', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-09 16:56:34');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (78, NULL, 'Aisha', NULL, 1996, 4, 4, '2025-07-09', 'uploads/patient_images/no_image.png', '0797172616', '', 'Female', '', '', NULL, '', 'Hussein', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-09 16:58:16');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (79, NULL, 'Khalif', NULL, 1998, 4, 3, '2025-07-09', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Salah', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-09 16:59:55');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (80, NULL, 'Chukulisa', NULL, 1999, 4, 4, '2025-07-09', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Jadan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-09 17:02:11');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (81, NULL, 'Hamzah', NULL, 2011, 3, 3, '2025-07-09', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Abdikhadir', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-09 17:06:19');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (82, NULL, 'Joseph', NULL, 1993, 4, 4, '2025-07-09', 'uploads/patient_images/no_image.png', '0113713342', '', 'Male', '', '', NULL, '', 'Kariuki', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-09 17:09:46');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (83, NULL, 'Halima', NULL, 2004, 4, 6, '2025-07-09', 'uploads/patient_images/no_image.png', '0720992596', '', 'Female', '', '', NULL, '', 'Ali', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-09 17:13:51');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (84, NULL, 'Sophia', NULL, 1996, 3, 3, '2025-07-09', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Hussein', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-09 17:21:46');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (85, NULL, 'Rahmah', NULL, 1997, 4, 4, '2025-07-09', 'uploads/patient_images/no_image.png', '0719539902', '', 'Female', '', '', NULL, '', 'Abdi', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-09 19:27:20');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (86, NULL, 'Joan', NULL, 1995, 6, 8, '2025-07-10', 'uploads/patient_images/no_image.png', '0720668799', '', 'Female', '', '', NULL, '', 'Kosgey', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-10 19:38:57');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (87, NULL, 'Jeremiah', NULL, 2000, 3, 3, '2025-07-10', 'uploads/patient_images/no_image.png', '0746768734', '', 'Male', '', '', NULL, '', 'Juma', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-10 19:45:57');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (88, NULL, 'Ilhan', NULL, 2010, 3, 3, '2025-07-10', 'uploads/patient_images/no_image.png', '0705458227', '', 'Male', '', '', NULL, '', 'Mohammed', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-10 21:00:24');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (89, NULL, 'Habiba', NULL, 1972, 2, 2, '2025-07-10', 'uploads/patient_images/no_image.png', '0728701201', '', 'Female', '', '', NULL, '', 'Ibrahim', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-10 21:01:47');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (90, NULL, 'Fatuma', NULL, 1998, 7, 7, '2025-07-12', 'uploads/patient_images/no_image.png', '0746758185', '', 'Female', '', '', NULL, '', 'Mamo', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-12 08:19:04');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (91, NULL, 'Fatuma', NULL, 2000, 4, 4, '2025-07-12', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Mumo', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-12 08:28:03');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (92, NULL, 'Bagache', NULL, 2000, 9, 5, '2025-07-12', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Dube', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-12 08:31:35');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (93, NULL, 'Jillo', NULL, 1995, 4, 4, '2025-07-12', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Jarso', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-12 08:36:34');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (94, NULL, 'Hassan', NULL, 2004, 4, 4, '2025-07-12', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Ali', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-12 08:37:48');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (95, NULL, 'Timothy', NULL, 1993, 3, 3, '2025-07-12', 'uploads/patient_images/no_image.png', '0716354249', '', 'Male', '', '', NULL, '', 'Musyoka', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-12 17:48:18');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (96, NULL, 'Harriet', NULL, 1999, 3, 3, '2025-07-12', 'uploads/patient_images/no_image.png', '', '', '', '', '', NULL, '', 'Saina', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-12 17:49:58');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (97, NULL, 'Teklu', NULL, 1995, 3, 3, '2025-07-12', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Abara', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-12 17:51:04');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (98, NULL, 'Nadhifo', NULL, 2003, 4, 3, '2025-07-12', 'uploads/patient_images/no_image.png', '0723963551', '', '', '', '', NULL, '', 'Shukri', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-12 17:52:29');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (99, NULL, 'Hafida', NULL, 2003, 3, 3, '2025-07-12', 'uploads/patient_images/no_image.png', '', '', '', '', '', NULL, '', 'Abdi', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-12 17:54:49');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (100, NULL, 'Irine', NULL, 1996, 3, 3, '2025-07-12', 'uploads/patient_images/no_image.png', '', '', '', '', '', NULL, '', 'Wairimu', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-12 17:55:25');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (101, NULL, 'Wako', NULL, 2010, 2, 2, '2025-07-13', 'uploads/patient_images/no_image.png', '0743853177', '', 'Male', '', '', NULL, '', 'Nuru', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-13 17:02:06');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (102, NULL, 'Daka', NULL, 1992, 3, 3, '2025-07-13', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-13 17:06:56');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (103, NULL, 'Daka', NULL, 1993, 6, 6, '2025-07-13', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-13 17:08:37');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (104, NULL, 'Fatuma', NULL, 1973, 5, 7, '2025-07-13', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Sora', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-13 17:12:02');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (105, NULL, 'Fatuma', NULL, 1972, 3, 3, '2025-07-13', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', '', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-13 17:13:36');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (106, NULL, 'isafay', NULL, 2011, 2, 2, '2025-07-13', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Kefle', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-13 17:14:51');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (107, NULL, 'Rahmah', NULL, 2004, 3, 3, '2025-07-13', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Salad', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-13 17:16:08');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (108, NULL, 'Qabale', NULL, 2000, 7, 9, '2025-07-14', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Galume', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-14 17:55:13');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (109, NULL, 'HANNAH', NULL, 2004, 4, 4, '2025-07-14', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Adiso', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-14 17:58:34');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (110, NULL, 'Mohammed', NULL, 2000, 0, 2, '2025-07-14', 'uploads/patient_images/no_image.png', '0714500599', '', 'Male', '', '', NULL, '', 'Bishar', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-14 18:00:24');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (111, NULL, 'Zeymina', NULL, 2000, 0, 0, '2025-07-14', 'uploads/patient_images/no_image.png', '0740505283', '', 'Female', '', '', NULL, '', 'Abdi', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-14 18:02:35');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (112, NULL, 'Khadar', NULL, 2000, 0, 0, '2025-07-14', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Mohammed', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-14 18:04:11');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (113, NULL, 'zuleka', NULL, 2000, 0, 0, '2025-07-14', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-14 18:05:19');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (114, NULL, 'Maimuna', NULL, 1995, 0, 0, '2025-07-14', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Adan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-14 18:06:41');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (115, NULL, 'Ihlan', '0009-00-20', 16, 6, 25, '2025-07-14', 'uploads/patient_images/no_image.png', '', '', '', '', '', NULL, '', 'Mohammed', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-14 18:07:53');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (116, NULL, 'Daad', NULL, 2000, 3, 3, '2025-07-16', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Bagacha', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:12:48');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (117, NULL, 'Loko', NULL, 1999, 4, 5, '2025-07-16', 'uploads/patient_images/no_image.png', '0794433421', '', 'Female', '', '', NULL, '', 'Huka', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:14:41');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (118, NULL, 'Barwaqo', NULL, 2002, 2, 2, '2025-07-16', 'uploads/patient_images/no_image.png', '0796681582', '', '', '', '', NULL, '', 'Ali', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:30:47');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (119, NULL, 'Jattani', NULL, 2009, 3, 3, '2025-07-16', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Ali', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:32:29');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (120, NULL, 'Abdullahi', NULL, 1998, 3, 3, '2025-07-16', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:33:55');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (121, NULL, 'Qaliti', NULL, 2000, 3, 3, '2025-07-16', 'uploads/patient_images/no_image.png', '', '', '', '', '', NULL, '', 'Jirimah', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:35:09');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (122, NULL, 'Roba', NULL, 2004, 4, 4, '2025-07-16', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:36:58');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (123, NULL, 'Euticus', NULL, 1995, 4, 4, '2025-07-16', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Katobu', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:38:48');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (124, NULL, 'Abdullah', NULL, 2003, 3, 3, '2025-07-16', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:39:51');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (125, NULL, 'Wako', NULL, 2010, 4, 4, '2025-07-16', 'uploads/patient_images/no_image.png', '', '', 'Male', '', '', NULL, '', 'Nuru', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:40:59');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (126, NULL, 'Lemlem', NULL, 2007, 3, 3, '2025-07-16', 'uploads/patient_images/no_image.png', '0757565920', '', 'Female', '', '', NULL, '', 'Ibrahim', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:42:44');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (127, NULL, 'Halima', NULL, 2004, 4, 5, '2025-07-16', 'uploads/patient_images/no_image.png', '0758495074', '', 'Female', '', '', NULL, '', 'Ali', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:44:07');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (128, NULL, 'Halima', NULL, 2000, 3, 3, '2025-07-16', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:47:15');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (129, NULL, 'Makay', NULL, 1990, 1, 4, '2025-07-16', 'uploads/patient_images/no_image.png', '0720392596', '', 'Female', '', '', NULL, '', 'Hassan', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-16 18:49:07');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (130, NULL, 'Leilah', NULL, 1985, 3, 3, '2025-07-17', 'uploads/patient_images/no_image.png', '', '', 'Female', '', '', NULL, '', 'Ibrahim', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-17 14:39:00');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (131, NULL, 'Fatuma', NULL, 2003, 2, 7, '2025-07-17', 'uploads/patient_images/no_image.png', '0703265176', '', 'Female', '', '', NULL, '', 'MOhhamed', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-17 14:46:14');


#
# TABLE STRUCTURE FOR: patients_vitals
#

DROP TABLE IF EXISTS `patients_vitals`;

CREATE TABLE `patients_vitals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `vital_id` int(11) NOT NULL,
  `reference_range` varchar(100) NOT NULL,
  `messure_date` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `index_reference_range` (`reference_range`),
  KEY `index_messure_date` (`messure_date`),
  KEY `vital_id` (`vital_id`),
  CONSTRAINT `patients_vitals_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patients_vitals_ibfk_2` FOREIGN KEY (`vital_id`) REFERENCES `vitals` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patients_vitals_ibfk_3` FOREIGN KEY (`vital_id`) REFERENCES `vitals` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: payment_settings
#

DROP TABLE IF EXISTS `payment_settings`;

CREATE TABLE `payment_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_type` varchar(200) NOT NULL,
  `api_username` varchar(200) DEFAULT NULL,
  `api_secret_key` varchar(200) NOT NULL,
  `salt` varchar(200) NOT NULL,
  `api_publishable_key` varchar(200) NOT NULL,
  `paytm_website` varchar(255) NOT NULL,
  `paytm_industrytype` varchar(255) NOT NULL,
  `api_password` varchar(200) DEFAULT NULL,
  `api_signature` varchar(200) DEFAULT NULL,
  `api_email` varchar(200) DEFAULT NULL,
  `paypal_demo` varchar(100) NOT NULL,
  `account_no` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_payment_type` (`payment_type`),
  KEY `index_api_username` (`api_username`),
  KEY `index_api_secret_key` (`api_secret_key`),
  KEY `index_salt` (`salt`),
  KEY `index_api_publishable_key` (`api_publishable_key`),
  KEY `index_paytm_website` (`paytm_website`),
  KEY `index_paytm_industrytype` (`paytm_industrytype`),
  KEY `index_api_password` (`api_password`),
  KEY `index_api_signature` (`api_signature`),
  KEY `index_api_email` (`api_email`),
  KEY `index_paypal_demo` (`paypal_demo`),
  KEY `index_account_no` (`account_no`),
  KEY `index_is_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: payslip_allowance
#

DROP TABLE IF EXISTS `payslip_allowance`;

CREATE TABLE `payslip_allowance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_payslip_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `allowance_type` varchar(200) NOT NULL,
  `amount` float NOT NULL,
  `cal_type` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `staff_payslip_id` (`staff_payslip_id`),
  KEY `index_allowance_type` (`allowance_type`),
  KEY `index_amount` (`amount`),
  KEY `index_cal_type` (`cal_type`),
  CONSTRAINT `payslip_allowance_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `payslip_allowance_ibfk_2` FOREIGN KEY (`staff_payslip_id`) REFERENCES `staff_payslip` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: permission_category
#

DROP TABLE IF EXISTS `permission_category`;

CREATE TABLE `permission_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `perm_group_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) DEFAULT NULL,
  `enable_view` int(11) DEFAULT 0,
  `enable_add` int(11) DEFAULT 0,
  `enable_edit` int(11) DEFAULT 0,
  `enable_delete` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=420 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (9, 3, 'Income', 'income', 1, 1, 1, 1, '2018-06-22 01:23:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (10, 3, 'Income Head', 'income_head', 1, 1, 1, 1, '2018-06-22 01:22:44');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (12, 4, 'Expense', 'expense', 1, 1, 1, 1, '2018-06-22 01:24:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (13, 4, 'Expense Head', 'expense_head', 1, 1, 1, 1, '2018-06-22 01:23:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (27, 8, 'Content Type', 'content_type', 1, 1, 1, 1, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (31, 10, 'Issue Item', 'issue_item', 1, 1, 0, 1, '2018-12-17 00:55:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (32, 10, 'Item Stock', 'item_stock', 1, 1, 1, 1, '2018-06-22 01:35:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (33, 10, 'Item', 'item', 1, 1, 1, 1, '2018-06-22 01:35:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (34, 10, 'Store', 'store', 1, 1, 1, 1, '2018-06-22 01:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (35, 10, 'Supplier', 'supplier', 1, 1, 1, 1, '2018-06-22 01:36:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (43, 13, 'Notice Board', 'notice_board', 1, 1, 1, 1, '2018-06-22 01:41:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (44, 13, 'Email / SMS', 'email_sms', 1, 0, 0, 0, '2018-06-22 01:40:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (48, 14, 'OPD Report', 'opd_report', 1, 0, 0, 0, '2018-12-17 23:59:18');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (53, 15, 'Languages', 'languages', 1, 1, 0, 0, '2021-09-13 00:56:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (54, 15, 'General Setting', 'general_setting', 1, 0, 1, 0, '2018-07-05 00:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (56, 15, 'Notification Setting', 'notification_setting', 1, 0, 1, 0, '2018-07-05 00:08:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (57, 15, 'SMS Setting', 'sms_setting', 1, 0, 1, 0, '2018-07-05 00:08:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (58, 15, 'Email Setting', 'email_setting', 1, 0, 1, 0, '2018-07-05 00:08:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (59, 15, 'Front CMS Setting', 'front_cms_setting', 1, 0, 1, 0, '2018-07-05 00:08:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (60, 15, 'Payment Methods', 'payment_methods', 1, 0, 1, 0, '2018-07-05 00:08:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (61, 16, 'Menus', 'menus', 1, 1, 0, 1, '2018-07-08 18:50:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (62, 16, 'Media Manager', 'media_manager', 1, 1, 0, 1, '2018-07-08 18:50:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (63, 16, 'Banner Images', 'banner_images', 1, 1, 0, 1, '2018-06-22 01:46:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (64, 16, 'Pages', 'pages', 1, 1, 1, 1, '2018-06-22 01:46:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (65, 16, 'Gallery', 'gallery', 1, 1, 1, 1, '2018-06-22 01:47:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (66, 16, 'Event', 'event', 1, 1, 1, 1, '2018-06-22 01:47:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (67, 16, 'News', 'notice', 1, 1, 1, 1, '2018-07-02 23:39:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (80, 17, 'Visitor Book', 'visitor_book', 1, 1, 1, 1, '2018-06-22 01:48:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (81, 17, 'Phone Call Log', 'phone_call_log', 1, 1, 1, 1, '2018-06-22 01:50:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (82, 17, 'Postal Dispatch', 'postal_dispatch', 1, 1, 1, 1, '2018-06-22 01:50:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (83, 17, 'Postal Receive', 'postal_receive', 1, 1, 1, 1, '2018-06-22 01:50:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (84, 17, 'Complain', 'complain', 1, 1, 1, 1, '2018-12-19 00:11:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (85, 17, 'Setup Front Office', 'setup_front_office', 1, 1, 1, 1, '2018-11-14 15:49:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (86, 18, 'Staff', 'staff', 1, 1, 1, 1, '2018-06-22 01:53:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (87, 18, 'Disable Staff', 'disable_staff', 1, 0, 0, 0, '2018-06-22 01:53:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (88, 18, 'Staff Attendance', 'staff_attendance', 1, 1, 1, 0, '2018-06-22 01:53:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (89, 14, 'Staff Attendance Report', 'staff_attendance_report', 1, 0, 0, 0, '2021-09-13 04:12:50');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (90, 18, 'Staff Payroll', 'staff_payroll', 1, 1, 1, 1, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (91, 14, 'Payroll Report', 'payroll_report', 1, 0, 0, 0, '2021-09-13 04:13:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (102, 21, 'Calendar To Do List', 'calendar_to_do_list', 1, 1, 1, 1, '2018-06-22 01:54:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (104, 10, 'Item Category', 'item_category', 1, 1, 1, 1, '2018-06-22 01:34:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (108, 18, ' Approve Leave Request', 'approve_leave_request', 1, 1, 1, 1, '2018-07-02 01:17:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (109, 18, 'Apply Leave', 'apply_leave', 1, 1, 0, 1, '2020-08-24 16:48:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (110, 18, 'LeaveTypes', 'leave_types', 1, 1, 1, 1, '2021-10-26 13:54:30');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (111, 18, 'Department', 'department', 1, 1, 1, 1, '2018-06-25 18:57:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (112, 18, 'Designation', 'designation', 1, 1, 1, 1, '2018-06-25 18:57:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (118, 22, 'Staff Role Count Widget', 'staff_role_count_widget', 1, 0, 0, 0, '2018-07-02 22:13:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (126, 15, 'Users', 'users', 1, 0, 0, 0, '2021-09-21 21:43:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (127, 18, 'Can See Other Users Profile', 'can_see_other_users_profile', 1, 0, 0, 0, '2018-07-02 23:42:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (129, 18, 'Staff Timeline', 'staff_timeline', 0, 1, 0, 1, '2018-07-04 23:08:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (130, 15, 'Backup', 'backup', 1, 1, 0, 1, '2018-07-08 19:17:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (131, 15, 'Restore', 'restore', 1, 0, 0, 0, '2018-07-08 19:17:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (132, 23, 'OPD Patient', 'opd_patient', 1, 1, 1, 1, '2018-12-20 00:37:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (134, 23, 'Prescription', 'prescription', 1, 1, 1, 1, '2018-10-10 16:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (135, 23, 'Visit', 'visit', 1, 1, 1, 1, '2021-09-16 22:39:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (137, 23, 'OPD Timeline', 'opd_timeline', 1, 1, 1, 1, '2021-02-24 03:02:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (138, 24, 'IPD Patients', 'ipd_patient', 1, 1, 1, 1, '2018-10-10 22:14:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (139, 24, 'Discharged Patients', 'discharged_patients', 1, 1, 1, 1, '2021-02-24 03:27:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (140, 24, 'Consultant Register', 'consultant_register', 1, 1, 1, 1, '2021-02-24 03:37:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (142, 24, 'IPD Timeline', 'ipd_timeline', 1, 1, 1, 1, '2021-02-25 03:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (143, 24, 'Charges', 'charges', 1, 1, 1, 1, '2018-10-10 16:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (144, 24, 'Payment', 'payment', 1, 1, 1, 1, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (146, 25, 'Medicine', 'medicine', 1, 1, 1, 1, '2018-10-10 16:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (148, 25, 'Pharmacy Bill', 'pharmacy_bill', 1, 1, 1, 1, '2021-02-25 03:33:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (149, 26, 'Pathology Test', 'pathology_test', 1, 1, 1, 1, '2021-02-25 03:36:32');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (152, 27, 'Radiology Test', 'radiology_test', 1, 1, 1, 1, '2021-02-25 03:45:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (153, 27, 'Radiology  Bill', 'radiology_bill', 1, 1, 1, 1, '2021-09-16 20:16:48');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (155, 22, 'IPD Income Widget', 'ipd_income_widget', 1, 0, 0, 0, '2018-12-20 00:08:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (156, 22, 'OPD Income Widget', 'opd_income_widget', 1, 0, 0, 0, '2018-12-20 00:08:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (157, 22, 'Pharmacy Income Widget', 'pharmacy_income_widget', 1, 0, 0, 0, '2018-12-20 00:08:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (158, 22, 'Pathology Income Widget', 'pathology_income_widget', 1, 0, 0, 0, '2018-12-20 00:08:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (159, 22, 'Radiology Income Widget', 'radiology_income_widget', 1, 0, 0, 0, '2018-12-20 00:08:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (161, 22, 'Blood Bank Income Widget', 'blood_bank_income_widget', 1, 0, 0, 0, '2018-12-20 00:09:13');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (162, 22, 'Ambulance Income Widget', 'ambulance_income_widget', 1, 0, 0, 0, '2018-12-20 00:09:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (165, 29, 'Ambulance Call', 'ambulance_call', 1, 1, 1, 1, '2018-10-26 18:37:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (166, 29, 'Ambulance', 'ambulance', 1, 1, 1, 1, '2018-10-26 18:37:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (168, 30, 'Blood Issue', 'blood_issue', 1, 1, 1, 1, '2018-10-26 19:20:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (169, 30, 'Blood Donor', 'blood_donor', 1, 1, 1, 1, '2018-10-26 19:20:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (170, 25, 'Medicine Category', 'medicine_category', 1, 1, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (171, 27, 'Radiology Category', 'radiology_category', 1, 1, 1, 1, '2021-02-25 03:52:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (173, 31, 'Organisation', 'organisation', 1, 1, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (175, 26, 'Pathology Category', 'pathology_category', 1, 1, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (176, 32, 'Hospital Charges', 'hospital_charges', 1, 1, 1, 1, '2021-09-12 22:29:30');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (178, 14, 'IPD Report', 'ipd_report', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (179, 14, 'Pharmacy Bill Report', 'pharmacy_bill_report', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (180, 14, 'Pathology Patient Report', 'pathology_patient_report', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (181, 14, 'Radiology Patient Report', 'radiology_patient_report', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (182, 14, 'OT Report', 'ot_report', 1, 0, 0, 0, '2019-03-07 21:56:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (183, 14, 'Blood Donor Report', 'blood_donor_report', 1, 0, 0, 0, '2019-03-07 21:56:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (184, 14, 'Payroll Month Report', 'payroll_month_report', 1, 0, 0, 0, '2019-03-07 21:57:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (185, 14, 'Payroll Report', 'payroll_report', 1, 0, 0, 0, '2019-03-07 21:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (187, 14, 'User Log', 'user_log', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (188, 14, 'Patient Login Credential', 'patient_login_credential', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (189, 14, 'Email / SMS Log', 'email_sms_log', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (190, 22, 'Yearly Income & Expense Chart', 'yearly_income_expense_chart', 1, 0, 0, 0, '2018-12-12 01:22:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (191, 22, 'Monthly Income & Expense Chart', 'monthly_income_expense_chart', 1, 0, 0, 0, '2018-12-12 01:25:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (192, 23, 'OPD Prescription Print Header Footer ', 'opd_prescription_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (196, 24, 'Bed', 'bed', 1, 1, 1, 1, '2018-12-12 01:46:01');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (197, 24, 'IPD Prescription Print Header Footer', 'ipd_prescription_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (198, 24, 'Bed Status', 'bed_status', 1, 0, 0, 0, '2018-12-12 01:39:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (200, 25, 'Medicine Bad Stock', 'medicine_bad_stock', 1, 1, 0, 1, '2018-12-17 16:12:46');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (201, 25, 'Pharmacy Bill print Header Footer', 'pharmacy_bill_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (202, 30, 'Blood Stock', 'blood_stock', 1, 1, 0, 1, '2021-09-11 00:49:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (203, 32, 'Charge Category', 'charge_category', 1, 1, 1, 1, '2018-12-12 02:19:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (206, 14, 'TPA Report', 'tpa_report', 1, 0, 0, 0, '2019-03-07 21:49:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (207, 14, 'Ambulance Report', 'ambulance_report', 1, 0, 0, 0, '2019-03-07 21:49:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (208, 14, 'Discharge Patient Report', 'discharge_patient_report', 1, 0, 0, 0, '2019-03-07 21:49:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (209, 14, 'Appointment Report', 'appointment_report', 1, 0, 0, 0, '2019-03-07 21:50:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (210, 14, 'Transaction Report', 'transaction_report', 1, 0, 0, 0, '2019-03-07 21:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (211, 14, 'Blood Issue Report', 'blood_issue_report', 1, 0, 0, 0, '2019-03-07 21:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (212, 14, 'Income Report', 'income_report', 1, 0, 0, 0, '2019-03-07 21:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (213, 14, 'Expense Report', 'expense_report', 1, 0, 0, 0, '2019-03-07 21:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (214, 34, 'Birth Record', 'birth_record', 1, 1, 1, 1, '2018-06-22 01:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (215, 34, 'Death Record', 'death_record', 1, 1, 1, 1, '2018-06-22 01:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (218, 23, 'Move Patient in IPD', 'opd_move_patient_in_ipd', 1, 0, 0, 0, '2021-09-16 23:00:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (219, 23, 'Manual Prescription', 'manual_prescription', 1, 0, 0, 0, '2019-09-22 19:52:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (220, 24, 'Prescription ', 'ipd_prescription', 1, 1, 1, 1, '2019-09-23 15:59:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (221, 23, 'Charges', 'opd_charges', 1, 1, 1, 1, '2019-09-22 19:58:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (222, 23, 'Payment', 'opd_payment', 1, 1, 1, 1, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (224, 25, 'Import Medicine', 'import_medicine', 1, 0, 0, 0, '2019-09-22 20:03:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (225, 25, 'Medicine Purchase', 'medicine_purchase', 1, 1, 0, 1, '2021-10-02 06:59:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (226, 25, 'Medicine Supplier', 'medicine_supplier', 1, 1, 1, 1, '2019-09-22 20:09:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (227, 25, 'Medicine Dosage', 'medicine_dosage', 1, 1, 1, 1, '2019-09-22 20:17:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (236, 36, 'Patient', 'patient', 1, 1, 1, 1, '2021-09-21 23:29:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (237, 36, 'Enabled/Disabled', 'enabled_disabled', 1, 0, 0, 0, '2019-09-22 21:25:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (238, 22, 'Notification Center', 'notification_center', 1, 0, 0, 0, '2019-09-23 18:48:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (239, 36, 'Import', 'patient_import', 1, 0, 0, 0, '2019-10-03 16:20:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (240, 34, 'Birth Print Header Footer', 'birth_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (242, 34, 'Death Print Header Footer', 'death_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (243, 26, 'Print Header Footer', 'pathology_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (244, 27, 'Print Header Footer', 'radiology_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (246, 30, 'Print Header Footer', 'bloodbank_print_header_footer', 1, 0, 0, 0, '2021-10-07 06:06:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (247, 29, 'Print Header Footer', 'ambulance_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (248, 24, 'IPD Bill Print Header Footer', 'ipd_bill_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (249, 18, 'Print Payslip Header Footer', 'print_payslip_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (250, 14, 'Income Group Report', 'income_group_report', 1, 0, 0, 0, '2020-08-11 20:52:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (251, 14, 'Expense Group Report', 'expense_group_report', 1, 0, 0, 0, '2019-10-03 19:15:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (253, 14, 'Inventory Stock Report', 'inventory_stock_report', 1, 0, 0, 0, '2019-10-03 20:20:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (254, 14, 'Inventory Item Report', 'add_item_report', 1, 0, 0, 0, '2019-10-03 20:23:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (255, 14, 'Inventory Issue Report', 'issue_inventory_report', 1, 0, 0, 0, '2019-10-03 20:24:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (256, 14, 'Expiry Medicine Report', 'expiry_medicine_report', 1, 0, 0, 0, '2019-10-03 21:00:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (257, 26, 'Pathology Bill', 'pathology_bill', 1, 1, 1, 1, '2021-02-25 03:58:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (258, 14, 'Birth Report', 'birth_report', 1, 0, 0, 0, '2019-10-13 18:12:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (259, 14, 'Death Report', 'death_report', 1, 0, 0, 0, '2019-10-13 18:13:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (260, 26, 'Pathology Unit', 'pathology_unit', 1, 1, 1, 1, '2020-07-21 16:13:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (261, 27, 'Radiology Unit', 'radiology_unit', 1, 1, 1, 1, '2020-07-21 16:14:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (262, 27, 'Radiology Parameter', 'radiology_parameter', 1, 1, 1, 1, '2020-07-21 16:20:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (263, 26, 'Pathology Parameter', 'pathology_parameter', 1, 1, 1, 1, '2020-07-21 16:20:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (264, 32, 'Charge Type', 'charge_type', 1, 1, 1, 1, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (265, 14, 'OPD Balance Report', 'opd_balance_report', 1, 0, 0, 0, '2020-07-27 17:03:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (266, 14, 'IPD Balance Report', 'ipd_balance_report', 1, 0, 0, 0, '2020-07-27 17:03:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (267, 15, 'Symptoms Type', 'symptoms_type', 1, 1, 1, 1, '2021-09-13 23:36:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (269, 37, 'Live Consultation', 'live_consultation', 1, 1, 0, 1, '2020-08-12 21:19:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (270, 37, 'Live Meeting', 'live_meeting', 1, 1, 0, 1, '2020-08-12 21:19:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (271, 14, 'Live Consultation Report', 'live_consultation_report', 1, 0, 0, 0, '2021-09-13 04:11:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (272, 14, 'Live Meeting Report', 'live_meeting_report', 1, 0, 0, 0, '2021-09-13 04:11:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (273, 37, 'Setting', 'setting', 1, 0, 1, 0, '2020-08-12 22:03:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (274, 15, 'Language Switcher', 'language_switcher', 1, 0, 0, 0, '2020-08-20 19:48:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (279, 15, 'Symptoms Head', 'symptoms_head', 1, 1, 1, 1, '2021-09-13 23:36:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (280, 18, 'Specialist', 'specialist', 1, 1, 1, 1, '2019-10-03 12:01:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (281, 22, 'General Income Widget', 'general_income_widget', 1, 0, 0, 0, '2018-12-19 18:38:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (282, 22, 'Expenses Widget', 'expenses_widget', 1, 0, 0, 0, '2018-12-19 18:38:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (283, 38, 'Referral Category', 'referral_category', 1, 1, 1, 1, '2021-06-11 04:54:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (284, 38, 'Referral Commission', 'referral_commission', 1, 1, 1, 1, '2021-06-11 04:54:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (285, 38, 'Referral Person', 'referral_person', 1, 1, 1, 1, '2021-06-11 04:55:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (286, 38, 'Referral Payment', 'referral_payment', 1, 1, 1, 1, '2021-06-11 04:55:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (287, 15, 'Prefix Setting', 'prefix_setting', 1, 0, 1, 0, '2021-06-11 22:46:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (288, 15, 'Captcha Setting', 'captcha_setting', 1, 0, 1, 0, '2021-06-11 23:43:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (289, 32, 'Tax Category', 'tax_category', 1, 1, 1, 1, '2021-06-12 00:16:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (290, 32, 'Unit Type', 'unit_type', 1, 1, 1, 1, '2021-06-12 00:16:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (291, 25, 'Dosage Interval', 'dosage_interval', 1, 1, 1, 1, '2021-06-12 02:15:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (292, 25, 'Dosage Duration', 'dosage_duration', 1, 1, 1, 1, '2021-06-12 02:15:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (293, 30, 'Blood Bank Product', 'blood_bank_product', 1, 1, 1, 1, '2021-06-12 02:51:23');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (294, 39, 'Slot', 'online_appointment_slot', 1, 1, 1, 1, '2021-09-14 03:04:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (295, 39, 'Doctor Shift', 'online_appointment_doctor_shift', 1, 0, 1, 0, '2021-06-12 03:43:48');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (296, 39, 'Shift', 'online_appointment_shift', 1, 1, 1, 1, '2021-06-12 03:24:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (297, 39, 'Doctor Wise Appointment', 'doctor_wise_appointment', 1, 0, 0, 0, '2021-10-07 03:45:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (298, 39, 'Patient Queue', 'patient_queue', 1, 0, 0, 0, '2021-10-07 03:45:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (299, 23, 'OPD Medication', 'opd_medication', 1, 1, 1, 1, '2021-06-14 22:00:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (300, 24, 'IPD Medication', 'ipd_medication', 1, 1, 1, 1, '2021-06-14 22:00:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (301, 24, 'Bed History', 'bed_history', 1, 0, 0, 0, '2021-06-14 22:00:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (302, 30, 'Blood Bank Components', 'blood_bank_components', 1, 1, 0, 1, '2021-06-15 02:46:48');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (303, 23, 'Operation Theatre', 'opd_operation_theatre', 1, 1, 1, 1, '2021-09-08 00:49:13');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (304, 23, 'Lab Investigation', 'opd_lab_investigation', 1, 0, 0, 0, '2021-09-06 21:36:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (305, 23, 'Patient Discharge', 'opd_patient_discharge', 1, 0, 1, 0, '2021-09-06 21:39:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (306, 23, 'Patient Discharge Revert', 'opd_patient_discharge_revert', 1, 0, 0, 0, '2021-09-06 21:39:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (307, 23, 'Treatment History', 'opd_treatment_history', 1, 0, 0, 0, '2021-09-06 21:49:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (308, 24, 'Lab Investigation', 'ipd_lab_investigation', 1, 0, 0, 0, '2021-09-06 22:45:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (309, 24, 'Patient Discharge', 'ipd_patient_discharge', 1, 0, 1, 0, '2021-09-07 00:08:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (310, 24, 'Patient Discharge Revert', 'ipd_patient_discharge_revert', 1, 0, 0, 0, '2021-09-07 00:14:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (311, 30, 'Issue Component', 'issue_component', 1, 1, 1, 1, '2021-09-07 00:21:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (312, 26, '	Add/Edit Collection Person', 'pathology_add_edit_collection_person', 1, 0, 1, 0, '2021-09-16 22:06:13');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (313, 25, 'Partial Payment', 'pharmacy_partial_payment', 1, 1, 0, 1, '2021-09-07 03:10:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (314, 26, 'Partial Payment', 'pathology_partial_payment', 1, 1, 0, 1, '2021-09-07 04:34:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (315, 27, 'Partial Payment', 'radiology_partial_payment', 1, 1, 0, 1, '2021-09-07 04:38:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (316, 28, 'Partial Payment', 'radiology_partial_payment', 1, 1, 0, 1, '2021-09-07 04:39:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (317, 30, 'Partial Payment', 'blood_bank_partial_payment', 1, 1, 0, 1, '2021-09-07 04:47:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (318, 29, 'Partial Payment', 'ambulance_partial_payment', 1, 1, 0, 1, '2021-09-07 04:48:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (319, 23, 'Checkup', 'checkup', 1, 1, 1, 1, '2021-09-16 22:40:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (320, 23, 'Print Bill', 'opd_print_bill', 1, 0, 0, 0, '2021-09-08 01:09:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (321, 23, 'Live Consult', 'opd_live_consult', 1, 0, 0, 0, '2021-09-08 02:53:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (322, 24, 'Nurse Note', 'nurse_note', 1, 1, 1, 1, '2021-09-08 03:20:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (323, 24, 'Bed Type', 'bed_type', 1, 1, 1, 1, '2021-09-08 22:06:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (324, 24, 'Bed Group', 'bed_group', 1, 1, 1, 1, '2021-09-08 22:07:08');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (325, 24, 'Floor', 'floor', 1, 1, 1, 1, '2021-09-08 22:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (326, 24, 'Operation Theatre', 'ipd_operation_theatre', 1, 1, 1, 1, '2021-09-09 00:38:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (327, 24, 'Live Consult', 'ipd_live_consultation', 1, 0, 0, 0, '2021-09-09 01:05:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (329, 24, 'Treatment History', 'ipd_treatment_history', 1, 0, 0, 0, '2021-09-06 22:45:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (330, 41, 'OPD Billing', 'opd_billing', 1, 0, 0, 0, '2021-09-09 02:33:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (331, 41, 'OPD Billing Payment', 'opd_billing_payment', 1, 1, 0, 0, '2021-09-09 03:10:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (332, 41, 'IPD Billing', 'ipd_billing', 1, 0, 0, 0, '2021-09-09 02:52:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (333, 41, 'IPD Billing Payment', 'ipd_billing_payment', 1, 1, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (334, 41, 'Pharmacy Billing', 'pharmacy_billing', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (335, 41, 'Pharmacy Billing Payment', 'pharmacy_billing_payment', 1, 1, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (336, 41, 'Pathology Billing', 'pathology_billing', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (337, 41, 'Pathology Billing Payment', 'pathology_billing_payment', 1, 1, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (338, 41, 'Radiology Billing', 'radiology_billing', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (339, 41, 'Radiology Billing Payment', 'radiology_billing_payment', 1, 1, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (340, 41, 'Blood Bank Billing', 'blood_bank_billing', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (341, 41, 'Blood Bank Billing Payment', 'blood_bank_billing_payment', 1, 1, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (342, 41, 'Ambulance Billing', 'ambulance_billing', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (343, 41, 'Ambulance Billing Payment', 'ambulance_billing_payment', 1, 1, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (344, 41, 'Generate Bill', 'generate_bill', 1, 0, 0, 0, '2021-09-09 22:36:09');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (345, 41, 'Generate Discharge Card', 'generate_discharge_card', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (346, 40, 'Online Appointment', 'online_appointment', 1, 0, 0, 0, '2021-09-09 04:15:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (347, 31, 'TPA Charges ', 'tpa_charges', 1, 0, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (348, 15, 'System Notification Setting', 'system_notification_setting', 1, 0, 1, 0, '2018-07-05 00:08:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (349, 14, 'All Transaction Report', 'all_transaction_report', 1, 0, 0, 0, '2021-09-13 04:29:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (350, 14, 'Patient Visit Report', 'patient_visit_report', 1, 0, 0, 0, '2019-10-03 20:23:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (351, 14, 'Patient Bill Report', 'patient_bill_report', 1, 0, 0, 0, '2019-10-03 19:15:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (352, 14, 'Referral Report', 'referral_report', 1, 0, 0, 0, '2019-10-03 19:15:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (353, 27, 'Add/Edit Collection Person', 'radiology_add_edit_collection_person', 1, 0, 1, 0, '2021-09-16 22:06:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (354, 27, 'Add/Edit  Report', 'radiology_add_edit_report', 1, 0, 1, 0, '2021-09-16 22:06:50');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (355, 26, 'Add/Edit Report', 'pathology_add_edit_report', 1, 0, 1, 0, '2021-09-16 22:06:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (362, 42, 'Generate Certificate', 'generate_certificate', 1, 0, 0, 0, '2021-09-20 18:48:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (363, 42, 'Certificate', 'certificate', 1, 1, 1, 1, '2021-09-20 18:48:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (364, 42, 'Generate Staff ID Card', 'generate_staff_id_card', 1, 0, 0, 0, '2021-09-20 18:56:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (365, 42, 'Staff ID Card', 'staff_id_card', 1, 1, 1, 1, '2021-09-20 18:56:09');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (366, 42, 'Generate Patient ID Card', 'generate_patient_id_card', 1, 0, 0, 0, '2021-09-21 01:13:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (367, 42, 'Patient ID Card', 'patient_id_card', 1, 1, 1, 1, '2021-09-20 18:54:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (369, 14, 'Component Issue Report', 'component_issue_report', 1, 0, 0, 0, '2019-03-07 21:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (370, 14, 'Audit Trail Report', 'audit_trail_report', 1, 0, 0, 0, '2021-09-28 03:08:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (371, 43, 'Chat', 'chat', 1, 0, 0, 0, '2021-10-07 07:05:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (372, 15, 'Custom Fields', 'custom_fields', 1, 0, 0, 0, '2021-10-29 09:41:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (373, 14, 'Daily Transaction Report', 'daily_transaction_report', 1, 0, 0, 0, '2021-10-29 09:42:08');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (374, 15, 'Operation', 'operation', 1, 1, 1, 1, '2021-10-29 09:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (375, 15, 'Operation Category', 'operation_category', 1, 1, 1, 1, '2021-10-29 09:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (386, 39, 'Appointment', 'appointment', 1, 1, 0, 1, '2021-12-24 11:36:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (387, 39, 'Reschedule', 'reschedule', 1, 0, 0, 0, '2021-12-24 11:36:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (388, 15, 'Finding', 'finding', 1, 1, 1, 1, '2021-10-29 09:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (389, 15, 'Finding Category', 'finding_category', 1, 1, 1, 1, '2021-10-29 09:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (390, 41, 'Appointment Billing', 'appointment_billing', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (391, 15, 'Vital', 'vital', 1, 1, 1, 1, '2021-10-29 09:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (392, 23, 'OPD Vitals', 'opd_vitals', 1, 1, 1, 1, '2018-12-20 00:37:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (393, 24, 'IPD Vitals', 'ipd_vitals', 1, 1, 1, 1, '2021-02-25 03:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (394, 24, 'Previous Obstetric History', 'ipd_previous_obstetric_history', 1, 1, 1, 1, '2021-02-25 03:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (395, 24, 'Postnatal History', 'ipd_postnatal_history', 1, 1, 1, 1, '2021-02-25 03:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (396, 24, 'Antenatal', 'ipd_antenatal', 1, 1, 1, 1, '2021-02-25 03:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (397, 39, 'Print Appointment Header Footer', 'print_appointment_header_footer', 1, 0, 0, 0, '2024-02-29 11:05:48');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (398, 23, 'Antenatal', 'opd_antenatal', 1, 1, 1, 1, '2024-03-11 13:24:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (399, 41, 'Payment Receipt Header Footer', 'payment_receipt_header_footer', 1, 0, 0, 0, '2024-02-29 12:44:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (400, 13, 'Send Credential', 'send_credential', 1, 0, 0, 0, '2024-02-29 12:44:43');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (401, 24, 'IPD Antenatal Finding Print Header Footer', 'ipd_antenatal_finding_print_header_footer', 1, 0, 0, 0, '2024-02-29 12:44:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (402, 23, 'OPD Antenatal Finding Print Header Footer ', 'opd_antenatal_finding_print_header_footer', 1, 0, 0, 0, '2024-02-29 12:44:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (403, 24, 'Discharge Summary Print Header Footer', 'discharge_summary_print_header_footer', 1, 0, 0, 0, '2024-02-29 12:44:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (404, 24, 'IPD Obstetric History Print Header Footer', 'ipd_obstetric_history_print_header_footer', 1, 0, 0, 0, '2024-02-29 12:44:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (405, 39, 'Appointment Priority', 'appointment_priority', 1, 1, 1, 1, '2021-06-12 03:24:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (406, 25, 'Unit', 'medicine_unit', 1, 1, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (407, 25, 'Company', 'medicine_company', 1, 1, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (408, 25, 'Medicine Group', 'medicine_group', 1, 1, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (409, 8, 'Content Share List', 'content_share_list', 1, 0, 0, 1, '2024-04-20 08:05:46');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (410, 8, 'Upload/Share Content', 'upload_share_content', 1, 1, 0, 1, '2024-04-20 08:41:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (411, 8, 'Generate URL', 'generate_url', 1, 0, 0, 0, '2024-04-20 08:41:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (412, 8, 'Share', 'share_content', 1, 0, 0, 0, '2024-04-20 08:41:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (413, 23, 'OPD Bill Print Header Footer', 'opd_bill_print_header_footer', 1, 0, 1, 0, '2024-05-01 14:39:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (414, 15, 'Attendance Setting', 'attendance_setting', 1, 0, 1, 0, '2018-07-05 00:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (415, 44, 'Duty Roster', 'duty_roster', 1, 0, 0, 0, '2018-07-05 00:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (416, 44, 'Shift', 'roster_shift', 1, 1, 1, 1, '2024-08-08 11:03:23');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (417, 44, 'Roster List', 'roster_list', 1, 1, 1, 1, '2018-07-05 00:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (418, 44, 'Roster Assign', 'roster_assign', 1, 1, 1, 1, '2018-07-05 00:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (419, 45, 'Annual Calendar', 'annual_calendar', 1, 1, 1, 1, '2018-07-05 00:08:35');


#
# TABLE STRUCTURE FOR: permission_group
#

DROP TABLE IF EXISTS `permission_group`;

CREATE TABLE `permission_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) NOT NULL,
  `is_active` int(11) DEFAULT 0,
  `system` int(11) NOT NULL,
  `sort_order` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_short_code` (`short_code`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (3, 'Income', 'income', 1, 0, '15.00', '2021-10-22 02:07:50');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (4, 'Expense', 'expense', 1, 0, '16.00', '2021-10-22 02:07:55');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (8, 'Download Center', 'download_center', 1, 0, '19.00', '2021-10-22 02:13:38');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (10, 'Inventory', 'inventory', 1, 0, '18.00', '2021-10-22 02:13:22');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (13, 'Messaging', 'communicate', 1, 0, '17.00', '2021-10-22 02:13:08');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (14, 'Reports', 'reports', 1, 1, '23.00', '2021-10-22 02:14:35');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (15, 'System Settings', 'system_settings', 1, 1, '24.00', '2021-10-22 02:16:02');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (16, 'Front CMS', 'front_cms', 1, 0, '21.00', '2025-06-24 15:29:34');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (17, 'Front Office', 'front_office', 1, 0, '10.00', '2021-10-22 02:05:56');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (18, 'Human Resource', 'human_resource', 1, 1, '12.00', '2021-10-22 02:06:27');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (21, 'Calendar To Do List', 'calendar_to_do_list', 1, 0, '28.00', '2021-10-22 02:22:27');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (22, 'Dashboard and Widgets', 'dashboard_and_widgets', 1, 1, '0.01', '2021-10-22 02:18:00');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (23, 'OPD', 'opd', 1, 0, '3.00', '2021-10-22 02:04:29');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (24, 'IPD', 'ipd', 0, 0, '4.00', '2025-06-23 10:31:02');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (25, 'Pharmacy', 'pharmacy', 0, 0, '5.00', '2025-06-23 10:31:06');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (26, 'Pathology', 'pathology', 0, 0, '6.00', '2025-06-23 10:31:11');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (27, 'Radiology', 'radiology', 0, 0, '7.00', '2025-06-23 10:31:16');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (29, 'Ambulance', 'ambulance', 0, 0, '9.00', '2025-06-23 10:31:24');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (30, 'Blood Bank', 'blood_bank', 0, 0, '8.00', '2025-06-23 10:31:20');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (31, 'TPA Management', 'tpa_management', 1, 0, '14.00', '2021-10-22 02:06:58');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (32, 'Hospital Charges', 'hospital_charges', 1, 1, '26.00', '2021-10-22 02:19:04');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (34, 'Birth Death Record', 'birth_death_report', 0, 0, '11.00', '2025-06-23 10:31:27');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (36, 'Patient', 'patient', 1, 0, '25.00', '2021-10-22 02:18:46');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (37, 'Live Consultation', 'live_consultation', 1, 0, '22.00', '2025-06-24 15:29:35');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (38, 'Referral', 'referral', 1, 0, '13.00', '2021-10-22 02:06:48');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (39, 'Appointment', 'appointment', 1, 0, '2.00', '2025-06-25 08:12:26');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (41, 'Billing', 'bill', 1, 0, '1.00', '2024-08-21 11:29:55');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (42, 'Certificate', 'certificate', 0, 0, '20.00', '2025-06-23 10:31:39');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (43, 'Chat', 'chat', 1, 0, '27.00', '2021-10-22 02:22:19');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (44, 'Duty Roster', 'duty_roster', 0, 0, '12.10', '2025-06-25 08:04:20');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (45, 'Annual Calendar', 'annual_calendar', 1, 0, '12.20', '2024-08-17 08:32:13');


#
# TABLE STRUCTURE FOR: permission_patient
#

DROP TABLE IF EXISTS `permission_patient`;

CREATE TABLE `permission_patient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permission_group_short_code` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `short_code` varchar(100) NOT NULL,
  `is_active` int(11) DEFAULT NULL,
  `system` int(11) NOT NULL,
  `sort_order` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_permission_group_short_code` (`permission_group_short_code`),
  KEY `index_name` (`name`),
  KEY `index_short_code` (`short_code`),
  KEY `index_is_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (1, 'appointment', 'My Appointments', 'my_appointments', 1, 0, '1.00', '2025-06-25 08:12:26');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (2, 'opd', 'OPD', 'opd', 1, 0, '2.00', '2021-09-27 15:17:21');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (3, 'ipd', 'IPD', 'ipd', 0, 0, '3.00', '2025-06-23 10:31:02');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (4, 'pharmacy', 'Pharmacy', 'pharmacy', 0, 0, '4.00', '2025-06-23 10:31:06');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (5, 'pathology', 'Pathology', 'pathology', 0, 0, '5.00', '2025-06-23 10:31:11');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (6, 'radiology', 'Radiology', 'radiology', 0, 0, '6.00', '2025-06-23 10:31:16');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (7, 'ambulance', 'Ambulance', 'ambulance', 0, 0, '7.00', '2025-06-23 10:31:24');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (8, 'blood_bank', 'Blood Bank', 'blood_bank', 0, 0, '8.00', '2025-06-23 10:31:20');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (9, 'live_consultation', 'Live Consultation', 'live_consultation', 1, 0, '9.00', '2025-06-24 15:29:35');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (10, 'calendar_to_do_list', 'Calendar To Do List', 'calendar_to_do_list', 1, 0, '11.00', '2021-10-04 11:07:25');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (11, 'chat', 'Chat', 'chat', 1, 0, '11.00', '2021-10-04 09:34:59');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (12, 'download_center', 'Download Center', 'download_center', 1, 0, '12.00', '2024-06-26 14:29:50');


#
# TABLE STRUCTURE FOR: pharmacy
#

DROP TABLE IF EXISTS `pharmacy`;

CREATE TABLE `pharmacy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_name` varchar(200) DEFAULT NULL,
  `medicine_category_id` int(11) DEFAULT NULL,
  `medicine_image` text NOT NULL,
  `medicine_company` varchar(100) DEFAULT NULL,
  `medicine_composition` varchar(100) DEFAULT NULL,
  `medicine_group` varchar(100) DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `min_level` varchar(50) DEFAULT NULL,
  `reorder_level` varchar(50) DEFAULT NULL,
  `vat` float DEFAULT NULL,
  `unit_packing` varchar(50) DEFAULT NULL,
  `vat_ac` varchar(50) DEFAULT NULL,
  `rack_number` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `medicine_category_id` (`medicine_category_id`),
  KEY `idx_medicine_name` (`medicine_name`),
  KEY `index_medicine_name` (`medicine_name`),
  KEY `index_medicine_company` (`medicine_company`),
  KEY `index_medicine_composition` (`medicine_composition`),
  KEY `index_medicine_group` (`medicine_group`),
  KEY `index_unit` (`unit`),
  KEY `index_min_level` (`min_level`),
  KEY `index_reorder_level` (`reorder_level`),
  KEY `index_vat` (`vat`),
  KEY `index_unit_packing` (`unit_packing`),
  KEY `index_vat_ac` (`vat_ac`),
  KEY `index_rack_number` (`rack_number`),
  CONSTRAINT `pharmacy_ibfk_1` FOREIGN KEY (`medicine_category_id`) REFERENCES `medicine_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: pharmacy_bill_basic
#

DROP TABLE IF EXISTS `pharmacy_bill_basic`;

CREATE TABLE `pharmacy_bill_basic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `ipd_prescription_basic_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `doctor_name` varchar(50) DEFAULT NULL,
  `file` varchar(200) NOT NULL,
  `total` float(10,2) DEFAULT 0.00,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `discount` float(10,2) DEFAULT 0.00,
  `tax_percentage` float(10,2) DEFAULT 0.00,
  `tax` float(10,2) DEFAULT 0.00,
  `net_amount` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `generated_by` (`generated_by`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `index_customer_name` (`customer_name`),
  KEY `index_customer_type` (`customer_type`),
  KEY `index_doctor_name` (`doctor_name`),
  KEY `index_total` (`total`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_discount` (`discount`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_tax` (`tax`),
  KEY `index_net_amount` (`net_amount`),
  CONSTRAINT `pharmacy_bill_basic_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pharmacy_bill_basic_ibfk_2` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pharmacy_bill_basic_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pharmacy_bill_basic_ibfk_4` FOREIGN KEY (`ipd_prescription_basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: pharmacy_bill_detail
#

DROP TABLE IF EXISTS `pharmacy_bill_detail`;

CREATE TABLE `pharmacy_bill_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pharmacy_bill_basic_id` int(11) DEFAULT NULL,
  `medicine_batch_detail_id` int(11) DEFAULT NULL,
  `quantity` varchar(100) NOT NULL,
  `sale_price` float(10,2) NOT NULL,
  `amount` float(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `pharmacy_bill_basic_id` (`pharmacy_bill_basic_id`),
  KEY `medicine_batch_detail_id` (`medicine_batch_detail_id`),
  KEY `index_quantity` (`quantity`),
  KEY `index_sale_price` (`sale_price`),
  KEY `index_amount` (`amount`),
  CONSTRAINT `pharmacy_bill_detail_ibfk_1` FOREIGN KEY (`pharmacy_bill_basic_id`) REFERENCES `pharmacy_bill_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pharmacy_bill_detail_ibfk_2` FOREIGN KEY (`medicine_batch_detail_id`) REFERENCES `medicine_batch_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: pharmacy_company
#

DROP TABLE IF EXISTS `pharmacy_company`;

CREATE TABLE `pharmacy_company` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_company_name` (`company_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: postnatal_examine
#

DROP TABLE IF EXISTS `postnatal_examine`;

CREATE TABLE `postnatal_examine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `labor_time` datetime NOT NULL,
  `delivery_time` datetime NOT NULL,
  `routine_question` text NOT NULL,
  `general_remark` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `index_labor_time` (`labor_time`),
  KEY `index_delivery_time` (`delivery_time`),
  CONSTRAINT `postnatal_examine_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: prefixes
#

DROP TABLE IF EXISTS `prefixes`;

CREATE TABLE `prefixes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `prefix` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_type` (`type`),
  KEY `index_prefix` (`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (1, 'ipd_no', 'IPDN', '2021-06-30 19:40:23');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (2, 'opd_no', 'OPDN', '2021-02-22 15:38:01');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (3, 'ipd_prescription', 'IPDP', '2021-02-12 20:42:07');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (4, 'opd_prescription', 'OPDP', '2021-02-12 20:42:17');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (5, 'appointment', 'APPN', '2021-10-22 07:37:43');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (6, 'pharmacy_billing', 'PHAB', '2021-10-22 07:37:43');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (7, 'operation_theater_reference_no', 'OTRN', '2021-10-22 07:37:43');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (8, 'blood_bank_billing', 'BLBB', '2021-10-22 07:40:38');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (9, 'ambulance_call_billing', 'AMCB', '2021-10-22 07:40:38');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (10, 'radiology_billing', 'RADB', '2021-10-22 07:40:38');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (11, 'pathology_billing', 'PATB', '2021-10-22 07:40:38');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (12, 'checkup_id', 'OCID', '2021-10-22 07:44:25');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (13, 'purchase_no', 'PHPN', '2021-10-22 07:44:25');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (14, 'transaction_id', 'TRID', '2021-10-22 07:44:25');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (15, 'birth_record_reference_no', 'BRRN', '2021-10-22 07:44:25');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (16, 'death_record_reference_no', 'DRRN', '2021-10-22 07:44:25');


#
# TABLE STRUCTURE FOR: primary_examine
#

DROP TABLE IF EXISTS `primary_examine`;

CREATE TABLE `primary_examine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipdid` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `bleeding` varchar(250) DEFAULT NULL,
  `headache` varchar(250) DEFAULT NULL,
  `pain` varchar(250) DEFAULT NULL,
  `constipation` varchar(250) DEFAULT NULL,
  `urinary_symptoms` varchar(250) NOT NULL,
  `vomiting` varchar(250) DEFAULT NULL,
  `cough` varchar(250) DEFAULT NULL,
  `vaginal` varchar(250) DEFAULT NULL,
  `discharge` varchar(250) DEFAULT NULL,
  `oedema` varchar(250) DEFAULT NULL,
  `haemoroids` varchar(250) DEFAULT NULL,
  `weight` varchar(250) NOT NULL,
  `height` varchar(11) NOT NULL,
  `date` datetime DEFAULT NULL,
  `general_condition` text NOT NULL,
  `finding_remark` varchar(250) NOT NULL,
  `pelvic_examination` text NOT NULL,
  `sp` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipdid` (`ipdid`),
  KEY `index_bleeding` (`bleeding`),
  KEY `index_headache` (`headache`),
  KEY `index_pain` (`pain`),
  KEY `index_constipation` (`constipation`),
  KEY `index_urinary_symptoms` (`urinary_symptoms`),
  KEY `index_vomiting` (`vomiting`),
  KEY `index_cough` (`cough`),
  KEY `index_vaginal` (`vaginal`),
  KEY `index_discharge` (`discharge`),
  KEY `index_oedema` (`oedema`),
  KEY `index_haemoroids` (`haemoroids`),
  KEY `index_weight` (`weight`),
  KEY `index_height` (`height`),
  KEY `index_date` (`date`),
  CONSTRAINT `primary_examine_ibfk_1` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `primary_examine_ibfk_2` FOREIGN KEY (`ipdid`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: print_setting
#

DROP TABLE IF EXISTS `print_setting`;

CREATE TABLE `print_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `print_header` text NOT NULL,
  `print_footer` text NOT NULL,
  `setting_for` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (1, 'uploads/printing/1.jpg', '', 'opdpre', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (2, 'uploads/printing/2.jpg', '', 'opd', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (3, 'uploads/printing/3.jpg', '', 'ipdpres', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (4, 'uploads/printing/4.jpg', '', 'ipd', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (5, 'uploads/printing/5.jpg', '', 'bill', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (6, 'uploads/printing/6.jpg', '', 'pharmacy', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (7, 'uploads/printing/7.jpg', '', 'payslip', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (8, 'uploads/printing/8.jpg', '', 'paymentreceipt', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (9, 'uploads/printing/9.jpg', '', 'birth', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (10, 'uploads/printing/10.jpg', '', 'death', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (11, 'uploads/printing/11.jpg', '', 'pathology', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (12, 'uploads/printing/12.jpg', '', 'radiology', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (13, 'uploads/printing/13.jpg', '', 'ot', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (14, 'uploads/printing/14.jpg', '', 'bloodbank', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (15, 'uploads/printing/15.jpg', '', 'ambulance', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (16, 'uploads/printing/16.jpg', '', 'discharge_card', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (17, 'uploads/printing/17.jpg', '', 'obstetric_history', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (18, 'uploads/printing/18.jpg', '', 'opd_antenatal_finding', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (19, 'uploads/printing/19.jpg', '', 'ipd_antenatal_finding', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (20, 'uploads/printing/20.jpg', '', 'appointment', 'yes', '2021-09-25 08:44:20');


#
# TABLE STRUCTURE FOR: radio
#

DROP TABLE IF EXISTS `radio`;

CREATE TABLE `radio` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_name` varchar(255) DEFAULT NULL,
  `short_name` varchar(100) DEFAULT NULL,
  `test_type` varchar(100) DEFAULT NULL,
  `radiology_category_id` int(11) DEFAULT NULL,
  `sub_category` varchar(50) NOT NULL,
  `report_days` varchar(50) NOT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_id` (`charge_id`),
  KEY `index_test_name` (`test_name`),
  KEY `index_short_name` (`short_name`),
  KEY `index_test_type` (`test_type`),
  CONSTRAINT `radio_ibfk_1` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: radiology_billing
#

DROP TABLE IF EXISTS `radiology_billing`;

CREATE TABLE `radiology_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `ipd_prescription_basic_id` int(11) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `doctor_name` varchar(100) NOT NULL,
  `total` float(10,2) NOT NULL,
  `discount_percentage` float(10,2) NOT NULL,
  `discount` float(10,2) NOT NULL,
  `tax_percentage` float(10,2) NOT NULL,
  `tax` float(10,2) NOT NULL,
  `net_amount` float(10,2) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `doctor_id` (`doctor_id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `generated_by` (`generated_by`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `index_date` (`date`),
  KEY `index_doctor_name` (`doctor_name`),
  KEY `index_total` (`total`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_discount` (`discount`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_tax` (`tax`),
  KEY `index_net_amount` (`net_amount`),
  KEY `index_transaction_id` (`transaction_id`),
  KEY `index_organisation_id` (`organisation_id`),
  KEY `index_insurance_validity` (`insurance_validity`),
  KEY `index_insurance_id` (`insurance_id`),
  CONSTRAINT `radiology_billing_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_billing_ibfk_2` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_billing_ibfk_3` FOREIGN KEY (`doctor_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_billing_ibfk_4` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_billing_ibfk_5` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE SET NULL,
  CONSTRAINT `radiology_billing_ibfk_6` FOREIGN KEY (`ipd_prescription_basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_billing_ibfk_7` FOREIGN KEY (`organisation_id`) REFERENCES `organisation` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: radiology_parameter
#

DROP TABLE IF EXISTS `radiology_parameter`;

CREATE TABLE `radiology_parameter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parameter_name` varchar(100) NOT NULL,
  `test_value` varchar(100) NOT NULL,
  `reference_range` varchar(100) NOT NULL,
  `range_from` varchar(500) DEFAULT NULL,
  `range_to` varchar(500) DEFAULT NULL,
  `gender` varchar(100) NOT NULL,
  `unit` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_parameter_name` (`parameter_name`),
  KEY `index_test_value` (`test_value`),
  KEY `index_reference_range` (`reference_range`),
  KEY `index_range_from` (`range_from`),
  KEY `index_range_to` (`range_to`),
  KEY `index_gender` (`gender`),
  KEY `index_unit` (`unit`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: radiology_parameterdetails
#

DROP TABLE IF EXISTS `radiology_parameterdetails`;

CREATE TABLE `radiology_parameterdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `radiology_id` int(11) DEFAULT NULL,
  `radiology_parameter_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `radiology_id` (`radiology_id`),
  KEY `radiology_parameter_id` (`radiology_parameter_id`),
  CONSTRAINT `radiology_parameterdetails_ibfk_1` FOREIGN KEY (`radiology_id`) REFERENCES `radio` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_parameterdetails_ibfk_2` FOREIGN KEY (`radiology_parameter_id`) REFERENCES `radiology_parameter` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: radiology_report
#

DROP TABLE IF EXISTS `radiology_report`;

CREATE TABLE `radiology_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `radiology_bill_id` int(11) DEFAULT NULL,
  `radiology_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `consultant_doctor` varchar(10) NOT NULL,
  `reporting_date` date DEFAULT NULL,
  `parameter_update` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `radiology_report` text DEFAULT NULL,
  `report_name` text DEFAULT NULL,
  `radiology_result` text DEFAULT NULL COMMENT 'test result',
  `tax_percentage` float(10,2) NOT NULL DEFAULT 0.00,
  `apply_charge` float(10,2) NOT NULL DEFAULT 0.00,
  `radiology_center` varchar(250) NOT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `collection_specialist` int(11) DEFAULT NULL,
  `collection_date` date DEFAULT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `radiology_id` (`radiology_id`),
  KEY `radiology_bill_id` (`radiology_bill_id`),
  KEY `patient_id` (`patient_id`),
  KEY `generated_by` (`generated_by`),
  KEY `collection_specialist` (`collection_specialist`),
  KEY `approved_by` (`approved_by`),
  KEY `index_customer_type` (`customer_type`),
  KEY `index_patient_name` (`patient_name`),
  KEY `index_consultant_doctor` (`consultant_doctor`),
  KEY `index_reporting_date` (`reporting_date`),
  KEY `index_parameter_update` (`parameter_update`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_apply_charge` (`apply_charge`),
  KEY `index_radiology_center` (`radiology_center`),
  CONSTRAINT `radiology_report_ibfk_1` FOREIGN KEY (`radiology_id`) REFERENCES `radio` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_report_ibfk_2` FOREIGN KEY (`radiology_bill_id`) REFERENCES `radiology_billing` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_report_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_report_ibfk_4` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_report_ibfk_5` FOREIGN KEY (`collection_specialist`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_report_ibfk_6` FOREIGN KEY (`approved_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: radiology_report_parameterdetails
#

DROP TABLE IF EXISTS `radiology_report_parameterdetails`;

CREATE TABLE `radiology_report_parameterdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `radiology_report_id` int(11) DEFAULT NULL,
  `radiology_parameterdetail_id` int(11) DEFAULT NULL,
  `radiology_report_value` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `radiology_report_id` (`radiology_report_id`),
  KEY `radiology_parameterdetail_id` (`radiology_parameterdetail_id`),
  CONSTRAINT `radiology_report_parameterdetails_ibfk_1` FOREIGN KEY (`radiology_report_id`) REFERENCES `radiology_report` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_report_parameterdetails_ibfk_2` FOREIGN KEY (`radiology_parameterdetail_id`) REFERENCES `radiology_parameterdetails` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: read_notification
#

DROP TABLE IF EXISTS `read_notification`;

CREATE TABLE `read_notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `notification_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `read_notification_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: read_systemnotification
#

DROP TABLE IF EXISTS `read_systemnotification`;

CREATE TABLE `read_systemnotification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_id` int(11) DEFAULT NULL,
  `receiver_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `notification_id` (`notification_id`),
  CONSTRAINT `read_systemnotification_ibfk_1` FOREIGN KEY (`notification_id`) REFERENCES `system_notification` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (1, 43, 1, 'no', '2025-07-01 17:01:18');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (2, 43, 1, 'no', '2025-07-01 17:01:19');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (3, 10, 1, 'no', '2025-07-01 17:16:05');


#
# TABLE STRUCTURE FOR: referral_category
#

DROP TABLE IF EXISTS `referral_category`;

CREATE TABLE `referral_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: referral_commission
#

DROP TABLE IF EXISTS `referral_commission`;

CREATE TABLE `referral_commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `referral_category_id` int(11) DEFAULT NULL,
  `referral_type_id` int(11) DEFAULT NULL,
  `commission` float DEFAULT NULL,
  `is_active` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `referral_category_id` (`referral_category_id`),
  KEY `referral_type_id` (`referral_type_id`),
  CONSTRAINT `referral_commission_ibfk_1` FOREIGN KEY (`referral_category_id`) REFERENCES `referral_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `referral_commission_ibfk_2` FOREIGN KEY (`referral_type_id`) REFERENCES `referral_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: referral_payment
#

DROP TABLE IF EXISTS `referral_payment`;

CREATE TABLE `referral_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `referral_person_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `referral_type` int(11) DEFAULT NULL,
  `billing_id` int(11) NOT NULL,
  `bill_amount` float(10,2) DEFAULT 0.00,
  `percentage` float(10,2) DEFAULT 0.00,
  `amount` float(10,2) DEFAULT 0.00,
  `date` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `referral_person_id` (`referral_person_id`),
  KEY `referral_type` (`referral_type`),
  KEY `index_bill_amount` (`bill_amount`),
  KEY `index_percentage` (`percentage`),
  KEY `index_amount` (`amount`),
  KEY `index_date` (`date`),
  CONSTRAINT `referral_payment_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `referral_payment_ibfk_2` FOREIGN KEY (`referral_person_id`) REFERENCES `referral_person` (`id`) ON DELETE CASCADE,
  CONSTRAINT `referral_payment_ibfk_3` FOREIGN KEY (`referral_type`) REFERENCES `referral_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: referral_person
#

DROP TABLE IF EXISTS `referral_person`;

CREATE TABLE `referral_person` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `contact` varchar(20) DEFAULT NULL,
  `person_name` varchar(100) DEFAULT NULL,
  `person_phone` varchar(50) DEFAULT NULL,
  `standard_commission` float(10,2) NOT NULL DEFAULT 0.00,
  `address` varchar(100) DEFAULT NULL,
  `is_active` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `referral_category` (`category_id`),
  KEY `index_name` (`name`),
  KEY `index_contact` (`contact`),
  KEY `index_person_name` (`person_name`),
  KEY `index_person_phone` (`person_phone`),
  KEY `index_standard_commission` (`standard_commission`),
  CONSTRAINT `referral_person_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `referral_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: referral_person_commission
#

DROP TABLE IF EXISTS `referral_person_commission`;

CREATE TABLE `referral_person_commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `referral_person_id` int(11) DEFAULT NULL,
  `referral_type_id` int(11) DEFAULT NULL,
  `commission` float(10,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `referral_person_id` (`referral_person_id`),
  KEY `referral_type_id` (`referral_type_id`),
  CONSTRAINT `referral_person_commission_ibfk_1` FOREIGN KEY (`referral_person_id`) REFERENCES `referral_person` (`id`) ON DELETE CASCADE,
  CONSTRAINT `referral_person_commission_ibfk_2` FOREIGN KEY (`referral_type_id`) REFERENCES `referral_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: referral_type
#

DROP TABLE IF EXISTS `referral_type`;

CREATE TABLE `referral_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `prefixes_type` varchar(100) NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`name`),
  KEY `index_prefixes_type` (`prefixes_type`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (1, 'opd', 'opd_no', 1, '2021-09-17 04:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (2, 'ipd', 'ipd_no', 1, '2021-09-17 04:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (3, 'pharmacy', 'pharmacy_billing', 1, '2021-09-17 04:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (4, 'pathology', 'pathology_billing', 1, '2021-09-17 04:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (5, 'radiology', 'radiology_billing', 1, '2021-09-17 04:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (6, 'blood_bank', 'blood_bank_billing', 1, '2021-09-17 04:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (7, 'ambulance', 'ambulance_call_billing', 1, '2021-09-17 04:07:51');


#
# TABLE STRUCTURE FOR: roles
#

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `slug` varchar(150) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `is_system` int(11) NOT NULL DEFAULT 0,
  `is_superadmin` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (1, 'Admin', NULL, 0, 1, 0, '2018-12-25 08:19:43');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (2, 'Accountant', NULL, 0, 1, 0, '2018-12-25 08:19:38');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (3, 'Doctor', NULL, 0, 1, 0, '2018-07-21 07:07:36');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (4, 'Pharmacist', NULL, 0, 1, 0, '2018-07-21 07:08:26');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (5, 'Pathologist', NULL, 0, 1, 0, '2018-12-25 08:19:59');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (6, 'Radiologist', NULL, 0, 1, 0, '2018-12-25 08:20:27');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (7, 'Super Admin', NULL, 0, 1, 1, '2018-12-25 08:22:24');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (8, 'Receptionist', NULL, 0, 1, 0, '2018-12-25 08:20:22');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (9, 'Nurse', NULL, 0, 1, 0, '2020-12-23 03:58:58');


#
# TABLE STRUCTURE FOR: roles_permissions
#

DROP TABLE IF EXISTS `roles_permissions`;

CREATE TABLE `roles_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) DEFAULT NULL,
  `perm_cat_id` int(11) DEFAULT NULL,
  `can_view` int(11) DEFAULT NULL,
  `can_add` int(11) DEFAULT NULL,
  `can_edit` int(11) DEFAULT NULL,
  `can_delete` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_can_view` (`can_view`),
  KEY `index_can_add` (`can_add`),
  KEY `index_can_edit` (`can_edit`),
  KEY `index_can_delete` (`can_delete`),
  KEY `role_id` (`role_id`),
  KEY `perm_cat_id` (`perm_cat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2332 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1, 1, 346, 1, 0, 0, 0, '2021-09-15 04:19:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2, 1, 80, 1, 1, 1, 1, '2021-09-15 04:31:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (3, 1, 81, 1, 1, 1, 1, '2021-09-15 04:31:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (4, 1, 82, 1, 1, 1, 1, '2021-09-15 04:31:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (5, 1, 83, 1, 1, 1, 1, '2021-09-15 04:31:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (6, 1, 84, 1, 1, 1, 1, '2021-09-15 04:31:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (7, 1, 85, 1, 1, 1, 1, '2021-09-15 04:31:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (8, 1, 204, 1, 1, 1, 1, '2021-09-15 04:22:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (9, 1, 205, 1, 0, 0, 0, '2021-09-15 04:20:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (10, 1, 216, 1, 0, 0, 0, '2021-09-15 04:20:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (11, 1, 217, 1, 0, 0, 0, '2021-09-15 04:20:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (14, 1, 237, 1, 0, 0, 0, '2021-09-15 04:25:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (15, 1, 239, 1, 0, 0, 0, '2021-09-15 04:25:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (16, 1, 214, 1, 1, 1, 1, '2021-09-15 04:35:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (17, 1, 215, 1, 1, 1, 1, '2021-09-15 04:35:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (18, 1, 240, 1, 0, 1, 0, '2021-09-15 04:35:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (19, 1, 242, 1, 0, 1, 0, '2021-09-15 04:35:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (36, 1, 48, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (37, 1, 89, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (38, 1, 91, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (39, 1, 178, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (40, 1, 179, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (41, 1, 180, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (42, 1, 181, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (43, 1, 182, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (44, 1, 183, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (45, 1, 184, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (46, 1, 185, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (47, 1, 187, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (48, 1, 188, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (49, 1, 189, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (50, 1, 206, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (51, 1, 207, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (52, 1, 208, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (53, 1, 209, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (54, 1, 210, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (55, 1, 211, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (56, 1, 212, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (57, 1, 213, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (58, 1, 250, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (59, 1, 251, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (60, 1, 253, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (61, 1, 254, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (62, 1, 255, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (63, 1, 256, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (64, 1, 258, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (65, 1, 259, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (66, 1, 265, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (67, 1, 266, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (68, 1, 271, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (69, 1, 272, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (70, 1, 349, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (71, 1, 350, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (72, 1, 351, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (73, 1, 352, 1, 0, 0, 0, '2021-09-15 20:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (78, 1, 12, 1, 1, 1, 1, '2021-09-17 23:55:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (79, 1, 13, 1, 1, 1, 1, '2021-09-17 23:55:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (81, 1, 134, 1, 1, 1, 1, '2021-10-07 06:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (84, 1, 192, 1, 0, 1, 0, '2021-10-07 06:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (105, 1, 140, 1, 1, 1, 1, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (106, 1, 142, 1, 1, 1, 1, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (114, 1, 300, 1, 1, 1, 1, '2021-09-17 00:16:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (117, 1, 309, 1, 0, 1, 0, '2021-09-17 00:16:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (119, 1, 322, 1, 1, 1, 1, '2021-09-17 00:16:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (125, 1, 170, 1, 1, 1, 1, '2021-09-17 21:38:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (127, 1, 201, 1, 0, 1, 0, '2021-09-16 01:45:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (131, 1, 227, 1, 1, 1, 1, '2021-09-17 21:10:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (132, 1, 291, 1, 1, 1, 1, '2021-09-17 21:10:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (133, 1, 292, 1, 1, 1, 1, '2021-09-17 21:10:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (142, 1, 317, 1, 1, 0, 1, '2021-09-15 22:15:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (143, 1, 269, 1, 1, 0, 1, '2021-09-15 22:16:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (144, 1, 270, 1, 1, 0, 1, '2021-09-15 22:16:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (149, 1, 54, 1, 0, 1, 0, '2021-10-07 02:37:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (150, 1, 56, 1, 0, 1, 0, '2021-10-07 02:37:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (151, 1, 57, 1, 0, 1, 0, '2021-09-15 22:53:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (152, 1, 58, 1, 0, 1, 0, '2021-09-15 22:53:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (153, 1, 59, 1, 0, 1, 0, '2021-09-15 22:53:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (154, 1, 60, 1, 0, 1, 0, '2021-09-15 22:53:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (155, 1, 126, 1, 0, 0, 0, '2021-09-15 22:53:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (156, 1, 130, 1, 1, 0, 1, '2021-09-15 22:53:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (157, 1, 131, 1, 0, 0, 0, '2021-09-15 22:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (158, 1, 267, 1, 1, 1, 1, '2021-09-15 22:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (159, 1, 274, 1, 0, 0, 0, '2021-09-15 22:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (160, 1, 279, 1, 1, 1, 1, '2021-09-15 22:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (161, 1, 287, 1, 0, 1, 0, '2021-09-15 22:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (162, 1, 288, 1, 0, 1, 0, '2021-09-15 22:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (163, 1, 348, 1, 0, 1, 0, '2021-09-15 22:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (164, 1, 61, 1, 1, 0, 1, '2021-10-07 06:57:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (165, 1, 62, 1, 1, 0, 1, '2021-10-07 06:57:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (166, 1, 63, 1, 1, 0, 1, '2021-10-07 06:57:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (167, 1, 64, 1, 1, 1, 1, '2021-10-07 06:57:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (168, 1, 65, 1, 1, 1, 1, '2021-10-07 06:57:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (169, 1, 66, 1, 1, 1, 1, '2021-10-07 06:57:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (170, 1, 67, 1, 1, 1, 1, '2021-10-07 06:57:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (171, 1, 43, 1, 1, 1, 1, '2021-09-15 23:54:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (172, 1, 44, 1, 0, 0, 0, '2021-09-15 23:53:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (175, 1, 283, 1, 1, 1, 1, '2021-09-18 00:22:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (176, 1, 284, 1, 1, 1, 1, '2021-09-18 00:22:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (177, 1, 285, 1, 1, 1, 1, '2021-09-18 00:22:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (178, 1, 286, 1, 1, 1, 1, '2021-09-18 00:22:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (181, 1, 146, 1, 1, 1, 1, '2021-09-17 04:03:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (182, 1, 148, 1, 1, 1, 1, '2021-09-17 04:03:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (184, 1, 86, 1, 1, 1, 1, '2021-09-18 01:02:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (192, 1, 127, 1, 0, 0, 0, '2021-09-16 02:46:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (193, 1, 118, 1, 0, 0, 0, '2021-09-16 02:59:08');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (194, 1, 152, 1, 1, 1, 1, '2021-09-17 01:30:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (195, 1, 153, 1, 1, 1, 1, '2021-09-16 21:14:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (197, 1, 354, 1, 0, 1, 0, '2021-09-17 21:42:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (199, 1, 261, 1, 1, 1, 1, '2021-09-17 21:42:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (200, 1, 262, 1, 1, 1, 1, '2021-09-17 21:42:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (201, 1, 315, 1, 1, 0, 1, '2021-09-17 21:42:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (202, 1, 244, 1, 0, 1, 0, '2021-09-16 22:29:17');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (221, 1, 138, 1, 1, 1, 1, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (222, 1, 139, 1, 1, 1, 1, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (223, 1, 143, 1, 1, 1, 1, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (224, 1, 144, 1, 1, 0, 1, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (226, 1, 197, 1, 0, 1, 0, '2021-09-17 04:01:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (228, 1, 248, 1, 0, 1, 0, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (229, 1, 301, 1, 0, 0, 0, '2021-09-17 00:16:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (230, 1, 308, 1, 0, 0, 0, '2021-09-17 00:16:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (236, 1, 149, 1, 1, 1, 1, '2021-10-22 02:28:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (237, 1, 175, 1, 1, 1, 1, '2021-10-22 02:28:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (238, 1, 243, 1, 0, 1, 0, '2021-10-22 02:28:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (239, 1, 257, 1, 1, 1, 1, '2021-10-22 02:28:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (243, 1, 314, 1, 1, 0, 1, '2021-10-22 02:28:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (245, 1, 310, 1, 0, 0, 0, '2021-09-17 00:29:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (247, 1, 355, 1, 0, 1, 0, '2021-10-22 02:28:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (248, 1, 260, 1, 1, 1, 1, '2021-10-22 02:28:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (249, 1, 263, 1, 1, 1, 1, '2021-10-22 02:28:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (250, 1, 312, 1, 0, 1, 0, '2021-10-22 02:28:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (254, 1, 135, 1, 1, 1, 1, '2021-10-07 06:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (255, 1, 137, 1, 1, 1, 1, '2021-10-07 06:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (257, 1, 219, 1, 0, 0, 0, '2021-09-17 03:09:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (258, 1, 221, 1, 1, 1, 1, '2021-09-18 02:55:57');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (259, 1, 222, 1, 1, 0, 1, '2021-09-17 03:13:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (260, 1, 299, 1, 1, 1, 1, '2021-09-17 03:14:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (261, 1, 303, 1, 1, 1, 1, '2021-09-17 03:17:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (262, 1, 304, 1, 0, 0, 0, '2021-09-17 03:21:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (263, 1, 305, 1, 0, 1, 0, '2021-09-17 03:22:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (264, 1, 306, 1, 0, 0, 0, '2021-09-17 03:22:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (265, 1, 307, 1, 0, 0, 0, '2021-09-17 03:23:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (266, 1, 319, 1, 1, 1, 1, '2021-10-07 07:01:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (274, 1, 220, 1, 1, 1, 1, '2021-09-17 04:02:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (275, 1, 326, 1, 1, 1, 1, '2021-09-17 20:09:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (276, 1, 200, 1, 1, 0, 1, '2021-09-17 20:59:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (277, 1, 225, 1, 1, 1, 1, '2021-09-17 21:10:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (278, 1, 226, 1, 1, 1, 1, '2021-09-17 21:10:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (279, 1, 224, 1, 0, 0, 0, '2021-09-17 21:38:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (280, 1, 313, 1, 1, 0, 1, '2021-09-17 21:39:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (281, 1, 171, 1, 1, 1, 1, '2021-09-17 21:46:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (282, 1, 353, 1, 0, 1, 0, '2021-09-17 21:46:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (283, 1, 168, 1, 1, 1, 1, '2021-09-17 22:14:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (284, 1, 169, 1, 1, 1, 1, '2021-09-17 22:16:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (285, 1, 311, 1, 1, 1, 1, '2021-09-17 22:24:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (286, 1, 246, 1, 1, 1, 1, '2021-09-17 22:26:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (287, 1, 202, 1, 1, 0, 1, '2021-09-17 22:30:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (288, 1, 293, 1, 1, 1, 1, '2021-09-17 22:30:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (289, 1, 302, 1, 1, 0, 1, '2021-09-17 22:30:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (290, 1, 173, 1, 1, 1, 1, '2021-09-17 22:36:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (291, 1, 347, 1, 0, 1, 1, '2021-09-17 22:36:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (292, 1, 273, 1, 0, 1, 0, '2021-09-17 23:43:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (293, 1, 9, 1, 1, 1, 1, '2021-09-17 23:47:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (294, 1, 10, 1, 1, 1, 1, '2021-09-17 23:47:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (295, 1, 176, 1, 1, 1, 1, '2021-09-21 01:45:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (296, 1, 102, 1, 1, 1, 1, '2021-10-07 07:04:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (297, 1, 31, 1, 1, 0, 1, '2021-10-07 02:40:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (298, 1, 32, 1, 1, 1, 1, '2021-09-18 00:47:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (299, 1, 33, 1, 1, 1, 1, '2021-09-18 00:47:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (300, 1, 34, 1, 1, 1, 1, '2021-09-18 00:47:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (301, 1, 35, 1, 1, 1, 1, '2021-09-18 00:47:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (302, 1, 104, 1, 1, 1, 1, '2021-09-18 00:47:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (303, 1, 87, 1, 0, 0, 0, '2021-09-18 01:01:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (304, 1, 88, 1, 1, 1, 0, '2021-09-18 01:33:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (305, 1, 90, 1, 1, 0, 1, '2021-09-18 01:34:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (306, 1, 108, 1, 1, 1, 1, '2021-09-18 01:37:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (307, 1, 109, 1, 1, 0, 1, '2021-09-18 01:39:39');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (308, 1, 110, 1, 1, 1, 1, '2021-10-07 06:56:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (309, 1, 111, 1, 1, 1, 1, '2021-10-07 06:56:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (310, 1, 112, 1, 1, 1, 1, '2021-10-07 06:56:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (311, 1, 249, 1, 1, 1, 1, '2021-10-07 06:56:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (313, 1, 203, 1, 1, 1, 1, '2021-09-18 01:08:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (314, 1, 264, 1, 1, 0, 1, '2021-09-18 01:08:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (315, 1, 289, 1, 1, 1, 1, '2021-09-18 01:08:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (316, 1, 290, 1, 1, 1, 1, '2021-09-18 01:08:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (317, 1, 165, 1, 1, 1, 1, '2021-09-18 01:23:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (318, 1, 166, 1, 1, 1, 1, '2021-09-18 01:23:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (319, 1, 247, 1, 1, 1, 1, '2021-09-18 01:23:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (320, 1, 318, 1, 1, 0, 1, '2021-09-18 01:23:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (324, 2, 237, 1, 0, 0, 0, '2021-09-18 03:01:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (327, 2, 135, 1, 1, 1, 0, '2021-10-07 03:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (334, 2, 221, 1, 1, 1, 1, '2021-09-18 03:25:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (335, 2, 222, 1, 1, 0, 1, '2021-09-18 03:26:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (336, 2, 299, 1, 0, 0, 0, '2021-10-07 03:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (337, 2, 303, 1, 0, 0, 0, '2021-10-07 03:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (339, 2, 305, 1, 0, 1, 0, '2021-09-18 03:38:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (341, 2, 307, 1, 0, 0, 0, '2021-09-18 03:43:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (343, 2, 320, 1, 0, 0, 0, '2021-09-18 03:44:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (346, 2, 138, 1, 1, 1, 0, '2021-10-07 03:02:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (350, 2, 143, 1, 1, 1, 1, '2021-09-20 01:54:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (351, 2, 144, 1, 1, 0, 1, '2021-09-20 01:54:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (354, 2, 329, 1, 0, 0, 0, '2021-09-18 04:23:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (356, 2, 326, 1, 0, 0, 0, '2021-10-07 07:33:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (357, 3, 132, 1, 1, 1, 1, '2021-09-21 22:39:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (358, 3, 134, 1, 1, 1, 1, '2021-09-19 21:30:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (362, 3, 135, 1, 1, 1, 1, '2021-09-19 21:45:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (363, 3, 137, 1, 1, 1, 1, '2021-09-19 21:45:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (364, 3, 192, 1, 0, 1, 0, '2021-09-19 21:46:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (372, 1, 295, 1, 0, 1, 0, '2021-10-07 06:56:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (373, 3, 218, 1, 0, 0, 0, '2021-09-19 23:47:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (374, 3, 219, 1, 0, 0, 0, '2021-09-19 23:48:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (375, 3, 221, 1, 1, 1, 1, '2021-09-19 23:48:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (376, 3, 222, 1, 1, 0, 1, '2021-09-19 23:51:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (377, 3, 299, 1, 1, 1, 1, '2021-09-19 23:53:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (378, 3, 303, 1, 1, 1, 1, '2021-09-20 00:05:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (379, 2, 139, 1, 1, 1, 0, '2021-10-07 03:02:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (380, 3, 304, 1, 0, 0, 0, '2021-09-20 00:21:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (382, 3, 305, 1, 0, 1, 0, '2021-09-20 00:23:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (384, 2, 198, 1, 0, 0, 0, '2021-09-20 00:24:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (386, 2, 300, 1, 1, 1, 1, '2021-09-20 01:54:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (387, 2, 301, 1, 0, 0, 0, '2021-09-20 00:24:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (388, 2, 308, 1, 0, 0, 0, '2021-09-20 00:24:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (389, 2, 309, 1, 0, 0, 0, '2021-09-20 00:24:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (391, 2, 323, 1, 1, 1, 1, '2021-09-20 01:54:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (392, 2, 324, 1, 1, 1, 1, '2021-09-20 01:54:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (393, 2, 325, 1, 1, 1, 1, '2021-09-20 01:54:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (394, 3, 306, 1, 0, 0, 0, '2021-09-20 00:24:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (395, 3, 307, 1, 0, 0, 0, '2021-09-20 00:26:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (396, 3, 319, 1, 1, 1, 1, '2021-09-20 00:27:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (397, 3, 320, 1, 0, 0, 0, '2021-09-20 00:38:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (398, 3, 321, 1, 0, 0, 0, '2021-09-20 00:46:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (399, 3, 138, 1, 1, 1, 1, '2021-09-20 00:47:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (400, 3, 139, 1, 1, 1, 1, '2021-09-20 00:50:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (401, 3, 140, 1, 1, 1, 1, '2021-09-20 00:51:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (402, 3, 142, 1, 1, 1, 1, '2021-09-20 00:51:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (403, 3, 143, 1, 1, 1, 1, '2021-09-20 00:51:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (404, 3, 144, 1, 1, 0, 1, '2021-09-20 00:52:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (405, 3, 196, 1, 1, 1, 1, '2021-09-20 00:56:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (406, 3, 197, 1, 0, 1, 0, '2021-09-20 00:57:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (407, 3, 198, 1, 0, 0, 0, '2021-09-20 00:57:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (408, 3, 220, 1, 1, 1, 1, '2021-09-20 00:57:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (409, 3, 248, 1, 0, 1, 0, '2021-09-20 00:58:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (410, 3, 300, 1, 1, 1, 1, '2021-09-20 00:58:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (411, 3, 301, 1, 0, 0, 0, '2021-09-20 00:59:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (412, 3, 308, 1, 0, 0, 0, '2021-09-20 00:59:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (413, 3, 309, 1, 0, 1, 0, '2021-09-20 01:00:17');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (414, 3, 310, 1, 0, 0, 0, '2021-09-20 01:00:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (415, 3, 322, 1, 1, 1, 1, '2021-09-20 01:01:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (416, 3, 323, 1, 1, 1, 1, '2021-09-20 01:02:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (417, 3, 324, 1, 1, 1, 1, '2021-09-20 01:02:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (418, 3, 325, 1, 1, 1, 1, '2021-09-20 01:02:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (419, 3, 326, 1, 1, 1, 1, '2021-09-20 01:03:57');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (420, 3, 327, 1, 0, 0, 0, '2021-09-20 01:10:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (421, 3, 329, 1, 0, 0, 0, '2021-09-20 01:10:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (422, 3, 146, 1, 0, 0, 0, '2021-09-21 23:58:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (424, 2, 327, 1, 0, 0, 0, '2021-09-20 01:14:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (425, 3, 236, 1, 1, 1, 1, '2021-10-07 04:00:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (433, 3, 226, 1, 0, 0, 0, '2021-09-20 21:02:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (435, 3, 291, 1, 0, 0, 0, '2021-09-20 21:02:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (436, 3, 292, 1, 0, 0, 0, '2021-09-20 21:02:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (438, 3, 149, 1, 0, 0, 0, '2021-10-07 03:50:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (444, 3, 312, 1, 0, 0, 0, '2021-10-07 03:50:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (447, 2, 149, 1, 0, 0, 0, '2021-10-07 03:17:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (453, 2, 312, 1, 0, 1, 0, '2021-09-20 02:04:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (454, 2, 314, 1, 1, 0, 1, '2021-09-22 21:32:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (455, 2, 355, 1, 0, 1, 0, '2021-09-20 02:04:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (456, 3, 152, 1, 0, 0, 0, '2021-10-07 03:50:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (463, 3, 353, 1, 0, 0, 0, '2021-10-07 03:50:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (465, 2, 152, 1, 0, 0, 0, '2021-10-07 03:21:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (466, 2, 153, 1, 0, 0, 0, '2021-10-07 03:22:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (472, 2, 353, 1, 0, 1, 0, '2021-09-20 02:34:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (474, 3, 168, 1, 0, 0, 0, '2021-10-07 03:56:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (475, 2, 146, 1, 0, 0, 0, '2021-10-07 03:12:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (476, 2, 148, 1, 0, 0, 0, '2021-10-07 03:12:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (478, 2, 200, 1, 0, 0, 0, '2021-10-07 03:14:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (481, 2, 225, 1, 0, 0, 0, '2021-10-07 03:14:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (484, 2, 291, 1, 1, 0, 0, '2021-10-07 07:33:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (485, 2, 292, 1, 1, 0, 0, '2021-10-07 07:33:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (486, 2, 313, 1, 1, 0, 0, '2021-10-07 07:33:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (495, 3, 270, 1, 1, 0, 1, '2021-09-20 03:25:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (496, 2, 168, 1, 0, 0, 0, '2021-10-07 03:24:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (498, 2, 202, 1, 0, 0, 0, '2021-10-07 03:24:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (500, 2, 293, 1, 0, 0, 0, '2021-10-07 03:25:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (501, 2, 302, 1, 0, 0, 0, '2021-10-07 03:25:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (502, 2, 311, 1, 0, 0, 0, '2021-10-07 03:25:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (503, 2, 317, 1, 1, 0, 1, '2021-09-21 04:02:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (504, 3, 102, 1, 1, 1, 1, '2021-09-20 03:26:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (506, 3, 118, 1, 0, 0, 0, '2021-09-20 03:29:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (519, 3, 173, 1, 0, 0, 0, '2021-10-07 03:56:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (520, 3, 347, 1, 0, 0, 0, '2021-10-07 03:56:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (527, 3, 176, 1, 0, 0, 0, '2021-10-07 04:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (530, 3, 289, 1, 0, 0, 0, '2021-10-07 04:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (531, 3, 290, 1, 0, 0, 0, '2021-10-07 04:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (533, 3, 330, 1, 0, 0, 0, '2021-09-20 03:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (534, 3, 331, 1, 0, 0, 0, '2021-10-07 07:42:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (535, 3, 332, 1, 0, 0, 0, '2021-09-20 03:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (536, 3, 333, 1, 0, 0, 0, '2021-09-20 03:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (537, 3, 334, 1, 0, 0, 0, '2021-09-20 03:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (538, 3, 335, 1, 0, 0, 0, '2021-10-07 04:00:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (539, 3, 336, 1, 0, 0, 0, '2021-09-20 03:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (540, 3, 337, 1, 0, 0, 0, '2021-09-20 03:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (541, 3, 338, 1, 0, 0, 0, '2021-09-20 03:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (542, 3, 339, 1, 0, 0, 0, '2021-10-07 04:00:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (543, 3, 340, 1, 0, 0, 0, '2021-09-20 03:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (544, 3, 341, 1, 0, 0, 0, '2021-09-21 04:32:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (545, 3, 342, 1, 0, 0, 0, '2021-09-20 03:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (546, 3, 343, 1, 0, 0, 0, '2021-09-20 03:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (547, 3, 344, 1, 0, 0, 0, '2021-09-20 03:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (548, 3, 345, 1, 0, 0, 0, '2021-09-20 03:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (550, 3, 166, 1, 0, 0, 0, '2021-09-21 03:50:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (565, 3, 204, 1, 1, 1, 1, '2021-09-20 20:43:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (566, 3, 205, 1, 0, 0, 0, '2021-09-20 04:08:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (567, 3, 216, 1, 0, 0, 0, '2021-09-20 04:08:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (568, 3, 217, 1, 0, 0, 0, '2021-09-20 04:08:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (573, 3, 214, 1, 1, 1, 1, '2021-09-20 04:18:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (574, 3, 215, 1, 1, 1, 1, '2021-09-20 04:18:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (577, 3, 294, 1, 1, 1, 1, '2021-10-07 07:43:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (578, 3, 295, 1, 0, 1, 0, '2021-09-21 01:39:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (579, 3, 296, 1, 1, 1, 1, '2021-09-21 01:39:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (580, 3, 297, 1, 0, 0, 0, '2021-10-07 07:43:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (581, 3, 298, 1, 0, 0, 0, '2021-10-07 07:43:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (584, 2, 165, 1, 0, 0, 0, '2021-10-07 07:35:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (585, 2, 166, 1, 0, 0, 0, '2021-10-07 03:35:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (594, 2, 204, 1, 1, 1, 1, '2021-09-20 20:35:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (596, 2, 216, 1, 0, 0, 0, '2021-09-20 20:14:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (597, 2, 217, 1, 0, 0, 0, '2021-09-20 20:14:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (607, 2, 294, 1, 1, 1, 1, '2021-09-20 22:46:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (608, 2, 295, 1, 0, 1, 0, '2021-09-20 21:50:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (609, 2, 296, 1, 1, 1, 1, '2021-09-20 22:46:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (610, 2, 297, 1, 0, 1, 0, '2021-09-20 21:50:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (611, 2, 298, 1, 0, 1, 0, '2021-09-20 21:50:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (612, 2, 102, 1, 1, 1, 1, '2021-10-07 03:46:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (614, 2, 304, 1, 0, 0, 0, '2021-09-20 22:11:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (619, 3, 302, 1, 0, 0, 0, '2021-10-07 03:56:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (620, 3, 311, 1, 0, 0, 0, '2021-10-07 03:56:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (624, 3, 269, 1, 1, 0, 1, '2021-09-20 22:50:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (626, 2, 176, 1, 1, 1, 1, '2021-09-20 22:55:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (627, 2, 203, 1, 1, 1, 1, '2021-09-20 22:55:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (629, 2, 289, 1, 1, 1, 1, '2021-09-20 22:55:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (630, 2, 290, 1, 1, 1, 1, '2021-09-20 22:55:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (631, 2, 9, 1, 1, 1, 1, '2021-10-07 03:27:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (632, 2, 10, 1, 1, 1, 1, '2021-10-07 03:27:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (633, 2, 12, 1, 1, 1, 1, '2021-09-20 23:09:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (634, 2, 13, 1, 1, 1, 1, '2021-09-22 21:19:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (639, 2, 330, 1, 0, 0, 0, '2021-09-21 00:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (640, 2, 331, 1, 1, 0, 0, '2021-09-21 00:53:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (641, 2, 332, 1, 0, 0, 0, '2021-09-21 00:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (642, 2, 333, 1, 1, 0, 0, '2021-09-21 00:53:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (643, 2, 334, 1, 0, 0, 0, '2021-09-21 00:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (644, 2, 335, 1, 1, 0, 0, '2021-09-21 03:52:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (646, 2, 337, 1, 1, 0, 0, '2021-09-21 21:15:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (647, 2, 338, 1, 0, 0, 0, '2021-09-21 00:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (648, 2, 339, 1, 1, 0, 0, '2021-09-21 02:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (649, 2, 340, 1, 0, 0, 0, '2021-09-21 00:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (650, 2, 341, 1, 1, 0, 0, '2021-09-22 21:19:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (651, 2, 342, 1, 0, 0, 0, '2021-09-21 00:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (652, 2, 343, 1, 1, 0, 0, '2021-09-22 21:19:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (653, 2, 344, 1, 0, 0, 0, '2021-09-21 00:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (654, 2, 345, 1, 0, 0, 0, '2021-09-21 00:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (655, 2, 48, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (658, 2, 178, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (659, 2, 179, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (660, 2, 180, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (661, 2, 181, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (662, 2, 182, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (667, 2, 188, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (668, 2, 189, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (669, 2, 206, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (670, 2, 207, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (671, 2, 208, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (672, 2, 209, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (673, 2, 210, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (675, 2, 212, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (676, 2, 213, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (677, 2, 250, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (678, 2, 251, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (679, 2, 253, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (680, 2, 254, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (681, 2, 255, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (687, 2, 271, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (688, 2, 272, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (689, 2, 349, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (690, 2, 350, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (691, 2, 351, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (692, 2, 352, 1, 0, 0, 0, '2021-09-21 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (693, 3, 86, 1, 0, 0, 0, '2021-10-07 04:07:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (695, 2, 43, 1, 1, 1, 1, '2021-09-21 02:07:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (696, 2, 44, 1, 0, 0, 0, '2021-09-21 01:59:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (700, 3, 109, 1, 1, 0, 1, '2021-10-07 04:07:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (703, 2, 27, 1, 1, 0, 1, '2021-09-21 02:22:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (706, 2, 31, 1, 1, 0, 1, '2021-09-21 02:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (707, 2, 32, 1, 1, 1, 1, '2021-09-21 02:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (708, 2, 33, 1, 1, 1, 1, '2021-09-21 02:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (709, 2, 34, 1, 1, 1, 1, '2021-09-21 02:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (710, 2, 35, 1, 1, 1, 1, '2021-09-21 02:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (711, 2, 104, 1, 1, 1, 1, '2021-09-21 02:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (712, 2, 315, 1, 1, 0, 1, '2021-09-22 21:34:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (726, 3, 43, 1, 1, 1, 1, '2021-09-21 03:03:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (727, 3, 44, 1, 0, 0, 0, '2021-09-21 03:03:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (728, 3, 27, 1, 1, 0, 1, '2021-09-21 03:12:55');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (735, 3, 165, 1, 0, 0, 0, '2021-10-07 04:02:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (750, 3, 267, 1, 1, 1, 1, '2021-09-21 03:47:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (751, 3, 274, 1, 0, 0, 0, '2021-09-21 03:45:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (752, 3, 279, 1, 1, 1, 1, '2021-09-21 03:47:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (757, 2, 86, 1, 1, 1, 1, '2021-09-21 22:06:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (764, 2, 283, 1, 1, 1, 1, '2021-09-22 03:07:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (765, 2, 284, 1, 1, 1, 1, '2021-09-22 03:07:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (766, 2, 285, 1, 1, 1, 1, '2021-09-22 03:07:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (767, 2, 286, 1, 1, 1, 1, '2021-09-22 03:07:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (768, 3, 48, 1, 0, 0, 0, '2021-09-21 04:12:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (771, 3, 178, 1, 0, 0, 0, '2021-09-21 04:12:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (775, 3, 182, 1, 0, 0, 0, '2021-09-21 04:12:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (801, 3, 272, 1, 0, 0, 0, '2021-09-21 04:12:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (806, 2, 88, 1, 0, 0, 0, '2021-10-07 07:36:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (807, 2, 90, 1, 0, 0, 0, '2021-10-07 07:36:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (809, 2, 109, 1, 1, 0, 1, '2021-09-27 08:57:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (814, 2, 249, 1, 1, 1, 1, '2021-09-22 03:43:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (816, 2, 310, 1, 0, 0, 0, '2021-09-21 20:00:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (817, 2, 129, 0, 1, 0, 1, '2021-09-22 03:43:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (819, 1, 362, 1, 0, 0, 0, '2021-09-21 20:50:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (820, 1, 363, 1, 1, 1, 1, '2021-09-21 21:07:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (821, 1, 364, 1, 0, 0, 0, '2021-09-21 20:59:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (822, 1, 365, 1, 1, 1, 1, '2021-09-21 21:03:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (823, 1, 366, 1, 0, 0, 0, '2021-09-21 20:59:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (826, 2, 132, 1, 1, 1, 0, '2021-10-07 03:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (849, 2, 319, 1, 0, 0, 0, '2021-10-07 07:31:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (870, 3, 368, 1, 0, 0, 0, '2021-09-21 22:33:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (924, 8, 152, 1, 0, 0, 0, '2021-10-07 06:04:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (927, 4, 270, 1, 0, 0, 0, '2021-10-07 04:27:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (948, 4, 334, 1, 0, 0, 0, '2021-09-22 01:56:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (949, 4, 335, 1, 1, 0, 0, '2021-09-30 08:47:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (962, 4, 176, 1, 1, 1, 1, '2021-10-07 07:52:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (963, 4, 203, 1, 1, 1, 1, '2021-10-07 07:52:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (965, 4, 289, 1, 1, 1, 1, '2021-09-30 09:32:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (966, 4, 290, 1, 1, 1, 1, '2021-09-30 09:32:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (983, 4, 216, 1, 0, 0, 0, '2021-09-22 02:25:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (984, 4, 217, 1, 0, 0, 0, '2021-09-22 02:34:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (990, 4, 86, 1, 0, 0, 0, '2021-10-07 04:37:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (995, 4, 109, 1, 1, 0, 1, '2021-10-01 02:27:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1001, 2, 118, 1, 0, 0, 0, '2021-09-22 02:55:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1016, 4, 43, 1, 1, 1, 1, '2021-09-22 03:04:08');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1017, 4, 44, 1, 0, 0, 0, '2021-09-22 03:04:08');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1018, 4, 27, 1, 1, 0, 1, '2021-09-22 03:12:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1060, 4, 179, 1, 0, 0, 0, '2021-09-22 03:51:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1099, 2, 336, 1, 0, 0, 0, '2021-09-22 21:19:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1119, 1, 367, 1, 1, 1, 1, '2021-10-07 07:04:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1134, 9, 102, 1, 1, 1, 1, '2021-09-22 22:44:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1136, 9, 132, 1, 0, 0, 0, '2021-10-07 06:18:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1137, 9, 134, 1, 0, 0, 0, '2021-10-07 06:18:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1138, 9, 135, 1, 0, 0, 0, '2021-10-07 06:18:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1141, 9, 218, 1, 0, 0, 0, '2021-09-22 22:46:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1142, 9, 219, 1, 0, 0, 0, '2021-09-22 22:46:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1145, 9, 299, 1, 1, 1, 1, '2021-09-23 00:31:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1146, 9, 303, 1, 0, 0, 0, '2021-10-07 06:24:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1147, 9, 304, 1, 0, 0, 0, '2021-09-22 22:46:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1148, 9, 305, 1, 0, 0, 0, '2021-10-07 06:25:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1150, 9, 307, 1, 0, 0, 0, '2021-09-22 22:46:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1151, 9, 319, 1, 0, 0, 0, '2021-10-07 06:25:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1165, 5, 308, 1, 0, 0, 0, '2021-09-22 22:57:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1175, 5, 329, 1, 0, 0, 0, '2021-09-23 00:14:39');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1188, 1, 53, 1, 1, 0, 0, '2021-09-23 01:24:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1189, 5, 149, 1, 1, 1, 1, '2021-09-23 00:40:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1190, 5, 175, 1, 1, 1, 1, '2021-09-23 00:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1191, 5, 243, 1, 0, 1, 0, '2021-09-23 00:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1193, 5, 260, 1, 1, 1, 1, '2021-09-23 00:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1194, 5, 263, 1, 1, 1, 1, '2021-09-23 00:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1195, 5, 312, 1, 0, 1, 0, '2021-09-23 00:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1196, 5, 314, 1, 1, 0, 1, '2021-09-23 00:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1197, 5, 355, 1, 0, 1, 0, '2021-09-23 00:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1204, 9, 138, 1, 0, 0, 0, '2021-10-07 06:51:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1205, 9, 139, 1, 0, 0, 0, '2021-10-07 06:51:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1206, 9, 140, 1, 1, 1, 1, '2021-10-23 06:56:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1207, 9, 142, 1, 1, 1, 1, '2021-10-23 06:56:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1210, 9, 196, 1, 0, 0, 0, '2021-10-07 06:27:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1212, 9, 198, 1, 0, 0, 0, '2021-09-23 01:19:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1213, 9, 220, 1, 0, 0, 0, '2021-10-07 06:27:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1215, 9, 300, 1, 1, 1, 1, '2021-09-23 03:24:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1216, 9, 301, 1, 0, 0, 0, '2021-09-23 01:19:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1217, 9, 308, 1, 0, 0, 0, '2021-09-23 01:19:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1218, 9, 309, 1, 0, 0, 0, '2021-10-07 06:27:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1220, 9, 322, 1, 1, 1, 1, '2021-09-23 03:24:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1224, 9, 326, 1, 0, 0, 0, '2021-10-07 06:27:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1225, 9, 327, 1, 0, 0, 0, '2021-09-23 01:19:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1226, 9, 329, 1, 0, 0, 0, '2021-09-23 01:19:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1235, 1, 191, 1, 0, 0, 0, '2021-09-23 01:49:17');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1246, 5, 317, 1, 1, 0, 1, '2021-09-23 02:16:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1248, 5, 270, 1, 0, 0, 0, '2021-10-07 05:23:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1250, 5, 102, 1, 1, 1, 1, '2021-09-23 02:32:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1251, 5, 346, 1, 0, 0, 0, '2021-09-23 02:32:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1269, 5, 337, 1, 1, 0, 0, '2021-09-23 03:31:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1278, 5, 236, 1, 0, 0, 0, '2021-10-07 05:26:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1306, 5, 216, 1, 0, 0, 0, '2021-09-23 03:40:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1307, 5, 217, 1, 0, 0, 0, '2021-09-23 03:40:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1317, 5, 86, 1, 0, 0, 0, '2021-10-07 05:29:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1322, 5, 109, 1, 1, 0, 1, '2021-09-23 21:36:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1329, 5, 43, 1, 1, 1, 1, '2021-09-30 02:45:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1330, 5, 44, 1, 0, 0, 0, '2021-09-23 04:12:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1331, 5, 27, 1, 1, 0, 1, '2021-09-23 04:15:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1355, 9, 270, 1, 0, 0, 0, '2021-10-07 08:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1358, 9, 236, 1, 0, 0, 0, '2021-10-07 06:42:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1370, 5, 158, 1, 0, 0, 0, '2021-09-23 21:44:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1416, 5, 369, 1, 0, 0, 0, '2021-09-23 22:16:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1426, 5, 180, 1, 0, 0, 0, '2021-09-23 22:23:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1460, 6, 270, 1, 0, 0, 0, '2021-10-07 05:38:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1503, 6, 304, 1, 0, 0, 0, '2021-09-27 02:19:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1509, 6, 319, 1, 0, 0, 0, '2021-10-07 08:03:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1518, 9, 216, 1, 0, 0, 0, '2021-09-27 02:45:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1519, 9, 217, 1, 0, 0, 0, '2021-09-27 02:45:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1579, 2, 155, 1, 0, 0, 0, '2021-09-27 07:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1580, 2, 156, 1, 0, 0, 0, '2021-09-27 07:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1581, 2, 157, 1, 0, 0, 0, '2021-09-27 07:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1582, 2, 158, 1, 0, 0, 0, '2021-09-27 07:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1583, 2, 159, 1, 0, 0, 0, '2021-09-27 07:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1584, 2, 161, 1, 0, 0, 0, '2021-09-27 07:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1585, 2, 162, 1, 0, 0, 0, '2021-09-27 07:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1586, 2, 190, 1, 0, 0, 0, '2021-09-27 07:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1587, 2, 191, 1, 0, 0, 0, '2021-09-27 07:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1588, 2, 238, 1, 0, 0, 0, '2021-09-27 07:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1596, 9, 48, 1, 0, 0, 0, '2021-09-27 08:56:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1599, 9, 178, 1, 0, 0, 0, '2021-09-27 08:56:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1603, 9, 182, 1, 0, 0, 0, '2021-09-27 08:56:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1631, 9, 350, 1, 0, 0, 0, '2021-09-27 08:56:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1663, 9, 27, 1, 0, 0, 0, '2021-10-23 06:59:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1664, 9, 43, 1, 1, 1, 1, '2021-09-28 03:25:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1665, 9, 44, 1, 0, 0, 0, '2021-09-28 03:20:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1666, 9, 86, 1, 0, 0, 0, '2021-10-07 06:46:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1671, 9, 109, 1, 1, 0, 1, '2021-09-28 03:58:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1679, 9, 204, 1, 1, 1, 1, '2021-09-28 05:31:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1680, 9, 205, 1, 0, 0, 0, '2021-09-28 05:31:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1697, 6, 152, 1, 1, 1, 1, '2021-09-28 07:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1698, 6, 153, 1, 1, 1, 1, '2021-09-28 07:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1699, 6, 171, 1, 1, 1, 1, '2021-09-28 07:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1700, 6, 244, 1, 0, 1, 0, '2021-09-28 07:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1701, 6, 261, 1, 1, 1, 1, '2021-09-28 07:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1702, 6, 262, 1, 1, 1, 1, '2021-09-28 07:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1703, 6, 315, 1, 1, 0, 1, '2021-09-28 07:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1704, 6, 353, 1, 0, 1, 0, '2021-09-28 07:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1705, 6, 354, 1, 0, 1, 0, '2021-09-28 07:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1713, 6, 236, 1, 0, 0, 0, '2021-10-07 05:46:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1716, 6, 176, 1, 1, 1, 1, '2021-10-07 08:04:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1719, 6, 289, 1, 1, 1, 1, '2021-09-28 08:47:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1720, 6, 290, 1, 1, 1, 1, '2021-09-28 08:47:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1739, 6, 43, 1, 1, 1, 1, '2021-09-28 09:53:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1740, 6, 44, 1, 0, 0, 0, '2021-09-28 09:51:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1741, 6, 27, 1, 1, 0, 1, '2021-09-28 09:57:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1742, 6, 118, 1, 0, 0, 0, '2021-09-28 09:59:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1747, 6, 159, 1, 0, 0, 0, '2021-09-28 09:59:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1782, 2, 205, 1, 0, 0, 0, '2021-09-29 05:01:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1823, 6, 338, 1, 0, 0, 0, '2021-09-29 07:47:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1824, 6, 339, 1, 1, 0, 0, '2021-09-29 08:07:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1831, 2, 318, 1, 1, 0, 1, '2021-09-29 08:26:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1838, 6, 181, 1, 0, 0, 0, '2021-09-29 08:27:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1872, 6, 102, 1, 1, 1, 1, '2021-09-29 08:31:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1873, 6, 86, 1, 0, 0, 0, '2021-10-07 05:48:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1878, 6, 109, 1, 1, 0, 1, '2021-09-29 09:05:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1900, 6, 329, 1, 0, 0, 0, '2021-09-29 09:59:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1906, 5, 370, 1, 0, 0, 0, '2021-09-30 04:11:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1908, 4, 146, 1, 1, 1, 1, '2021-10-07 04:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1909, 4, 148, 1, 1, 1, 1, '2021-10-07 04:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1910, 4, 170, 1, 1, 1, 1, '2021-10-07 04:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1911, 4, 200, 1, 1, 0, 1, '2021-10-07 04:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1912, 4, 201, 1, 0, 1, 0, '2021-09-30 07:42:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1913, 4, 224, 1, 0, 0, 0, '2021-09-30 07:36:57');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1914, 4, 225, 1, 1, 0, 1, '2021-10-07 04:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1915, 4, 226, 1, 1, 1, 1, '2021-10-07 04:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1916, 4, 227, 1, 1, 1, 1, '2021-10-07 04:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1917, 4, 291, 1, 1, 1, 1, '2021-10-07 04:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1918, 4, 292, 1, 1, 1, 1, '2021-10-07 04:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1919, 4, 313, 1, 1, 0, 1, '2021-10-07 04:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1931, 4, 236, 1, 0, 0, 0, '2021-10-07 04:30:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1934, 4, 118, 1, 0, 0, 0, '2021-10-01 02:51:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1937, 4, 157, 1, 0, 0, 0, '2021-10-01 02:51:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1944, 4, 238, 1, 0, 0, 0, '2021-10-01 02:51:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1957, 4, 256, 1, 0, 0, 0, '2021-10-01 02:54:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1976, 4, 102, 1, 1, 1, 1, '2021-10-01 03:33:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1977, 4, 274, 1, 0, 0, 0, '2021-10-01 03:36:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1980, 9, 137, 1, 1, 1, 1, '2021-10-23 06:54:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1981, 2, 173, 1, 1, 1, 1, '2021-10-07 07:34:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1982, 2, 347, 1, 0, 1, 1, '2021-10-07 07:34:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1995, 1, 196, 1, 1, 1, 1, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1996, 1, 323, 1, 1, 1, 1, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1997, 1, 324, 1, 1, 1, 1, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1998, 1, 325, 1, 1, 1, 1, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1999, 1, 236, 1, 1, 1, 1, '2021-10-07 02:36:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2001, 2, 270, 1, 0, 0, 0, '2021-10-07 03:25:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2002, 2, 236, 1, 1, 1, 0, '2021-10-07 03:28:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2003, 2, 266, 1, 0, 0, 0, '2021-10-07 03:43:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2019, 8, 132, 1, 1, 1, 1, '2021-10-07 06:00:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2020, 8, 135, 1, 1, 1, 1, '2021-10-07 06:00:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2022, 8, 219, 1, 0, 0, 0, '2021-10-07 06:00:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2023, 8, 221, 1, 0, 0, 0, '2025-07-02 18:48:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2025, 8, 138, 1, 1, 1, 1, '2021-10-07 06:00:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2026, 8, 139, 1, 1, 1, 1, '2021-10-07 06:00:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2027, 8, 143, 1, 1, 1, 1, '2021-10-07 08:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2028, 8, 144, 1, 1, 0, 1, '2021-10-07 08:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2029, 8, 326, 1, 0, 0, 0, '2021-10-07 06:01:17');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2031, 8, 196, 1, 1, 1, 1, '2021-10-07 08:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2032, 8, 198, 1, 0, 0, 0, '2021-10-07 06:03:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2034, 4, 202, 1, 0, 0, 0, '2021-10-07 06:03:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2035, 8, 146, 1, 0, 0, 0, '2021-10-07 06:03:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2036, 8, 148, 1, 0, 0, 0, '2021-10-07 06:03:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2037, 8, 200, 1, 0, 0, 0, '2021-10-07 06:03:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2038, 8, 225, 1, 0, 0, 0, '2021-10-07 06:03:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2039, 8, 149, 1, 0, 0, 0, '2021-10-07 06:04:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2042, 8, 168, 1, 0, 0, 0, '2021-10-07 06:04:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2043, 8, 270, 1, 0, 0, 0, '2021-10-07 06:05:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2044, 8, 173, 1, 0, 0, 0, '2021-10-07 06:06:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2045, 8, 347, 1, 0, 0, 0, '2021-10-07 06:06:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2046, 8, 330, 1, 0, 0, 0, '2021-10-07 06:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2047, 8, 332, 1, 0, 0, 0, '2021-10-07 06:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2048, 8, 334, 1, 0, 0, 0, '2021-10-07 06:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2049, 8, 336, 1, 0, 0, 0, '2021-10-07 06:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2050, 8, 338, 1, 0, 0, 0, '2021-10-07 06:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2051, 8, 340, 1, 0, 0, 0, '2021-10-07 06:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2052, 8, 342, 1, 0, 0, 0, '2021-10-07 06:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2053, 8, 236, 1, 1, 1, 0, '2021-10-07 06:08:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2055, 8, 165, 1, 1, 1, 1, '2021-10-07 08:12:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2056, 8, 166, 1, 1, 1, 1, '2021-10-07 08:12:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2057, 8, 80, 1, 1, 1, 1, '2021-10-07 06:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2058, 8, 81, 1, 1, 1, 1, '2021-10-07 06:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2059, 8, 82, 1, 1, 1, 1, '2021-10-07 06:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2060, 8, 83, 1, 1, 1, 1, '2021-10-07 06:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2061, 8, 84, 1, 1, 1, 1, '2021-10-07 06:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2062, 8, 85, 1, 1, 1, 1, '2021-10-07 06:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2063, 8, 204, 1, 1, 1, 1, '2021-10-07 06:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2064, 8, 205, 1, 0, 0, 0, '2021-10-07 06:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2065, 8, 214, 1, 0, 0, 0, '2021-10-07 06:11:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2066, 8, 215, 1, 0, 0, 0, '2021-10-07 06:11:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2067, 8, 86, 1, 0, 0, 0, '2021-10-07 06:11:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2068, 8, 109, 1, 1, 0, 1, '2021-10-07 06:11:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2069, 8, 31, 1, 0, 0, 0, '2021-10-07 06:12:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2070, 8, 32, 1, 0, 0, 0, '2021-10-07 06:12:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2071, 8, 48, 1, 0, 0, 0, '2021-10-07 06:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2072, 8, 89, 1, 0, 0, 0, '2021-10-07 06:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2073, 8, 178, 1, 0, 0, 0, '2021-10-07 06:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2074, 8, 180, 1, 0, 0, 0, '2021-10-07 06:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2075, 8, 181, 1, 0, 0, 0, '2021-10-07 06:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2076, 8, 182, 1, 0, 0, 0, '2021-10-07 06:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2077, 8, 207, 1, 0, 0, 0, '2021-10-07 06:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2078, 8, 208, 1, 0, 0, 0, '2021-10-07 06:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2079, 8, 209, 1, 0, 0, 0, '2021-10-07 06:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2080, 8, 253, 1, 0, 0, 0, '2021-10-07 06:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2081, 8, 254, 1, 0, 0, 0, '2021-10-07 06:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2082, 8, 255, 1, 0, 0, 0, '2021-10-07 06:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2083, 8, 118, 1, 0, 0, 0, '2021-10-07 06:14:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2084, 8, 238, 1, 0, 0, 0, '2021-10-07 06:14:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2085, 8, 102, 1, 1, 1, 1, '2021-10-07 06:14:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2086, 9, 321, 1, 0, 0, 0, '2021-10-07 06:25:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2093, 1, 132, 1, 1, 1, 1, '2021-10-07 06:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2094, 1, 198, 1, 0, 0, 0, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2095, 1, 327, 1, 0, 0, 0, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2096, 1, 329, 1, 0, 0, 0, '2021-10-07 06:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2108, 1, 294, 1, 1, 1, 1, '2021-10-07 06:56:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2109, 1, 296, 1, 1, 1, 1, '2021-10-07 06:56:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2110, 1, 297, 1, 0, 0, 0, '2021-10-07 06:56:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2111, 1, 298, 1, 0, 0, 0, '2021-10-07 06:56:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2112, 1, 129, 0, 1, 0, 1, '2021-10-07 06:56:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2113, 1, 27, 1, 1, 0, 1, '2021-10-07 06:56:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2114, 1, 155, 1, 0, 0, 0, '2021-10-07 06:57:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2115, 1, 156, 1, 0, 0, 0, '2021-10-07 06:57:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2116, 1, 157, 1, 0, 0, 0, '2021-10-07 06:57:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2117, 1, 158, 1, 0, 0, 0, '2021-10-07 06:57:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2118, 1, 159, 1, 0, 0, 0, '2021-10-07 06:57:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2119, 1, 161, 1, 0, 0, 0, '2021-10-07 06:57:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2120, 1, 162, 1, 0, 0, 0, '2021-10-07 06:57:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2121, 1, 190, 1, 0, 0, 0, '2021-10-07 06:57:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2122, 1, 238, 1, 0, 0, 0, '2021-10-07 06:57:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2127, 1, 320, 1, 0, 0, 0, '2021-10-07 07:01:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2128, 1, 321, 1, 0, 0, 0, '2021-10-07 07:01:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2135, 1, 371, 1, 0, 0, 0, '2021-10-07 07:05:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2150, 1, 280, 1, 1, 1, 1, '2021-10-07 07:29:08');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2151, 1, 369, 1, 0, 0, 0, '2021-10-07 07:30:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2152, 1, 370, 1, 0, 0, 0, '2021-10-07 07:30:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2153, 1, 281, 1, 0, 0, 0, '2021-10-07 07:30:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2154, 1, 282, 1, 0, 0, 0, '2021-10-07 07:30:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2155, 2, 321, 1, 0, 0, 0, '2021-10-07 07:31:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2156, 2, 197, 1, 0, 0, 0, '2021-10-07 07:33:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2157, 2, 248, 1, 0, 0, 0, '2021-10-07 07:33:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2158, 2, 264, 1, 1, 0, 1, '2021-10-07 07:34:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2159, 2, 247, 1, 0, 0, 0, '2021-10-07 07:35:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2160, 2, 281, 1, 0, 0, 0, '2021-10-07 07:40:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2161, 2, 282, 1, 0, 0, 0, '2021-10-07 07:40:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2162, 2, 371, 1, 0, 0, 0, '2021-10-07 07:40:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2163, 3, 257, 1, 0, 0, 0, '2021-10-07 07:41:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2164, 3, 355, 1, 0, 0, 0, '2021-10-07 07:41:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2165, 3, 153, 1, 0, 0, 0, '2021-10-07 07:41:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2166, 3, 244, 1, 0, 0, 0, '2021-10-07 07:41:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2167, 3, 354, 1, 0, 0, 0, '2021-10-07 07:41:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2168, 3, 202, 1, 0, 0, 0, '2021-10-07 07:42:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2169, 3, 246, 1, 0, 0, 0, '2021-10-07 07:42:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2170, 3, 237, 1, 0, 0, 0, '2021-10-07 07:43:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2171, 3, 240, 1, 0, 1, 0, '2021-10-07 07:43:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2172, 3, 242, 1, 0, 1, 0, '2021-10-07 07:43:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2173, 3, 129, 0, 1, 0, 1, '2021-10-07 07:43:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2174, 3, 183, 1, 0, 0, 0, '2021-10-07 07:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2175, 3, 188, 1, 0, 0, 0, '2021-10-07 07:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2176, 3, 206, 1, 0, 0, 0, '2021-10-07 07:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2177, 3, 207, 1, 0, 0, 0, '2021-10-07 07:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2178, 3, 208, 1, 0, 0, 0, '2021-10-07 07:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2179, 3, 209, 1, 0, 0, 0, '2021-10-07 07:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2180, 3, 211, 1, 0, 0, 0, '2021-10-07 07:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2181, 3, 258, 1, 0, 0, 0, '2021-10-07 07:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2182, 3, 271, 1, 0, 0, 0, '2021-10-07 07:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2183, 3, 350, 1, 0, 0, 0, '2021-10-07 07:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2184, 3, 369, 1, 0, 0, 0, '2021-10-07 07:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2185, 3, 238, 1, 0, 0, 0, '2021-10-07 07:46:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2186, 3, 362, 1, 0, 0, 0, '2021-10-07 07:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2187, 3, 363, 1, 1, 1, 1, '2021-10-07 07:47:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2188, 3, 366, 1, 0, 0, 0, '2021-10-07 07:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2189, 3, 367, 1, 1, 1, 1, '2021-10-07 07:47:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2190, 3, 371, 1, 0, 0, 0, '2021-10-07 07:47:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2194, 4, 132, 1, 0, 0, 0, '2021-10-07 07:50:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2195, 4, 138, 1, 0, 0, 0, '2021-10-07 07:51:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2196, 4, 264, 1, 1, 0, 1, '2021-10-07 07:52:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2198, 4, 371, 1, 0, 0, 0, '2021-10-07 07:56:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2201, 5, 132, 1, 0, 0, 0, '2021-10-07 07:56:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2202, 5, 304, 1, 0, 0, 0, '2021-10-07 07:56:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2204, 5, 138, 1, 0, 0, 0, '2021-10-07 07:57:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2205, 5, 139, 1, 0, 0, 0, '2021-10-07 07:57:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2206, 5, 307, 1, 0, 0, 0, '2021-10-07 07:57:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2207, 5, 257, 1, 1, 1, 1, '2021-10-07 07:58:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2209, 5, 168, 1, 1, 1, 1, '2021-10-07 07:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2210, 5, 169, 1, 1, 1, 1, '2021-10-07 07:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2211, 5, 202, 1, 1, 0, 1, '2021-10-07 07:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2212, 5, 246, 1, 0, 0, 0, '2021-10-07 07:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2213, 5, 293, 1, 1, 1, 1, '2021-10-07 07:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2214, 5, 302, 1, 1, 0, 1, '2021-10-07 07:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2215, 5, 311, 1, 1, 1, 1, '2021-10-07 07:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2216, 5, 336, 1, 0, 0, 0, '2021-10-07 07:59:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2217, 5, 274, 1, 0, 0, 0, '2021-10-07 08:00:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2219, 5, 183, 1, 0, 0, 0, '2021-10-07 08:01:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2220, 5, 211, 1, 0, 0, 0, '2021-10-07 08:01:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2221, 5, 371, 1, 0, 0, 0, '2021-10-07 08:02:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2222, 6, 132, 1, 0, 0, 0, '2021-10-07 08:03:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2223, 6, 135, 1, 0, 0, 0, '2021-10-07 08:03:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2224, 6, 138, 1, 0, 0, 0, '2021-10-07 08:03:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2225, 6, 139, 1, 0, 0, 0, '2021-10-07 08:03:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2226, 6, 308, 1, 0, 0, 0, '2021-10-07 08:03:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2227, 6, 309, 1, 0, 0, 0, '2021-10-07 08:03:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2228, 6, 203, 1, 1, 1, 1, '2021-10-07 08:04:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2229, 6, 264, 1, 1, 0, 1, '2021-10-07 08:04:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2231, 6, 274, 1, 0, 0, 0, '2021-10-07 08:06:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2232, 6, 371, 1, 0, 0, 0, '2021-10-07 08:07:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2233, 8, 304, 1, 0, 0, 0, '2021-10-07 08:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2234, 8, 305, 1, 0, 1, 0, '2021-10-07 08:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2235, 8, 306, 1, 0, 0, 0, '2021-10-07 08:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2236, 8, 307, 1, 0, 0, 0, '2021-10-07 08:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2237, 8, 319, 1, 1, 1, 1, '2021-10-07 08:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2238, 8, 320, 1, 0, 0, 0, '2021-10-07 08:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2239, 8, 301, 1, 0, 0, 0, '2021-10-07 08:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2240, 8, 309, 1, 0, 1, 0, '2021-10-07 08:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2241, 8, 310, 1, 0, 0, 0, '2021-10-07 08:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2242, 8, 329, 1, 0, 0, 0, '2021-10-07 08:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2243, 8, 257, 1, 0, 0, 0, '2021-10-07 08:10:57');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2244, 8, 153, 1, 0, 0, 0, '2021-10-07 08:11:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2245, 8, 169, 1, 0, 0, 0, '2021-10-07 08:11:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2246, 8, 202, 1, 0, 0, 0, '2021-10-07 08:11:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2247, 8, 302, 1, 0, 0, 0, '2021-10-07 08:11:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2248, 8, 311, 1, 0, 0, 0, '2021-10-07 08:11:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2249, 2, 348, 1, 0, 1, 0, '2021-10-07 08:17:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2250, 8, 247, 1, 1, 1, 1, '2021-10-07 08:12:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2251, 8, 318, 1, 1, 0, 1, '2021-10-07 08:12:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2252, 8, 294, 1, 1, 1, 1, '2021-10-07 08:13:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2253, 8, 295, 1, 0, 1, 0, '2021-10-07 08:13:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2254, 8, 296, 1, 1, 1, 1, '2021-10-07 08:13:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2255, 8, 297, 1, 0, 0, 0, '2021-10-07 08:13:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2256, 8, 298, 1, 0, 0, 0, '2021-10-07 08:13:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2257, 2, 56, 1, 0, 0, 0, '2021-10-07 08:13:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2258, 8, 43, 1, 1, 1, 1, '2021-10-07 08:13:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2259, 8, 44, 1, 0, 0, 0, '2021-10-07 08:13:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2260, 8, 27, 1, 1, 0, 1, '2021-10-07 08:13:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2261, 8, 274, 1, 0, 0, 0, '2021-10-07 08:13:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2262, 2, 54, 1, 0, 0, 0, '2021-10-07 08:13:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2263, 8, 183, 1, 0, 0, 0, '2021-10-07 08:15:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2264, 8, 256, 1, 0, 0, 0, '2021-10-07 08:15:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2265, 8, 258, 1, 0, 0, 0, '2021-10-07 08:15:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2266, 8, 259, 1, 0, 0, 0, '2021-10-07 08:15:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2267, 8, 350, 1, 0, 0, 0, '2021-10-07 08:15:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2268, 8, 162, 1, 0, 0, 0, '2021-10-07 08:15:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2269, 8, 371, 1, 0, 0, 0, '2021-10-07 08:15:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2271, 9, 274, 1, 0, 0, 0, '2021-10-07 08:19:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2272, 9, 118, 1, 0, 0, 0, '2021-10-07 08:20:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2273, 9, 238, 1, 0, 0, 0, '2021-10-07 08:20:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2274, 9, 371, 1, 0, 0, 0, '2021-10-07 08:20:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2275, 1, 218, 1, 0, 0, 0, '2021-10-07 08:20:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2276, 1, 330, 1, 0, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2277, 1, 331, 1, 1, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2278, 1, 332, 1, 0, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2279, 1, 333, 1, 1, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2280, 1, 334, 1, 0, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2281, 1, 335, 1, 1, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2282, 1, 336, 1, 0, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2283, 1, 337, 1, 1, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2284, 1, 338, 1, 0, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2285, 1, 339, 1, 1, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2286, 1, 340, 1, 0, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2287, 1, 341, 1, 1, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2288, 1, 342, 1, 0, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2289, 1, 343, 1, 1, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2290, 1, 344, 1, 0, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2291, 1, 345, 1, 0, 0, 0, '2021-10-22 02:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2292, 1, 372, 1, NULL, NULL, NULL, '2021-10-29 09:41:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2293, 1, 373, 1, NULL, NULL, NULL, '2021-10-29 09:42:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2294, 1, 374, 1, 1, 1, 1, '2021-10-29 09:45:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2295, 1, 375, 1, 1, 1, 1, '2021-10-29 09:45:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2296, 1, 386, 1, 1, 0, 1, '2021-11-10 08:22:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2297, 3, 386, 1, 1, 0, 1, '2021-11-10 08:22:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2298, 1, 387, 1, 0, 0, 0, '2021-11-10 08:24:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2299, 3, 387, 1, 0, 0, 0, '2021-11-10 08:24:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2300, 1, 419, 1, 1, 1, 1, '2024-08-20 12:19:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2301, 1, 415, 1, 0, 0, 0, '2024-08-20 12:19:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2302, 1, 416, 1, 1, 1, 1, '2024-08-20 12:19:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2303, 1, 417, 1, 1, 1, 1, '2024-08-20 12:19:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2304, 1, 418, 1, 1, 1, 1, '2024-08-20 12:19:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2305, 1, 414, 1, 0, 1, 0, '2024-08-20 12:20:08');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2306, 1, 398, 1, 1, 1, 1, '2024-08-20 12:21:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2307, 1, 402, 1, 0, 0, 0, '2024-08-20 12:21:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2308, 1, 413, 1, 0, 1, 0, '2024-08-20 12:21:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2309, 1, 409, 1, 0, 0, 1, '2024-08-20 12:21:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2310, 1, 410, 1, 1, 0, 1, '2024-08-20 12:21:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2311, 1, 411, 1, 0, 0, 0, '2024-08-20 12:21:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2312, 1, 412, 1, 0, 0, 0, '2024-08-20 12:21:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2313, 1, 406, 1, 1, 1, 1, '2024-08-20 12:22:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2314, 1, 407, 1, 1, 1, 1, '2024-08-20 12:22:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2315, 1, 408, 1, 1, 1, 1, '2024-08-20 12:22:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2316, 1, 405, 1, 1, 1, 1, '2024-08-20 12:22:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2317, 1, 393, 1, 1, 1, 1, '2024-08-20 12:23:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2318, 1, 394, 1, 1, 1, 1, '2024-08-20 12:23:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2319, 1, 395, 1, 1, 1, 1, '2024-08-20 12:23:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2320, 1, 396, 1, 1, 1, 1, '2024-08-20 12:23:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2321, 1, 401, 1, 0, 0, 0, '2024-08-20 12:23:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2322, 1, 403, 1, 0, 0, 0, '2024-08-20 12:23:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2323, 1, 404, 1, 0, 0, 0, '2024-08-20 12:23:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2324, 1, 392, 1, 1, 1, 1, '2024-08-20 12:25:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2325, 1, 400, 1, 0, 0, 0, '2024-08-20 12:25:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2326, 1, 390, 1, 0, 0, 0, '2024-08-20 12:25:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2327, 1, 399, 1, 0, 0, 0, '2024-08-20 12:25:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2328, 1, 388, 1, 1, 1, 1, '2024-08-20 12:27:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2329, 1, 389, 1, 1, 1, 1, '2024-08-20 12:27:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2330, 1, 391, 1, 1, 1, 1, '2024-08-20 12:27:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2331, 1, 397, 1, 0, 0, 0, '2024-08-20 12:31:13');


#
# TABLE STRUCTURE FOR: sch_settings
#

DROP TABLE IF EXISTS `sch_settings`;

CREATE TABLE `sch_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `base_url` varchar(500) DEFAULT NULL,
  `folder_path` text DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `biometric` int(11) DEFAULT 0,
  `biometric_device` text DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `start_month` varchar(100) NOT NULL,
  `session_id` int(11) DEFAULT NULL,
  `lang_id` int(11) DEFAULT NULL,
  `languages` varchar(255) NOT NULL DEFAULT '["4"]',
  `dise_code` varchar(50) DEFAULT NULL,
  `date_format` varchar(50) NOT NULL,
  `time_format` varchar(20) DEFAULT '24-hour',
  `currency` varchar(50) NOT NULL,
  `currency_symbol` varchar(50) NOT NULL,
  `is_rtl` varchar(10) DEFAULT 'disabled',
  `timezone` varchar(30) DEFAULT 'UTC',
  `image` varchar(100) DEFAULT NULL,
  `mini_logo` varchar(200) NOT NULL,
  `theme` varchar(200) NOT NULL DEFAULT 'default.jpg',
  `credit_limit` varchar(255) DEFAULT NULL,
  `opd_record_month` varchar(50) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `cron_secret_key` varchar(100) NOT NULL,
  `doctor_restriction` varchar(100) NOT NULL,
  `superadmin_restriction` varchar(200) NOT NULL,
  `patient_panel` varchar(50) NOT NULL,
  `scan_code_type` varchar(50) NOT NULL DEFAULT 'barcode',
  `mobile_api_url` varchar(200) NOT NULL,
  `app_primary_color_code` varchar(50) NOT NULL,
  `app_secondary_color_code` varchar(50) NOT NULL,
  `app_logo` varchar(200) NOT NULL,
  `zoom_api_key` varchar(200) NOT NULL,
  `zoom_api_secret` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `lang_id` (`lang_id`),
  KEY `session_id` (`session_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `sch_settings` (`id`, `base_url`, `folder_path`, `name`, `biometric`, `biometric_device`, `email`, `phone`, `address`, `start_month`, `session_id`, `lang_id`, `languages`, `dise_code`, `date_format`, `time_format`, `currency`, `currency_symbol`, `is_rtl`, `timezone`, `image`, `mini_logo`, `theme`, `credit_limit`, `opd_record_month`, `is_active`, `cron_secret_key`, `doctor_restriction`, `superadmin_restriction`, `patient_panel`, `scan_code_type`, `mobile_api_url`, `app_primary_color_code`, `app_secondary_color_code`, `app_logo`, `zoom_api_key`, `zoom_api_secret`, `created_at`) VALUES (1, NULL, NULL, 'Abyssinia Dental Centre', 0, NULL, 'abyssiniadental@gmail.com', '+254 791 023590', 'Opposite Equity Bank, Nur Muumin Building 1st Floor, Moyale', '', NULL, 4, '[\"4\"]', 'Your Hospital Code', 'd-m-Y', '24-hour', 'KES', 'Kes', 'disabled', 'Africa/Nairobi', '1.jpg', '1mini_logo.jpg', 'default.jpg', '20000', '1', 'no', '', 'disabled', 'enabled', 'enabled', 'barcode', '', '#424242', '#eeeeee', '0app_logo.png', '', '', '2025-06-24 15:09:22');


#
# TABLE STRUCTURE FOR: send_notification
#

DROP TABLE IF EXISTS `send_notification`;

CREATE TABLE `send_notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `date` date DEFAULT NULL,
  `message` text DEFAULT NULL,
  `visible_staff` varchar(10) NOT NULL DEFAULT 'no',
  `visible_patient` varchar(10) NOT NULL DEFAULT 'no',
  `created_by` varchar(60) DEFAULT NULL,
  `created_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `created_id` (`created_id`),
  KEY `index_title` (`title`),
  KEY `index_publish_date` (`publish_date`),
  KEY `index_date` (`date`),
  KEY `index_visible_staff` (`visible_staff`),
  KEY `index_visible_patient` (`visible_patient`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: share_content_for
#

DROP TABLE IF EXISTS `share_content_for`;

CREATE TABLE `share_content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` varchar(20) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `share_content_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `upload_content_id` (`share_content_id`),
  KEY `student_id` (`patient_id`),
  KEY `staff_id` (`staff_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: share_contents
#

DROP TABLE IF EXISTS `share_contents`;

CREATE TABLE `share_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `send_to` varchar(50) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `share_date` date DEFAULT NULL,
  `valid_upto` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `index_send_to` (`send_to`),
  KEY `index_share_date` (`share_date`),
  KEY `index_valid_upto` (`valid_upto`),
  KEY `index_created_by` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: share_upload_contents
#

DROP TABLE IF EXISTS `share_upload_contents`;

CREATE TABLE `share_upload_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `upload_content_id` int(11) DEFAULT NULL,
  `share_content_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `upload_content_id` (`upload_content_id`),
  KEY `share_content_id` (`share_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: shift_details
#

DROP TABLE IF EXISTS `shift_details`;

CREATE TABLE `shift_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `consult_duration` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `charge_id` (`charge_id`),
  KEY `index_consult_duration` (`consult_duration`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `shift_details` (`id`, `staff_id`, `consult_duration`, `charge_id`, `created_at`) VALUES (1, 2, 60, 24, '2025-06-24 18:33:41');
INSERT INTO `shift_details` (`id`, `staff_id`, `consult_duration`, `charge_id`, `created_at`) VALUES (2, 3, 60, 24, '2025-06-25 09:35:31');


#
# TABLE STRUCTURE FOR: sms_config
#

DROP TABLE IF EXISTS `sms_config`;

CREATE TABLE `sms_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `api_id` varchar(100) NOT NULL,
  `authkey` varchar(100) NOT NULL,
  `senderid` varchar(100) NOT NULL,
  `contact` text DEFAULT NULL,
  `username` varchar(150) DEFAULT NULL,
  `url` varchar(150) DEFAULT NULL,
  `password` varchar(150) DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'disabled',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: source
#

DROP TABLE IF EXISTS `source`;

CREATE TABLE `source` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `source` varchar(100) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_source` (`source`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: specialist
#

DROP TABLE IF EXISTS `specialist`;

CREATE TABLE `specialist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `specialist_name` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_specialist_name` (`specialist_name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `specialist` (`id`, `specialist_name`, `is_active`, `created_at`) VALUES (1, 'DENTIST', 'yes', '2025-06-23 13:08:33');
INSERT INTO `specialist` (`id`, `specialist_name`, `is_active`, `created_at`) VALUES (2, 'NURSE', 'yes', '2025-06-23 13:08:40');
INSERT INTO `specialist` (`id`, `specialist_name`, `is_active`, `created_at`) VALUES (3, 'RECEPTION', 'yes', '2025-06-23 13:08:50');


#
# TABLE STRUCTURE FOR: staff
#

DROP TABLE IF EXISTS `staff`;

CREATE TABLE `staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` varchar(200) DEFAULT NULL,
  `lang_id` int(11) NOT NULL,
  `department_id` int(11) DEFAULT NULL,
  `staff_designation_id` int(11) DEFAULT NULL,
  `specialist` varchar(200) NOT NULL,
  `qualification` varchar(200) NOT NULL,
  `work_exp` varchar(200) NOT NULL,
  `specialization` varchar(200) NOT NULL,
  `name` varchar(200) NOT NULL,
  `surname` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `mother_name` varchar(200) NOT NULL,
  `contact_no` varchar(200) NOT NULL,
  `emergency_contact_no` varchar(200) NOT NULL,
  `email` varchar(200) NOT NULL,
  `dob` date DEFAULT NULL,
  `marital_status` varchar(100) NOT NULL,
  `date_of_joining` date DEFAULT NULL,
  `date_of_leaving` date DEFAULT NULL,
  `local_address` varchar(300) NOT NULL,
  `permanent_address` varchar(200) NOT NULL,
  `note` varchar(200) NOT NULL,
  `image` varchar(200) NOT NULL,
  `password` varchar(250) NOT NULL,
  `gender` varchar(50) NOT NULL,
  `blood_group` varchar(100) NOT NULL,
  `account_title` varchar(200) NOT NULL,
  `bank_account_no` varchar(200) NOT NULL,
  `bank_name` varchar(200) NOT NULL,
  `ifsc_code` varchar(200) NOT NULL,
  `bank_branch` varchar(100) NOT NULL,
  `payscale` varchar(200) NOT NULL,
  `basic_salary` varchar(200) NOT NULL,
  `epf_no` varchar(200) NOT NULL,
  `contract_type` varchar(100) NOT NULL,
  `shift` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `facebook` varchar(200) NOT NULL,
  `twitter` varchar(200) NOT NULL,
  `linkedin` varchar(200) NOT NULL,
  `instagram` varchar(200) NOT NULL,
  `resume` varchar(200) NOT NULL,
  `joining_letter` varchar(200) NOT NULL,
  `resignation_letter` varchar(200) NOT NULL,
  `other_document_name` varchar(200) NOT NULL,
  `other_document_file` varchar(200) NOT NULL,
  `user_id` int(11) NOT NULL,
  `is_active` int(11) NOT NULL,
  `verification_code` varchar(100) NOT NULL,
  `zoom_api_key` varchar(100) NOT NULL,
  `zoom_api_secret` varchar(100) NOT NULL,
  `pan_number` varchar(30) NOT NULL,
  `identification_number` varchar(30) NOT NULL,
  `local_identification_number` varchar(30) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `employee_id` (`employee_id`),
  KEY `staff_designation_id` (`staff_designation_id`),
  KEY `department_id` (`department_id`),
  KEY `index_name` (`name`),
  KEY `index_surname` (`surname`),
  KEY `index_father_name` (`father_name`),
  KEY `index_mother_name` (`mother_name`),
  KEY `index_contact_no` (`contact_no`),
  KEY `index_emergency_contact_no` (`emergency_contact_no`),
  KEY `index_email` (`email`),
  KEY `index_dob` (`dob`),
  KEY `index_marital_status` (`marital_status`),
  KEY `index_date_of_joining` (`date_of_joining`),
  KEY `index_date_of_leaving` (`date_of_leaving`),
  KEY `index_gender` (`gender`),
  KEY `index_blood_group` (`blood_group`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `staff` (`id`, `employee_id`, `lang_id`, `department_id`, `staff_designation_id`, `specialist`, `qualification`, `work_exp`, `specialization`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `blood_group`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`, `zoom_api_key`, `zoom_api_secret`, `pan_number`, `identification_number`, `local_identification_number`, `created_at`) VALUES (1, '9001', 0, NULL, NULL, '', '', '', '', 'Super Admin', '', '', '', '', '', 'admin@gmail.com', NULL, '', NULL, NULL, '', '', '', '', '$2y$10$5uXoIGhpAMgMUA7qYJI9XuUMjdna6BlSKt1G/vr/yCpAWev19czw.', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 1, '', '', '', '', '', '', '2025-06-23 10:28:30');
INSERT INTO `staff` (`id`, `employee_id`, `lang_id`, `department_id`, `staff_designation_id`, `specialist`, `qualification`, `work_exp`, `specialization`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `blood_group`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`, `zoom_api_key`, `zoom_api_secret`, `pan_number`, `identification_number`, `local_identification_number`, `created_at`) VALUES (2, 'O1', 0, 1, 1, '1', '', '', '', 'WAFULA', 'WASIKE', '', '', '0791948030', '', 'wasikekevin6@gmail.com', '1996-11-10', '', NULL, NULL, 'Moyale', '', '', '', '$2y$10$kPDTuXoAviufpWqX0KN2yOQD2HEvyEstgxQ3bXh9N/exvO88yGoJC', 'Male', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Other Document', '', 0, 1, 'MG5OeUc3Ym5DcnNFc2ZXYWxyNDFiVHUvK3ZVZ2xlaTYrSjVRanp0eDNxMD0=', '', '', '', '', '', '2025-06-24 08:22:35');
INSERT INTO `staff` (`id`, `employee_id`, `lang_id`, `department_id`, `staff_designation_id`, `specialist`, `qualification`, `work_exp`, `specialization`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `blood_group`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`, `zoom_api_key`, `zoom_api_secret`, `pan_number`, `identification_number`, `local_identification_number`, `created_at`) VALUES (3, '02', 0, 1, 1, '1', '', '', '', 'EMMANUEL', 'KIPTUM', '', '', '0742190695', '0706269674', 'kiptum@gmail.com', '2000-01-01', '', NULL, NULL, '', '', '', '', '$2y$10$7XTXYJ8W8hj0Xw9yut7myOnEjtX3nFPRqlgI/keL.sN18K5WQCsbK', 'Male', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Other Document', '', 0, 1, '', '', '', '', '', '', '2025-06-25 08:14:13');
INSERT INTO `staff` (`id`, `employee_id`, `lang_id`, `department_id`, `staff_designation_id`, `specialist`, `qualification`, `work_exp`, `specialization`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `blood_group`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`, `zoom_api_key`, `zoom_api_secret`, `pan_number`, `identification_number`, `local_identification_number`, `created_at`) VALUES (4, '03', 0, 1, 2, '3', '', '', '', 'SECRETARY', '', '', '', '', '', 'secretary@gmail.com', '2000-01-01', '', NULL, NULL, '', '', '', '', '$2y$10$TNeqWpvK7eJmdMHQpVCWw.DjKLcrQWY.Y90e47l6pDdHQkveBzQQm', 'Female', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Other Document', '', 0, 1, '', '', '', '', '', '', '2025-06-25 08:15:48');
INSERT INTO `staff` (`id`, `employee_id`, `lang_id`, `department_id`, `staff_designation_id`, `specialist`, `qualification`, `work_exp`, `specialization`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `blood_group`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`, `zoom_api_key`, `zoom_api_secret`, `pan_number`, `identification_number`, `local_identification_number`, `created_at`) VALUES (5, '04', 0, 1, 2, '3', '', '', '', 'Salome', 'Mugendi', '', '', '0117557146', '', 'abyssiniadental@gmail.com', '0006-06-28', '', '2025-07-01', NULL, '', '', '', '', '$2y$10$yzPVnbTDBWw9VFDOpE/UMu9PyqohaRJb7cg0akFMw9zdWYAFxNEnG', 'Female', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Other Document', '', 0, 1, '', '', '', '', '', '', '2025-07-02 07:05:18');


#
# TABLE STRUCTURE FOR: staff_attendance
#

DROP TABLE IF EXISTS `staff_attendance`;

CREATE TABLE `staff_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `staff_attendance_type_id` int(11) DEFAULT NULL,
  `biometric_attendence` int(11) DEFAULT 0,
  `biometric_device_data` text DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `remark` varchar(200) NOT NULL,
  `is_active` int(11) NOT NULL,
  `in_time` time DEFAULT NULL,
  `out_time` time DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `staff_attendance_type_id` (`staff_attendance_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (1, '2025-07-02', 2, 1, 0, NULL, NULL, '', 0, '00:00:00', '00:00:00', '2025-07-02 07:01:35', '2025-07-02 00:00:00');
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (2, '2025-07-02', 3, 1, 0, NULL, NULL, '', 0, '00:00:00', '00:00:00', '2025-07-02 07:01:35', '2025-07-02 00:00:00');
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (3, '2025-07-02', 4, 1, 0, NULL, NULL, '', 0, '00:00:00', '00:00:00', '2025-07-02 07:01:35', '2025-07-02 00:00:00');


#
# TABLE STRUCTURE FOR: staff_attendance_type
#

DROP TABLE IF EXISTS `staff_attendance_type`;

CREATE TABLE `staff_attendance_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `key_value` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `long_lang_name` varchar(250) DEFAULT NULL,
  `long_name_style` varchar(250) DEFAULT NULL,
  `for_schedule` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_type` (`type`),
  KEY `index_key_value` (`key_value`),
  KEY `index_is_active` (`is_active`),
  KEY `index_long_lang_name` (`long_lang_name`),
  KEY `index_long_name_style` (`long_name_style`),
  KEY `index_for_schedule` (`for_schedule`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `staff_attendance_type` (`id`, `type`, `key_value`, `is_active`, `long_lang_name`, `long_name_style`, `for_schedule`, `created_at`, `updated_at`) VALUES (1, 'Present', '<b class=\"text text-success\">P</b>', 'yes', 'present', NULL, 1, '2024-08-21 11:29:55', NULL);
INSERT INTO `staff_attendance_type` (`id`, `type`, `key_value`, `is_active`, `long_lang_name`, `long_name_style`, `for_schedule`, `created_at`, `updated_at`) VALUES (2, 'Late', '<b class=\"text text-warning\">L</b>', 'yes', 'late', NULL, 1, '2024-08-21 11:29:55', NULL);
INSERT INTO `staff_attendance_type` (`id`, `type`, `key_value`, `is_active`, `long_lang_name`, `long_name_style`, `for_schedule`, `created_at`, `updated_at`) VALUES (3, 'Absent', '<b class=\"text text-danger\">A</b>', 'yes', 'absent', NULL, 0, '2024-08-21 11:29:55', NULL);
INSERT INTO `staff_attendance_type` (`id`, `type`, `key_value`, `is_active`, `long_lang_name`, `long_name_style`, `for_schedule`, `created_at`, `updated_at`) VALUES (4, 'Half Day', '<b class=\"text text-warning\">F</b>', 'yes', 'half_day', NULL, 1, '2024-08-21 11:29:55', NULL);
INSERT INTO `staff_attendance_type` (`id`, `type`, `key_value`, `is_active`, `long_lang_name`, `long_name_style`, `for_schedule`, `created_at`, `updated_at`) VALUES (5, 'Holiday', 'H', 'yes', 'holiday', NULL, 0, '2024-08-21 11:29:55', NULL);
INSERT INTO `staff_attendance_type` (`id`, `type`, `key_value`, `is_active`, `long_lang_name`, `long_name_style`, `for_schedule`, `created_at`, `updated_at`) VALUES (6, 'Half Day Second Shift', '<b class=\"text text-warning\">SH</b>', 'yes', 'half_day_second_shift', 'label label-info', 1, '2024-06-08 18:35:55', NULL);


#
# TABLE STRUCTURE FOR: staff_attendence_schedules
#

DROP TABLE IF EXISTS `staff_attendence_schedules`;

CREATE TABLE `staff_attendence_schedules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_attendence_type_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `entry_time_from` time DEFAULT NULL,
  `entry_time_to` time DEFAULT NULL,
  `total_institute_hour` time DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  KEY `staff_attendence_type_id` (`staff_attendence_type_id`),
  KEY `index_entry_time_from` (`entry_time_from`),
  KEY `index_entry_time_to` (`entry_time_to`),
  KEY `index_total_institute_hour` (`total_institute_hour`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: staff_designation
#

DROP TABLE IF EXISTS `staff_designation`;

CREATE TABLE `staff_designation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `designation` varchar(200) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_designation` (`designation`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `staff_designation` (`id`, `designation`, `is_active`, `created_at`) VALUES (1, 'MR', 'yes', '2025-06-23 13:08:12');
INSERT INTO `staff_designation` (`id`, `designation`, `is_active`, `created_at`) VALUES (2, 'MRS', 'yes', '2025-06-23 13:08:23');


#
# TABLE STRUCTURE FOR: staff_id_card
#

DROP TABLE IF EXISTS `staff_id_card`;

CREATE TABLE `staff_id_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `hospital_name` varchar(255) NOT NULL,
  `hospital_address` varchar(255) NOT NULL,
  `background` text NOT NULL,
  `logo` text NOT NULL,
  `sign_image` text NOT NULL,
  `header_color` varchar(100) NOT NULL,
  `enable_staff_role` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_staff_id` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_staff_department` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_designation` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_fathers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_mothers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_date_of_joining` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_permanent_address` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_staff_dob` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_staff_phone` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_staff_barcode` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `status` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_title` (`title`),
  KEY `index_hospital_name` (`hospital_name`),
  KEY `index_hospital_address` (`hospital_address`),
  KEY `index_header_color` (`header_color`),
  KEY `index_enable_staff_role` (`enable_staff_role`),
  KEY `index_enable_staff_id` (`enable_staff_id`),
  KEY `index_enable_staff_department` (`enable_staff_department`),
  KEY `index_enable_designation` (`enable_designation`),
  KEY `index_enable_name` (`enable_name`),
  KEY `index_enable_fathers_name` (`enable_fathers_name`),
  KEY `index_enable_mothers_name` (`enable_mothers_name`),
  KEY `index_enable_date_of_joining` (`enable_date_of_joining`),
  KEY `index_enable_permanent_address` (`enable_permanent_address`),
  KEY `index_enable_staff_dob` (`enable_staff_dob`),
  KEY `index_enable_staff_phone` (`enable_staff_phone`),
  KEY `index_enable_staff_barcode` (`enable_staff_barcode`),
  KEY `index_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `staff_id_card` (`id`, `title`, `hospital_name`, `hospital_address`, `background`, `logo`, `sign_image`, `header_color`, `enable_staff_role`, `enable_staff_id`, `enable_staff_department`, `enable_designation`, `enable_name`, `enable_fathers_name`, `enable_mothers_name`, `enable_date_of_joining`, `enable_permanent_address`, `enable_staff_dob`, `enable_staff_phone`, `enable_staff_barcode`, `status`, `created_at`) VALUES (1, 'Sample Staff Id Card', 'National Hospital', 'Habibganj Rd, Opp Cricket Club, E-3, Arera Colony, Bhopal', 'background.jpg', 'logo.jpg', 'signature.png', '#0e5c9f', 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 1, '2021-10-19 08:58:50');


#
# TABLE STRUCTURE FOR: staff_leave_details
#

DROP TABLE IF EXISTS `staff_leave_details`;

CREATE TABLE `staff_leave_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `leave_type_id` int(11) DEFAULT NULL,
  `alloted_leave` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `leave_type_id` (`leave_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `staff_leave_details` (`id`, `staff_id`, `leave_type_id`, `alloted_leave`, `created_at`) VALUES (1, 3, 1, '', '2025-07-02 07:09:39');
INSERT INTO `staff_leave_details` (`id`, `staff_id`, `leave_type_id`, `alloted_leave`, `created_at`) VALUES (2, 3, 2, '', '2025-07-02 07:09:39');
INSERT INTO `staff_leave_details` (`id`, `staff_id`, `leave_type_id`, `alloted_leave`, `created_at`) VALUES (3, 4, 2, '', '2025-07-02 07:06:34');
INSERT INTO `staff_leave_details` (`id`, `staff_id`, `leave_type_id`, `alloted_leave`, `created_at`) VALUES (4, 4, 1, '', '2025-07-02 07:06:34');
INSERT INTO `staff_leave_details` (`id`, `staff_id`, `leave_type_id`, `alloted_leave`, `created_at`) VALUES (5, 2, 1, '', '2025-07-02 07:08:24');
INSERT INTO `staff_leave_details` (`id`, `staff_id`, `leave_type_id`, `alloted_leave`, `created_at`) VALUES (6, 2, 2, '', '2025-07-02 07:08:24');
INSERT INTO `staff_leave_details` (`id`, `staff_id`, `leave_type_id`, `alloted_leave`, `created_at`) VALUES (7, 5, 2, '', '2025-07-02 07:06:45');
INSERT INTO `staff_leave_details` (`id`, `staff_id`, `leave_type_id`, `alloted_leave`, `created_at`) VALUES (8, 5, 1, '', '2025-07-02 07:06:45');


#
# TABLE STRUCTURE FOR: staff_leave_request
#

DROP TABLE IF EXISTS `staff_leave_request`;

CREATE TABLE `staff_leave_request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `leave_type_id` int(11) DEFAULT NULL,
  `leave_from` date NOT NULL,
  `leave_to` date NOT NULL,
  `leave_days` int(11) NOT NULL,
  `employee_remark` varchar(200) NOT NULL,
  `admin_remark` varchar(200) NOT NULL,
  `status` varchar(100) NOT NULL,
  `approved_date` date DEFAULT NULL,
  `applied_by` int(11) DEFAULT NULL,
  `status_updated_by` int(11) DEFAULT NULL,
  `document_file` text NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `leave_type_id` (`leave_type_id`),
  KEY `applied_by` (`applied_by`),
  KEY `index_leave_from` (`leave_from`),
  KEY `index_leave_to` (`leave_to`),
  KEY `index_leave_days` (`leave_days`),
  KEY `index_employee_remark` (`employee_remark`),
  KEY `index_admin_remark` (`admin_remark`),
  KEY `index_status` (`status`),
  KEY `index_approved_date` (`approved_date`),
  KEY `index_status_updated_by` (`status_updated_by`),
  KEY `index_date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: staff_payroll
#

DROP TABLE IF EXISTS `staff_payroll`;

CREATE TABLE `staff_payroll` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `basic_salary` float(10,2) NOT NULL,
  `pay_scale` int(11) NOT NULL,
  `grade` varchar(50) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: staff_payslip
#

DROP TABLE IF EXISTS `staff_payslip`;

CREATE TABLE `staff_payslip` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `basic` float(10,2) NOT NULL,
  `total_allowance` float(10,2) NOT NULL,
  `total_deduction` float(10,2) NOT NULL,
  `leave_deduction` int(11) NOT NULL,
  `tax` float(10,2) NOT NULL DEFAULT 0.00,
  `net_salary` float(10,2) NOT NULL,
  `status` varchar(100) NOT NULL,
  `month` varchar(200) NOT NULL,
  `year` varchar(200) NOT NULL,
  `cheque_no` varchar(250) DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `attachment_name` text DEFAULT NULL,
  `payment_mode` varchar(200) NOT NULL,
  `payment_date` date NOT NULL,
  `remark` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `generated_by` (`generated_by`),
  KEY `index_basic` (`basic`),
  KEY `index_total_allowance` (`total_allowance`),
  KEY `index_total_deduction` (`total_deduction`),
  KEY `index_leave_deduction` (`leave_deduction`),
  KEY `index_tax` (`tax`),
  KEY `index_net_salary` (`net_salary`),
  KEY `index_status` (`status`),
  KEY `index_month` (`month`),
  KEY `index_year` (`year`),
  KEY `index_cheque_no` (`cheque_no`),
  KEY `index_cheque_date` (`cheque_date`),
  KEY `index_attachment` (`attachment`),
  KEY `index_payment_mode` (`payment_mode`),
  KEY `index_payment_date` (`payment_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: staff_roles
#

DROP TABLE IF EXISTS `staff_roles`;

CREATE TABLE `staff_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  KEY `staff_id` (`staff_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `staff_roles` (`id`, `role_id`, `staff_id`, `is_active`, `created_at`) VALUES (1, 7, 1, 0, '2025-06-23 10:28:30');
INSERT INTO `staff_roles` (`id`, `role_id`, `staff_id`, `is_active`, `created_at`) VALUES (2, 3, 2, 0, '2025-06-24 08:22:35');
INSERT INTO `staff_roles` (`id`, `role_id`, `staff_id`, `is_active`, `created_at`) VALUES (3, 3, 3, 0, '2025-06-25 08:14:13');
INSERT INTO `staff_roles` (`id`, `role_id`, `staff_id`, `is_active`, `created_at`) VALUES (4, 8, 4, 0, '2025-06-25 08:15:48');
INSERT INTO `staff_roles` (`id`, `role_id`, `staff_id`, `is_active`, `created_at`) VALUES (5, 8, 5, 0, '2025-07-02 07:05:18');


#
# TABLE STRUCTURE FOR: staff_timeline
#

DROP TABLE IF EXISTS `staff_timeline`;

CREATE TABLE `staff_timeline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `title` varchar(200) NOT NULL,
  `timeline_date` date NOT NULL,
  `description` text DEFAULT NULL,
  `document` text NOT NULL,
  `status` varchar(10) NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `index_title` (`title`),
  KEY `index_timeline_date` (`timeline_date`),
  KEY `index_status` (`status`),
  KEY `index_date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: supplier_bill_basic
#

DROP TABLE IF EXISTS `supplier_bill_basic`;

CREATE TABLE `supplier_bill_basic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_no` varchar(100) NOT NULL,
  `date` datetime NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `file` varchar(200) NOT NULL,
  `total` float(10,2) NOT NULL,
  `tax` float(10,2) NOT NULL,
  `discount` float(10,2) NOT NULL,
  `net_amount` float(10,2) NOT NULL,
  `note` text DEFAULT NULL,
  `payment_mode` varchar(30) DEFAULT NULL,
  `cheque_no` varchar(255) DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `received_by` int(11) DEFAULT NULL,
  `attachment` varchar(255) DEFAULT NULL,
  `attachment_name` varchar(255) DEFAULT NULL,
  `payment_note` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `received_by` (`received_by`),
  KEY `index_total` (`total`),
  KEY `index_tax` (`tax`),
  KEY `index_discount` (`discount`),
  KEY `index_net_amount` (`net_amount`),
  KEY `index_payment_mode` (`payment_mode`),
  KEY `index_cheque_no` (`cheque_no`),
  KEY `index_cheque_date` (`cheque_date`),
  KEY `index_payment_date` (`payment_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: symptoms
#

DROP TABLE IF EXISTS `symptoms`;

CREATE TABLE `symptoms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `symptoms_title` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `type` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_symptoms_title` (`symptoms_title`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (1, 'Cavity', '', '1', '2025-06-23 10:42:20');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (2, 'Plaque', '', '1', '2025-06-23 10:42:35');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (3, 'Attrition', '', '1', '2025-06-23 10:45:09');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (4, 'Abrasion', '', '1', '2025-06-23 10:45:54');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (5, 'Missing tooth/teeth', '', '1', '2025-06-23 10:46:12');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (6, 'Discoloration', '', '1', '2025-06-23 10:46:28');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (7, 'Cracks', '', '1', '2025-06-23 10:46:42');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (8, 'Halitosis', '', '1', '2025-06-23 10:47:05');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (9, 'Bleeding gums', '', '1', '2025-06-23 10:47:18');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (10, 'Overcrowded', '', '1', '2025-06-23 10:47:42');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (11, 'Openbite', '', '1', '2025-06-23 10:48:30');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (12, 'Impacted', '', '1', '2025-06-23 10:48:56');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (13, 'Broken jaw', '', '1', '2025-06-23 10:49:20');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (14, 'Mobile teeth', '', '1', '2025-06-23 10:49:32');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (15, 'Tooth loss', '', '1', '2025-06-23 10:49:55');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (16, 'Brusism', '', '1', '2025-06-23 10:50:11');
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `type`, `created_at`) VALUES (17, 'Retain rooth', '', '1', '2025-06-23 10:50:22');


#
# TABLE STRUCTURE FOR: symptoms_classification
#

DROP TABLE IF EXISTS `symptoms_classification`;

CREATE TABLE `symptoms_classification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `symptoms_type` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_symptoms_type` (`symptoms_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `symptoms_classification` (`id`, `symptoms_type`, `created_at`) VALUES (1, 'Tooth Symptoms & Diagnosis', '2025-06-23 10:42:01');


#
# TABLE STRUCTURE FOR: system_notification
#

DROP TABLE IF EXISTS `system_notification`;

CREATE TABLE `system_notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_title` varchar(200) NOT NULL,
  `notification_type` varchar(50) NOT NULL,
  `notification_desc` text DEFAULT NULL,
  `notification_for` varchar(50) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `receiver_id` int(11) DEFAULT NULL,
  `date` datetime NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_notification_title` (`notification_title`)
) ENGINE=InnoDB AUTO_INCREMENT=409 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (1, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: CLINT (3) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-06-24 14:55:38', 'yes', '2025-06-24 13:55:38');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (2, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: CLINT (3) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-06-24 14:55:38', 'yes', '2025-06-24 13:55:38');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (3, 'New OPD Visit Created', 'opd', 'Dear: CLINT (3) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 3, '2025-06-24 14:55:38', 'yes', '2025-06-24 13:55:38');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (4, 'New Appointment Created', 'appointment', 'Appointment has been created for Patient: CLINT (3). Appointment Date: 25-06-2025 19:38   With Doctor Name: WAFULA WASIKE (O1).', '', 7, 1, '2025-06-24 19:38:32', 'yes', '2025-06-24 18:38:32');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (5, 'New Appointment Created', 'appointment', 'Appointment has been created for Patient: CLINT (3). Appointment Date: 25-06-2025 19:38   With Doctor Name: WAFULA WASIKE (O1).', '', 3, 2, '2025-06-24 19:38:32', 'yes', '2025-06-24 18:38:32');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (6, 'New Appointment Created', 'appointment', 'Dear CLINT (3) your appointment has been created with Doctor: WAFULA WASIKE (O1).', '', NULL, 3, '2025-06-24 19:38:32', 'yes', '2025-06-24 18:38:32');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (7, 'Appointment Status', 'appointment', 'Patient: CLINT (3) appointment status is approved with Doctor:  WAFULA WASIKE (O1) Date: 25-06-2025 19:38 .', '', 7, 1, '2025-06-24 19:38:32', 'yes', '2025-06-24 18:38:32');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (8, 'Appointment Status', 'appointment', 'Patient: CLINT (3) appointment status is approved with Doctor:  WAFULA WASIKE (O1) Date: 25-06-2025 19:38 .', '', 3, 2, '2025-06-24 19:38:32', 'yes', '2025-06-24 18:38:32');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (9, 'Appointment Status', 'appointment', 'Dear CLINT (3) your appointment status is approved Date: 25-06-2025 19:38  with Doctor WAFULA WASIKE (O1).', '', NULL, 3, '2025-06-24 19:38:32', 'yes', '2025-06-24 18:38:32');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (10, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: CLINT (3) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-06-25 09:10:58', 'yes', '2025-06-25 08:10:58');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (11, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: CLINT (3) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-06-25 09:10:58', 'yes', '2025-06-25 08:10:58');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (12, 'New OPD Visit Created', 'opd', 'Dear: CLINT (3) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 3, '2025-06-25 09:10:58', 'yes', '2025-06-25 08:10:58');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (13, 'New Appointment Created', 'appointment', 'Appointment has been created for Patient: CLINTON RATEMO (1). Appointment Date: 02-07-2025 17:30   With Doctor Name: WAFULA WASIKE (O1).', '', 7, 1, '2025-06-25 10:30:50', 'yes', '2025-06-25 09:30:50');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (14, 'New Appointment Created', 'appointment', 'Appointment has been created for Patient: CLINTON RATEMO (1). Appointment Date: 02-07-2025 17:30   With Doctor Name: WAFULA WASIKE (O1).', '', 3, 2, '2025-06-25 10:30:50', 'yes', '2025-06-25 09:30:50');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (15, 'New Appointment Created', 'appointment', 'Dear CLINTON RATEMO (1) your appointment has been created with Doctor: WAFULA WASIKE (O1).', '', NULL, 1, '2025-06-25 10:30:50', 'yes', '2025-06-25 09:30:50');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (16, 'Appointment Status', 'appointment', 'Patient: CLINTON RATEMO (1) appointment status is approved with Doctor:  WAFULA WASIKE (O1) Date: 02-07-2025 17:30 .', '', 7, 1, '2025-06-25 10:30:50', 'yes', '2025-06-25 09:30:50');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (17, 'Appointment Status', 'appointment', 'Patient: CLINTON RATEMO (1) appointment status is approved with Doctor:  WAFULA WASIKE (O1) Date: 02-07-2025 17:30 .', '', 3, 2, '2025-06-25 10:30:50', 'yes', '2025-06-25 09:30:50');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (18, 'Appointment Status', 'appointment', 'Dear CLINTON RATEMO (1) your appointment status is approved Date: 02-07-2025 17:30  with Doctor WAFULA WASIKE (O1).', '', NULL, 1, '2025-06-25 10:30:50', 'yes', '2025-06-25 09:30:50');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (19, 'New Appointment Created', 'appointment', 'Appointment has been created for Patient: CLINT (3). Appointment Date: 27-06-2025 10:38   With Doctor Name: EMMANUEL KIPTUM (002).', '', 7, 1, '2025-06-25 10:38:40', 'yes', '2025-06-25 09:38:40');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (20, 'New Appointment Created', 'appointment', 'Appointment has been created for Patient: CLINT (3). Appointment Date: 27-06-2025 10:38   With Doctor Name: EMMANUEL KIPTUM (002).', '', 3, 3, '2025-06-25 10:38:40', 'yes', '2025-06-25 09:38:40');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (21, 'New Appointment Created', 'appointment', 'Dear CLINT (3) your appointment has been created with Doctor: EMMANUEL KIPTUM (002).', '', NULL, 3, '2025-06-25 10:38:40', 'yes', '2025-06-25 09:38:40');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (22, 'Appointment Status', 'appointment', 'Patient: CLINT (3) appointment status is approved with Doctor:  EMMANUEL KIPTUM (002) Date: 27-06-2025 10:38 .', '', 7, 1, '2025-06-25 10:38:40', 'yes', '2025-06-25 09:38:40');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (23, 'Appointment Status', 'appointment', 'Patient: CLINT (3) appointment status is approved with Doctor:  EMMANUEL KIPTUM (002) Date: 27-06-2025 10:38 .', '', 3, 3, '2025-06-25 10:38:40', 'yes', '2025-06-25 09:38:40');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (24, 'Appointment Status', 'appointment', 'Dear CLINT (3) your appointment status is approved Date: 27-06-2025 10:38  with Doctor EMMANUEL KIPTUM (002).', '', NULL, 3, '2025-06-25 10:38:40', 'yes', '2025-06-25 09:38:40');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (25, 'New Appointment Created', 'appointment', 'Appointment has been created for Patient: CLINT (3). Appointment Date: 24-06-2025 10:46   With Doctor Name: EMMANUEL KIPTUM (002).', '', 7, 1, '2025-06-25 10:45:43', 'yes', '2025-06-25 09:45:43');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (26, 'New Appointment Created', 'appointment', 'Appointment has been created for Patient: CLINT (3). Appointment Date: 24-06-2025 10:46   With Doctor Name: EMMANUEL KIPTUM (002).', '', 3, 3, '2025-06-25 10:45:43', 'yes', '2025-06-25 09:45:43');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (27, 'New Appointment Created', 'appointment', 'Dear CLINT (3) your appointment has been created with Doctor: EMMANUEL KIPTUM (002).', '', NULL, 3, '2025-06-25 10:45:43', 'yes', '2025-06-25 09:45:43');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (28, 'Appointment Status', 'appointment', 'Patient: CLINT (3) appointment status is approved with Doctor:  EMMANUEL KIPTUM (002) Date: 24-06-2025 10:46 .', '', 7, 1, '2025-06-25 10:45:43', 'yes', '2025-06-25 09:45:43');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (29, 'Appointment Status', 'appointment', 'Patient: CLINT (3) appointment status is approved with Doctor:  EMMANUEL KIPTUM (002) Date: 24-06-2025 10:46 .', '', 3, 3, '2025-06-25 10:45:43', 'yes', '2025-06-25 09:45:43');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (30, 'Appointment Status', 'appointment', 'Dear CLINT (3) your appointment status is approved Date: 24-06-2025 10:46  with Doctor EMMANUEL KIPTUM (002).', '', NULL, 3, '2025-06-25 10:45:43', 'yes', '2025-06-25 09:45:43');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (31, 'New Appointment Created', 'appointment', 'Appointment has been created for Patient: CLINTON RATEMO (2). Appointment Date: 26-06-2025 13:15   With Doctor Name: EMMANUEL KIPTUM (002).', '', 7, 1, '2025-06-25 10:47:31', 'yes', '2025-06-25 09:47:31');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (32, 'New Appointment Created', 'appointment', 'Appointment has been created for Patient: CLINTON RATEMO (2). Appointment Date: 26-06-2025 13:15   With Doctor Name: EMMANUEL KIPTUM (002).', '', 3, 3, '2025-06-25 10:47:31', 'yes', '2025-06-25 09:47:31');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (33, 'New Appointment Created', 'appointment', 'Dear CLINTON RATEMO (2) your appointment has been created with Doctor: EMMANUEL KIPTUM (002).', '', NULL, 2, '2025-06-25 10:47:31', 'yes', '2025-06-25 09:47:31');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (34, 'Appointment Status', 'appointment', 'Patient: CLINTON RATEMO (2) appointment status is approved with Doctor:  EMMANUEL KIPTUM (002) Date: 26-06-2025 13:15 .', '', 7, 1, '2025-06-25 10:47:31', 'yes', '2025-06-25 09:47:31');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (35, 'Appointment Status', 'appointment', 'Patient: CLINTON RATEMO (2) appointment status is approved with Doctor:  EMMANUEL KIPTUM (002) Date: 26-06-2025 13:15 .', '', 3, 3, '2025-06-25 10:47:31', 'yes', '2025-06-25 09:47:31');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (36, 'Appointment Status', 'appointment', 'Dear CLINTON RATEMO (2) your appointment status is approved Date: 26-06-2025 13:15  with Doctor EMMANUEL KIPTUM (002).', '', NULL, 2, '2025-06-25 10:47:31', 'yes', '2025-06-25 09:47:31');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (37, 'New Appointment Created', 'appointment', 'Appointment has been created for Patient: CLINTON RATEMO (1). Appointment Date: 30-06-2025 10:30   With Doctor Name: WAFULA WASIKE (O1).', '', 7, 1, '2025-06-25 12:45:14', 'yes', '2025-06-25 11:45:14');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (38, 'New Appointment Created', 'appointment', 'Appointment has been created for Patient: CLINTON RATEMO (1). Appointment Date: 30-06-2025 10:30   With Doctor Name: WAFULA WASIKE (O1).', '', 3, 2, '2025-06-25 12:45:14', 'yes', '2025-06-25 11:45:14');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (39, 'New Appointment Created', 'appointment', 'Dear CLINTON RATEMO (1) your appointment has been created with Doctor: WAFULA WASIKE (O1).', '', NULL, 1, '2025-06-25 12:45:14', 'yes', '2025-06-25 11:45:14');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (40, 'Appointment Status', 'appointment', 'Patient: CLINTON RATEMO (1) appointment status is approved with Doctor:  WAFULA WASIKE (O1) Date: 30-06-2025 10:30 .', '', 7, 1, '2025-06-25 12:45:14', 'yes', '2025-06-25 11:45:14');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (41, 'Appointment Status', 'appointment', 'Patient: CLINTON RATEMO (1) appointment status is approved with Doctor:  WAFULA WASIKE (O1) Date: 30-06-2025 10:30 .', '', 3, 2, '2025-06-25 12:45:14', 'yes', '2025-06-25 11:45:14');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (42, 'Appointment Status', 'appointment', 'Dear CLINTON RATEMO (1) your appointment status is approved Date: 30-06-2025 10:30  with Doctor WAFULA WASIKE (O1).', '', NULL, 1, '2025-06-25 12:45:14', 'yes', '2025-06-25 11:45:14');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (43, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: MOHAMMED (5) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are Cavity\r\n and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-06-25 12:56:18', 'yes', '2025-06-25 11:56:18');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (44, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: MOHAMMED (5) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are Cavity\r\n and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-06-25 12:56:18', 'yes', '2025-06-25 11:56:18');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (45, 'New OPD Visit Created', 'opd', 'Dear: MOHAMMED (5) your OPD visit has been created.  Your Symptoms Details are Cavity\r\n and any known allergies: {{any_known_allergies}}. ', '', NULL, 5, '2025-06-25 12:56:18', 'yes', '2025-06-25 11:56:18');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (46, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: MOHANED (6) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-06-25 12:56:22', 'yes', '2025-06-25 11:56:22');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (47, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: MOHANED (6) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-06-25 12:56:22', 'yes', '2025-06-25 11:56:22');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (48, 'New OPD Visit Created', 'opd', 'Dear: MOHANED (6) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 6, '2025-06-25 12:56:22', 'yes', '2025-06-25 11:56:22');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (49, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Fatuma (8) with doctor: EMMANUEL KIPTUM (002). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-01 16:42:31', 'yes', '2025-07-01 15:42:31');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (50, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Fatuma (8) with doctor: EMMANUEL KIPTUM (002). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-01 16:42:31', 'yes', '2025-07-01 15:42:31');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (51, 'New OPD Visit Created', 'opd', 'Dear: Fatuma (8) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 8, '2025-07-01 16:42:31', 'yes', '2025-07-01 15:42:31');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (52, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Isaack (10) with doctor: EMMANUEL KIPTUM (002). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-01 16:52:15', 'yes', '2025-07-01 15:52:15');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (53, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Isaack (10) with doctor: EMMANUEL KIPTUM (002). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-01 16:52:15', 'yes', '2025-07-01 15:52:15');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (54, 'New OPD Visit Created', 'opd', 'Dear: Isaack (10) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 10, '2025-07-01 16:52:15', 'yes', '2025-07-01 15:52:15');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (55, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Rahama (11) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-01 16:55:06', 'yes', '2025-07-01 15:55:06');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (56, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Rahama (11) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-01 16:55:06', 'yes', '2025-07-01 15:55:06');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (57, 'New OPD Visit Created', 'opd', 'Dear: Rahama (11) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 11, '2025-07-01 16:55:06', 'yes', '2025-07-01 15:55:06');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (58, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Buke (12) with doctor: EMMANUEL KIPTUM (002). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-01 16:58:50', 'yes', '2025-07-01 15:58:50');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (59, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Buke (12) with doctor: EMMANUEL KIPTUM (002). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-01 16:58:50', 'yes', '2025-07-01 15:58:50');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (60, 'New OPD Visit Created', 'opd', 'Dear: Buke (12) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 12, '2025-07-01 16:58:50', 'yes', '2025-07-01 15:58:50');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (61, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Ramlah (13) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-01 17:05:15', 'yes', '2025-07-01 16:05:15');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (62, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Ramlah (13) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-01 17:05:15', 'yes', '2025-07-01 16:05:15');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (63, 'New OPD Visit Created', 'opd', 'Dear: Ramlah (13) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 13, '2025-07-01 17:05:15', 'yes', '2025-07-01 16:05:15');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (64, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Hale (14) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-01 17:07:21', 'yes', '2025-07-01 16:07:21');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (65, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Hale (14) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-01 17:07:21', 'yes', '2025-07-01 16:07:21');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (66, 'New OPD Visit Created', 'opd', 'Dear: Hale (14) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 14, '2025-07-01 17:07:21', 'yes', '2025-07-01 16:07:21');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (67, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Faizah (15) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-01 17:09:12', 'yes', '2025-07-01 16:09:12');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (68, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Faizah (15) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-01 17:09:12', 'yes', '2025-07-01 16:09:12');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (69, 'New OPD Visit Created', 'opd', 'Dear: Faizah (15) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 15, '2025-07-01 17:09:12', 'yes', '2025-07-01 16:09:12');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (70, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Shamsea (16) with doctor: EMMANUEL KIPTUM (002). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-01 17:33:32', 'yes', '2025-07-01 16:33:32');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (71, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Shamsea (16) with doctor: EMMANUEL KIPTUM (002). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-01 17:33:32', 'yes', '2025-07-01 16:33:32');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (72, 'New OPD Visit Created', 'opd', 'Dear: Shamsea (16) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 16, '2025-07-01 17:33:32', 'yes', '2025-07-01 16:33:32');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (73, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Bangile (17) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-02 11:46:29', 'yes', '2025-07-02 10:46:29');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (74, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Bangile (17) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-02 11:46:29', 'yes', '2025-07-02 10:46:29');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (75, 'New OPD Visit Created', 'opd', 'Dear: Bangile (17) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 17, '2025-07-02 11:46:29', 'yes', '2025-07-02 10:46:29');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (76, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Zainab (18) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-02 13:43:59', 'yes', '2025-07-02 12:43:59');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (77, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Zainab (18) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-02 13:43:59', 'yes', '2025-07-02 12:43:59');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (78, 'New OPD Visit Created', 'opd', 'Dear: Zainab (18) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 18, '2025-07-02 13:43:59', 'yes', '2025-07-02 12:43:59');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (79, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Omaar (19) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-02 13:50:24', 'yes', '2025-07-02 12:50:24');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (80, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Omaar (19) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-02 13:50:24', 'yes', '2025-07-02 12:50:24');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (81, 'New OPD Visit Created', 'opd', 'Dear: Omaar (19) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 19, '2025-07-02 13:50:24', 'yes', '2025-07-02 12:50:24');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (82, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Buke (20) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-02 16:26:48', 'yes', '2025-07-02 15:26:48');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (83, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Buke (20) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-02 16:26:48', 'yes', '2025-07-02 15:26:48');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (84, 'New OPD Visit Created', 'opd', 'Dear: Buke (20) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 20, '2025-07-02 16:26:48', 'yes', '2025-07-02 15:26:48');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (85, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Boru (21) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-02 19:14:38', 'yes', '2025-07-02 18:14:38');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (86, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Boru (21) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-02 19:14:38', 'yes', '2025-07-02 18:14:38');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (87, 'New OPD Visit Created', 'opd', 'Dear: Boru (21) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 21, '2025-07-02 19:14:38', 'yes', '2025-07-02 18:14:38');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (88, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Yurub (22) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-02 19:20:09', 'yes', '2025-07-02 18:20:09');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (89, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Yurub (22) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-02 19:20:09', 'yes', '2025-07-02 18:20:09');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (90, 'New OPD Visit Created', 'opd', 'Dear: Yurub (22) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 22, '2025-07-02 19:20:09', 'yes', '2025-07-02 18:20:09');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (91, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Daka (23) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-03 14:12:22', 'yes', '2025-07-03 13:12:22');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (92, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Daka (23) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-03 14:12:22', 'yes', '2025-07-03 13:12:22');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (93, 'New OPD Visit Created', 'opd', 'Dear: Daka (23) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 23, '2025-07-03 14:12:22', 'yes', '2025-07-03 13:12:22');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (94, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Daka (24) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-03 14:21:39', 'yes', '2025-07-03 13:21:39');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (95, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Daka (24) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-03 14:21:39', 'yes', '2025-07-03 13:21:39');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (96, 'New OPD Visit Created', 'opd', 'Dear: Daka (24) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 24, '2025-07-03 14:21:39', 'yes', '2025-07-03 13:21:39');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (97, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Daka (25) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-03 14:34:47', 'yes', '2025-07-03 13:34:47');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (98, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Daka (25) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-03 14:34:47', 'yes', '2025-07-03 13:34:47');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (99, 'New OPD Visit Created', 'opd', 'Dear: Daka (25) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 25, '2025-07-03 14:34:47', 'yes', '2025-07-03 13:34:47');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (100, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Ramlah (26) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-03 14:39:58', 'yes', '2025-07-03 13:39:58');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (101, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Ramlah (26) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-03 14:39:58', 'yes', '2025-07-03 13:39:58');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (102, 'New OPD Visit Created', 'opd', 'Dear: Ramlah (26) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 26, '2025-07-03 14:39:58', 'yes', '2025-07-03 13:39:58');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (103, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Sadam (27) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-03 14:41:48', 'yes', '2025-07-03 13:41:48');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (104, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Sadam (27) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-03 14:41:48', 'yes', '2025-07-03 13:41:48');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (105, 'New OPD Visit Created', 'opd', 'Dear: Sadam (27) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 27, '2025-07-03 14:41:48', 'yes', '2025-07-03 13:41:48');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (106, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Hassan (28) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-03 16:43:36', 'yes', '2025-07-03 15:43:36');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (107, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Hassan (28) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-03 16:43:36', 'yes', '2025-07-03 15:43:36');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (108, 'New OPD Visit Created', 'opd', 'Dear: Hassan (28) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 28, '2025-07-03 16:43:36', 'yes', '2025-07-03 15:43:36');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (109, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Rangile (29) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-03 16:48:32', 'yes', '2025-07-03 15:48:32');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (110, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Rangile (29) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-03 16:48:32', 'yes', '2025-07-03 15:48:32');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (111, 'New OPD Visit Created', 'opd', 'Dear: Rangile (29) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 29, '2025-07-03 16:48:32', 'yes', '2025-07-03 15:48:32');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (112, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Nasibo (30) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-03 18:51:34', 'yes', '2025-07-03 17:51:34');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (113, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Nasibo (30) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-03 18:51:34', 'yes', '2025-07-03 17:51:34');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (114, 'New OPD Visit Created', 'opd', 'Dear: Nasibo (30) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 30, '2025-07-03 18:51:34', 'yes', '2025-07-03 17:51:34');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (115, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Chege (31) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-03 18:55:04', 'yes', '2025-07-03 17:55:04');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (116, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Chege (31) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-03 18:55:04', 'yes', '2025-07-03 17:55:04');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (117, 'New OPD Visit Created', 'opd', 'Dear: Chege (31) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 31, '2025-07-03 18:55:04', 'yes', '2025-07-03 17:55:04');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (118, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Aminahhhhhhhhhhhhhh (32) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-03 19:21:48', 'yes', '2025-07-03 18:21:48');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (119, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Aminahhhhhhhhhhhhhh (32) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-03 19:21:48', 'yes', '2025-07-03 18:21:48');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (120, 'New OPD Visit Created', 'opd', 'Dear: Aminahhhhhhhhhhhhhh (32) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 32, '2025-07-03 19:21:48', 'yes', '2025-07-03 18:21:48');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (121, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Rose (33) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-04 12:19:50', 'yes', '2025-07-04 11:19:50');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (122, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Rose (33) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-04 12:19:50', 'yes', '2025-07-04 11:19:50');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (123, 'New OPD Visit Created', 'opd', 'Dear: Rose (33) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 33, '2025-07-04 12:19:50', 'yes', '2025-07-04 11:19:50');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (124, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Abshiro (34) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-04 14:25:14', 'yes', '2025-07-04 13:25:14');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (125, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Abshiro (34) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-04 14:25:14', 'yes', '2025-07-04 13:25:14');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (126, 'New OPD Visit Created', 'opd', 'Dear: Abshiro (34) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 34, '2025-07-04 14:25:14', 'yes', '2025-07-04 13:25:14');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (127, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Hanan (35) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-04 14:28:44', 'yes', '2025-07-04 13:28:44');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (128, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Hanan (35) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-04 14:28:44', 'yes', '2025-07-04 13:28:44');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (129, 'New OPD Visit Created', 'opd', 'Dear: Hanan (35) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 35, '2025-07-04 14:28:44', 'yes', '2025-07-04 13:28:44');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (130, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Halima (36) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-04 14:30:24', 'yes', '2025-07-04 13:30:24');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (131, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Halima (36) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-04 14:30:24', 'yes', '2025-07-04 13:30:24');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (132, 'New OPD Visit Created', 'opd', 'Dear: Halima (36) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 36, '2025-07-04 14:30:24', 'yes', '2025-07-04 13:30:24');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (133, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Buke (37) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-04 14:31:51', 'yes', '2025-07-04 13:31:51');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (134, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Buke (37) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-04 14:31:51', 'yes', '2025-07-04 13:31:51');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (135, 'New OPD Visit Created', 'opd', 'Dear: Buke (37) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 37, '2025-07-04 14:31:51', 'yes', '2025-07-04 13:31:51');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (136, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Zarah (38) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-04 18:55:56', 'yes', '2025-07-04 17:55:56');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (137, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Zarah (38) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-04 18:55:56', 'yes', '2025-07-04 17:55:56');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (138, 'New OPD Visit Created', 'opd', 'Dear: Zarah (38) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 38, '2025-07-04 18:55:56', 'yes', '2025-07-04 17:55:56');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (139, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Bonaya (39) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-04 18:57:26', 'yes', '2025-07-04 17:57:26');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (140, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Bonaya (39) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-04 18:57:26', 'yes', '2025-07-04 17:57:26');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (141, 'New OPD Visit Created', 'opd', 'Dear: Bonaya (39) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 39, '2025-07-04 18:57:26', 'yes', '2025-07-04 17:57:26');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (142, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Soores (40) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-04 19:00:41', 'yes', '2025-07-04 18:00:41');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (143, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Soores (40) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-04 19:00:41', 'yes', '2025-07-04 18:00:41');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (144, 'New OPD Visit Created', 'opd', 'Dear: Soores (40) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 40, '2025-07-04 19:00:41', 'yes', '2025-07-04 18:00:41');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (145, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Sarah (41) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-05 18:33:00', 'yes', '2025-07-05 17:33:00');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (146, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Sarah (41) with doctor: EMMANUEL KIPTUM (02). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 3, '2025-07-05 18:33:00', 'yes', '2025-07-05 17:33:00');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (147, 'New OPD Visit Created', 'opd', 'Dear: Sarah (41) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 41, '2025-07-05 18:33:00', 'yes', '2025-07-05 17:33:00');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (148, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Abshir (42) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-05 18:34:48', 'yes', '2025-07-05 17:34:48');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (149, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Abshir (42) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 3, 2, '2025-07-05 18:34:48', 'yes', '2025-07-05 17:34:48');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (150, 'New OPD Visit Created', 'opd', 'Dear: Abshir (42) your OPD visit has been created.  Your Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}}. ', '', NULL, 42, '2025-07-05 18:34:48', 'yes', '2025-07-05 17:34:48');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (151, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Balqis (44) with doctor: WAFULA WASIKE (O1). Patient Symptoms Details are {{symptoms_description}} and any known allergies: {{any_known_allergies}} .', '', 7, 1, '2025-07-05 18:42:23', 'yes', '2025-07-05 17:42:23');
INSERT INTO `system_notification` (`id`, `notification_title`, `notification_type`, `notification_desc`, `notification_for`, `role_id`, `receiver_id`, `date`, `is_active`, `created_at`) VALUES (152, 'New OPD Visit Created', 'opd', 'OPD Visit has been created for patient: Balqis (44) with doctor: W